/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.LegendProperties;

public final class TestDataGenerator {
    private static final Font[] ALL_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();

    public static Font getRandomFont(double d, double d2) {
        Font font = ALL_FONTS[(int)TestDataGenerator.getRandomNumber(ALL_FONTS.length)];
        font = font.deriveFont((float)TestDataGenerator.getRandomNumber(d, d2));
        return font;
    }

    public static double getRandomNumber(double d) {
        return Math.random() * d;
    }

    protected static double getRandomNumber(double d, double d2) {
        return d + Math.random() * (d2 - d);
    }

    public static double[] getRandomNumbers(int n, double d, double d2) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = TestDataGenerator.getRandomNumber(d, d2);
            ++n2;
        }
        return dArray;
    }

    public static double[][] getRandomNumbers(int n, int n2, double d, double d2) {
        double[][] dArray = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = TestDataGenerator.getRandomNumber(d, d2);
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }

    protected static Paint getRandomPaint() {
        if (TestDataGenerator.getRandomNumber(1.0) > 0.5) {
            return TestDataGenerator.getRandomColor();
        }
        float f = (float)TestDataGenerator.getRandomNumber(10.0, 800.0);
        float f2 = (float)TestDataGenerator.getRandomNumber(10.0, 600.0);
        float f3 = (float)TestDataGenerator.getRandomNumber(0.0, 800.0);
        float f4 = (float)TestDataGenerator.getRandomNumber(0.0, 600.0);
        return new GradientPaint(f3, f4, TestDataGenerator.getRandomColor(), f, f2, TestDataGenerator.getRandomColor());
    }

    public static Paint[] getRandomPaints(int n) {
        Paint[] paintArray = new Paint[n];
        int n2 = 0;
        while (n2 < n) {
            paintArray[n2] = TestDataGenerator.getRandomPaint();
            ++n2;
        }
        return paintArray;
    }

    protected static Color getRandomColor() {
        int n = (int)TestDataGenerator.getRandomNumber(100.0, 375.0);
        if (n > 255) {
            n = 255;
        }
        return new Color((int)TestDataGenerator.getRandomNumber(255.0), (int)TestDataGenerator.getRandomNumber(255.0), (int)TestDataGenerator.getRandomNumber(255.0), n);
    }

    protected static String getRandomString(int n, boolean bl) {
        if (bl && TestDataGenerator.getRandomNumber(10.0) <= 1.0) {
            return null;
        }
        int n2 = 1 + (int)TestDataGenerator.getRandomNumber(n);
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n2-- > 0) {
            int n3 = 65 + (int)TestDataGenerator.getRandomNumber(58.0);
            while (n3 > 90 && n3 < 97) {
                n3 = 65 + (int)TestDataGenerator.getRandomNumber(58.0);
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    protected static String[] getRandomStrings(int n, int n2, boolean bl) {
        if (bl && (int)TestDataGenerator.getRandomNumber(10.0) <= 1) {
            return null;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = TestDataGenerator.getRandomString(n2, false);
            ++n3;
        }
        return stringArray;
    }

    protected static void randomizeAxisProperties(AxisProperties axisProperties) {
        axisProperties.setYAxisNumItems((int)TestDataGenerator.getRandomNumber(1.0, 15.0));
        axisProperties.setYAxisRoundValuesToNearest((int)TestDataGenerator.getRandomNumber(-5.0, 3.0));
        axisProperties.setYAxisUseDollarSigns(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        axisProperties.setYAxisUseCommas(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        axisProperties.setShowGridLine(0, 2);
        axisProperties.setShowGridLine(1, (int)TestDataGenerator.getRandomNumber(3.0));
        axisProperties.setShowRightBorder(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        axisProperties.setShowTopBorder(TestDataGenerator.getRandomNumber(1.0) > 0.5);
        axisProperties.setShowTicks(0, 2);
        axisProperties.setShowTicks(1, (int)TestDataGenerator.getRandomNumber(3.0));
        axisProperties.setZeroLinePaint(TestDataGenerator.getRandomPaint());
        axisProperties.setScaleFont(TestDataGenerator.getRandomFont(12.0, 15.0));
        axisProperties.setAxisTitleFont(TestDataGenerator.getRandomFont(6.0, 20.0));
        axisProperties.setAxisColor(0, TestDataGenerator.getRandomPaint());
        axisProperties.setAxisColor(1, TestDataGenerator.getRandomPaint());
    }

    protected static void randomizeLegend(LegendProperties legendProperties) {
        int n = (int)TestDataGenerator.getRandomNumber(1.0, 6.0);
        if (n == 6) {
            n = 0;
        }
        legendProperties.setNumColumns(n);
        legendProperties.setPlacement((int)TestDataGenerator.getRandomNumber(2.0));
        int n2 = (int)TestDataGenerator.getRandomNumber(6.0, 20.0);
        Font font = ALL_FONTS[(int)TestDataGenerator.getRandomNumber(ALL_FONTS.length)];
        font = font.deriveFont((float)n2);
        legendProperties.setFont(font);
        legendProperties.setFontPaint(TestDataGenerator.getRandomPaint());
        if ((int)TestDataGenerator.getRandomNumber(2.0) == 0) {
            legendProperties.setBorderPaint(null);
        } else {
            legendProperties.setBorderPaint(TestDataGenerator.getRandomPaint());
        }
        if ((int)TestDataGenerator.getRandomNumber(2.0) == 0) {
            legendProperties.setBackgroundPaint(null);
        } else {
            legendProperties.setBackgroundPaint(TestDataGenerator.getRandomPaint());
        }
    }
}

