/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class CastorSourceGenTask
extends MatchingTask {
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshalling framework methods (marshall, unmarshall, validate).";
    private static final String CASTOR_TESTABLE_MSG = "The generated classes will implement org.exolab.castor.tests.CastorTestable";
    private File file = null;
    private File dir = null;
    private Vector filesets = new Vector();
    private String srcpackage;
    private String todir;
    private String types;
    private String lineseparator;
    private boolean generateImportedSchemas = false;
    private String bindingFile;
    private boolean verbose;
    private boolean warnings = true;
    private boolean overwrite = false;
    private boolean nodesc;
    private boolean nomarshall;
    private boolean testable;
    private String properties;
    SourceGenerator sgen;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setPackage(String pack) {
        this.srcpackage = pack;
    }

    public void setTodir(String dest) {
        this.todir = dest;
    }

    public void setLineseparator(String ls) {
        this.lineseparator = ls;
    }

    public void setTypes(String tf) {
        if (tf.equals("j2")) {
            tf = "arraylist";
        }
        this.types = tf;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setWarnings(boolean b) {
        this.warnings = b;
    }

    public void setNodesc(boolean b) {
        this.nodesc = b;
    }

    public void setNomarshall(boolean b) {
        this.nomarshall = b;
    }

    public void setTestable(boolean b) {
        this.testable = b;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    private void config() throws BuildException {
        if (this.types != null) {
            try {
                FieldInfoFactory factory = new FieldInfoFactory(this.types);
                this.sgen = new CastorSourceGenerator(factory);
            }
            catch (Exception e) {
                try {
                    this.sgen = new CastorSourceGenerator((FieldInfoFactory)Class.forName(this.types).newInstance());
                }
                catch (Exception e2) {
                    throw new BuildException("Invalid types \"" + this.types + "\": " + e.getMessage());
                }
            }
        } else {
            this.sgen = new CastorSourceGenerator();
        }
        String lineSep = System.getProperty("line.separator");
        if (this.lineseparator != null) {
            if ("win".equals(this.lineseparator)) {
                this.log("Using Windows style line separation.");
                lineSep = "\r\n";
            } else if ("unix".equals(this.lineseparator)) {
                this.log("Using UNIX style line separation.");
                lineSep = "\n";
            } else if ("mac".equals(this.lineseparator)) {
                this.log("Using Macintosh style line separation.");
                lineSep = "\r";
            } else {
                throw new BuildException("Invalid value for lineseparator, must be win, unix, or mac.");
            }
        }
        this.sgen.setLineSeparator(lineSep);
        this.sgen.setDestDir(this.todir);
        this.sgen.setVerbose(this.verbose);
        this.sgen.setSuppressNonFatalWarnings(!this.warnings);
        this.sgen.setDescriptorCreation(!this.nodesc);
        if (this.nodesc) {
            this.log(DISABLE_DESCRIPTORS_MSG);
        }
        this.sgen.setCreateMarshalMethods(!this.nomarshall);
        if (this.nomarshall) {
            this.log(DISABLE_MARSHALL_MSG);
        }
        this.sgen.setTestable(this.testable);
        if (this.testable) {
            this.log(CASTOR_TESTABLE_MSG);
        }
        if (this.properties != null) {
            String filePath = new File(this.properties).getAbsolutePath();
            Properties customProperties = new Properties();
            try {
                customProperties.load(new FileInputStream(filePath));
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Properties file \"" + filePath + "\" not found");
            }
            catch (IOException e) {
                throw new BuildException("Can't read properties file \"" + filePath + "\": " + e);
            }
            this.sgen.setDefaultProperties(customProperties);
        }
    }

    private void processFile(String filePath) throws BuildException {
        this.log("Processing " + filePath);
        try {
            this.sgen.generateSource(filePath, this.srcpackage);
        }
        catch (FileNotFoundException e) {
            String message = "XML Schema file \"" + this.file.getAbsolutePath() + "\" not found.";
            this.log(message);
            throw new BuildException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        try {
            this.config();
            if (this.file != null) {
                this.processFile(this.file.getAbsolutePath());
            }
            if (this.dir != null && this.dir.exists() && this.dir.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(this.dir);
                String[] files = ds.getIncludedFiles();
                for (int i = 0; i < files.length; ++i) {
                    String filePath = this.dir.getAbsolutePath() + File.separator + files[i];
                    this.processFile(filePath);
                }
            }
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File dir = fs.getDir(this.getProject());
                String[] files = ds.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String filePath = dir.getAbsolutePath() + File.separator + files[j];
                    this.processFile(filePath);
                }
            }
        }
        finally {
            this.sgen = null;
        }
    }

    private class CastorSourceGenerator
    extends SourceGenerator {
        public CastorSourceGenerator() {
        }

        public CastorSourceGenerator(FieldInfoFactory fieldInfoFactory) {
            super(fieldInfoFactory);
        }

        public CastorSourceGenerator(FieldInfoFactory fieldInfoFactory, ExtendedBinding extendedBinding) {
            super(fieldInfoFactory, extendedBinding);
        }

        public void generateSource(InputSource source, String packageName) throws BuildException {
            Parser parser = null;
            try {
                parser = LocalConfiguration.getInstance().getParser();
            }
            catch (RuntimeException e) {
                throw new BuildException("Unable to create SAX parser.", (Throwable)e);
            }
            if (parser == null) {
                throw new BuildException("Unable to create SAX parser.");
            }
            SchemaUnmarshaller schemaUnmarshaller = null;
            try {
                schemaUnmarshaller = new SchemaUnmarshaller();
            }
            catch (XMLException e) {
                throw new BuildException("Unable to create schema unmarshaller.", (Throwable)e);
            }
            Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                parser.parse(source);
            }
            catch (IOException e) {
                throw new BuildException("Can't read input file " + source.getSystemId() + ".\n" + e, (Throwable)e);
            }
            catch (SAXException e) {
                throw new BuildException("Can't parse input file " + source.getSystemId() + ".\n" + e, (Throwable)e);
            }
            Schema schema = schemaUnmarshaller.getSchema();
            this.generateSource(schema, packageName);
        }
    }
}

