/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.SignUtils;

public class OSSRequestSigner
implements RequestSigner {
    private String httpMethod;
    private String resourcePath;
    private Credentials creds;

    public OSSRequestSigner(String httpMethod, String resourcePath, Credentials creds) {
        this.httpMethod = httpMethod;
        this.resourcePath = resourcePath;
        this.creds = creds;
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        String accessKeyId = this.creds.getAccessKeyId();
        String secretAccessKey = this.creds.getSecretAccessKey();
        if (accessKeyId.length() > 0 && secretAccessKey.length() > 0) {
            String canonicalString = SignUtils.buildCanonicalString(this.httpMethod, this.resourcePath, request, null);
            String signature = ServiceSignature.create().computeSignature(secretAccessKey, canonicalString);
            request.addHeader("Authorization", OSSUtils.composeRequestAuthorization(accessKeyId, signature));
        }
    }
}

