/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.BucketReferer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class BucketRefererTest
extends TestBase {
    private static final boolean DEFAULT_EMPTY_REFERER_ALLOWED = true;

    @Test
    public void testNormalSetBucketReferer() {
        String bucketName = "normal-set-bucket-referer-source";
        String referer0 = "http://www.aliyun.com";
        String referer1 = "https://www.aliyun.com";
        String referer2 = "http://www.*.com";
        String referer3 = "https://www.?.aliyuncs.com";
        try {
            try {
                secondClient.createBucket("normal-set-bucket-referer-source");
                BucketReferer r = new BucketReferer();
                ArrayList<String> refererList = new ArrayList<String>();
                refererList.add("http://www.aliyun.com");
                refererList.add("https://www.aliyun.com");
                refererList.add("http://www.*.com");
                refererList.add("https://www.?.aliyuncs.com");
                r.setRefererList(refererList);
                secondClient.setBucketReferer("normal-set-bucket-referer-source", r);
                TestUtils.waitForCacheExpiration(5);
                r = secondClient.getBucketReferer("normal-set-bucket-referer-source");
                List<String> returedRefererList = r.getRefererList();
                Assert.assertTrue((boolean)r.isAllowEmptyReferer());
                Assert.assertTrue((boolean)returedRefererList.contains("http://www.aliyun.com"));
                Assert.assertTrue((boolean)returedRefererList.contains("https://www.aliyun.com"));
                Assert.assertTrue((boolean)returedRefererList.contains("http://www.*.com"));
                Assert.assertTrue((boolean)returedRefererList.contains("https://www.?.aliyuncs.com"));
                Assert.assertEquals((int)4, (int)returedRefererList.size());
                r.clearRefererList();
                secondClient.setBucketReferer("normal-set-bucket-referer-source", r);
                r = secondClient.getBucketReferer("normal-set-bucket-referer-source");
                returedRefererList = r.getRefererList();
                Assert.assertTrue((boolean)r.isAllowEmptyReferer());
                Assert.assertEquals((int)0, (int)returedRefererList.size());
                refererList.clear();
                refererList.add("http://www.aliyun.com");
                refererList.add("https://www.?.aliyuncs.com");
                r.setRefererList(refererList);
                r.setAllowEmptyReferer(false);
                secondClient.setBucketReferer("normal-set-bucket-referer-source", r);
                r = secondClient.getBucketReferer("normal-set-bucket-referer-source");
                returedRefererList = r.getRefererList();
                Assert.assertFalse((boolean)r.isAllowEmptyReferer());
                Assert.assertTrue((boolean)returedRefererList.contains("http://www.aliyun.com"));
                Assert.assertTrue((boolean)returedRefererList.contains("https://www.?.aliyuncs.com"));
                Assert.assertEquals((int)2, (int)returedRefererList.size());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("normal-set-bucket-referer-source");
            }
        }
        finally {
            secondClient.deleteBucket("normal-set-bucket-referer-source");
        }
    }

    @Test
    public void testUnormalSetBucketReferer() {
        String bucketName = "unormal-set-bucket-referer";
        String referer0 = "http://www.aliyun.com";
        String referer1 = "https://www.aliyun.com";
        try {
            secondClient.createBucket("unormal-set-bucket-referer");
            BucketReferer r = new BucketReferer();
            ArrayList<String> refererList = new ArrayList<String>();
            refererList.add("http://www.aliyun.com");
            refererList.add("https://www.aliyun.com");
            r.setRefererList(refererList);
            String nonexistentBucket = "nonexistent-bucket";
            try {
                secondClient.setBucketReferer("nonexistent-bucket", r);
                Assert.fail((String)"Set bucket referer should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
            }
            String bucketWithoutOwnership = "oss";
            try {
                secondClient.setBucketReferer("oss", r);
                Assert.fail((String)"Set bucket referer should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
            }
            try {
                r.setAllowEmptyReferer(false);
                r.clearRefererList();
                secondClient.setBucketReferer("unormal-set-bucket-referer", r);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
        finally {
            secondClient.deleteBucket("unormal-set-bucket-referer");
        }
    }

    @Test
    public void testUnormalGetBucketReferer() {
        String nonexistentBucket = "unormal-get-bucket-referer";
        try {
            secondClient.getBucketReferer("unormal-get-bucket-referer");
            Assert.fail((String)"Get bucket referer should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketReferer("oss");
            Assert.fail((String)"Get bucket referer should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutRefererRule = "bucket-without-referer";
        try {
            try {
                secondClient.createBucket("bucket-without-referer");
                BucketReferer r = secondClient.getBucketReferer("bucket-without-referer");
                Assert.assertEquals((boolean)true, (boolean)r.isAllowEmptyReferer());
                Assert.assertEquals((int)0, (int)r.getRefererList().size());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("bucket-without-referer");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-referer");
        }
    }
}

