/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.actions;

import java.io.IOException;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlmiddleware.utils.TokenList;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.actions.Action;
import org.xmlmiddleware.xmldbms.actions.ActionConst;
import org.xmlmiddleware.xmldbms.actions.Actions;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class ActionCompiler
implements ContentHandler {
    private XMLReader xmlReader;
    private TokenList elementTokens;
    private Actions actions;
    private Action action;
    private boolean stateDefaultAction;
    private boolean stateUpdate;
    private Hashtable uris = new Hashtable();
    private int indent;
    private boolean debug = false;
    private static String NAMESPACES = "http://xml.org/sax/features/namespaces";

    public ActionCompiler(XMLReader xMLReader) throws SAXException {
        if (xMLReader == null) {
            throw new IllegalArgumentException("xmlReader argument must not be null.");
        }
        this.xmlReader = xMLReader;
        this.xmlReader.setContentHandler(this);
        this.xmlReader.setFeature(NAMESPACES, true);
        this.initTokens();
    }

    public Actions compile(XMLDBMSMap xMLDBMSMap, InputSource inputSource) throws XMLMiddlewareException {
        if (inputSource == null || xMLDBMSMap == null) {
            throw new IllegalArgumentException("map and src arguments must not be null.");
        }
        this.stateDefaultAction = false;
        this.stateUpdate = false;
        this.uris.clear();
        this.actions = new Actions(xMLDBMSMap);
        try {
            this.xmlReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                if (exception instanceof XMLMiddlewareException) {
                    throw (XMLMiddlewareException)exception;
                }
                throw new XMLMiddlewareException(exception);
            }
            throw new XMLMiddlewareException(sAXException);
        }
        catch (IOException iOException) {
            throw new XMLMiddlewareException(iOException);
        }
        return this.actions;
    }

    public void startDocument() throws SAXException {
        if (this.debug) {
            System.out.println("Document started.");
        }
    }

    public void endDocument() throws SAXException {
        if (this.debug) {
            System.out.println("Document ended.");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debug) {
            this.indent();
            System.out.println(String.valueOf(string2) + " (start)");
            this.indent += 3;
        }
        if (!string.equals(ActionConst.URI_ACTIONSV2)) {
            throw new SAXException("Unrecognized namespace URI for action language: " + string);
        }
        try {
            switch (this.elementTokens.getToken(string2)) {
                case 1: {
                    this.processActions(attributes);
                    return;
                }
                case 2: {
                    throw new SAXException("<All> not yet implemented.");
                }
                case 3: {
                    this.processAttribute(attributes);
                    return;
                }
                case 4: {
                    this.processDefaultAction();
                    this.stateDefaultAction = true;
                    return;
                }
                case 5: {
                    this.processAction(5);
                    return;
                }
                case 6: {
                    this.processElementType(attributes);
                    return;
                }
                case 7: {
                    this.processAction(1);
                    return;
                }
                case 8: {
                    this.processNamespace(attributes);
                    return;
                }
                case 9: {
                    this.processAction(0);
                    return;
                }
                case 11: {
                    this.processUpdateProperty(null, 3);
                    return;
                }
                case 12: {
                    this.processAction(6);
                    return;
                }
                case 13: {
                    this.processAction(2);
                    return;
                }
                case 14: {
                    this.processAction(3);
                    this.stateUpdate = true;
                    return;
                }
                case 15: {
                    this.processAction(4);
                    return;
                }
                case -999: {
                    throw new XMLMiddlewareException("Unrecognized action language element type: " + string2);
                }
                default: {
                    return;
                }
            }
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.debug) {
            this.indent -= 3;
            this.indent();
            System.out.println(String.valueOf(string2) + " (end)");
        }
        if (!string.equals(ActionConst.URI_ACTIONSV2)) {
            throw new SAXException("Unrecognized namespace URI for action language: " + string);
        }
        try {
            switch (this.elementTokens.getToken(string2)) {
                case 4: {
                    this.stateDefaultAction = false;
                    return;
                }
                case 14: {
                    this.stateUpdate = false;
                    return;
                }
                case -999: {
                    throw new XMLMiddlewareException("Unrecognized action language element type: " + string2);
                }
                default: {
                    return;
                }
            }
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    private void processAction(int n) {
        this.action.setAction(n);
    }

    private void processActions(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, ActionConst.ATTR_VERSION, ActionConst.DEF_VERSION);
        if (!string.equals(ActionConst.DEF_VERSION)) {
            throw new XMLMiddlewareException("Unsupported action language version: " + string);
        }
    }

    private void processAttribute(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, ActionConst.ATTR_NAME);
        this.processUpdateProperty(XMLName.create(string, this.uris), 2);
    }

    private void processDefaultAction() {
        this.action = new Action();
        this.actions.setDefaultAction(this.action);
    }

    private void processElementType(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, ActionConst.ATTR_NAME);
        if (!this.stateUpdate) {
            this.action = this.actions.createAction(XMLName.create(string, this.uris));
            return;
        }
        this.processUpdateProperty(XMLName.create(string, this.uris), 1);
    }

    private void processNamespace(Attributes attributes) {
        String string = this.getAttrValue(attributes, ActionConst.ATTR_PREFIX);
        if (string == null) {
            string = "";
        }
        String string2 = this.getAttrValue(attributes, ActionConst.ATTR_URI);
        this.uris.put(string, string2);
    }

    private void processUpdateProperty(XMLName xMLName, int n) throws XMLMiddlewareException {
        if (this.stateDefaultAction) {
            throw new XMLMiddlewareException("When <Update> is inside <DefaultAction>, the only valid child is <All />.");
        }
        this.action.setUpdateProperty(xMLName, n);
    }

    private void initTokens() {
        this.elementTokens = new TokenList(ActionConst.ELEMS, ActionConst.ELEM_TOKENS, -999);
    }

    private String getAttrValue(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private String getAttrValue(Attributes attributes, String string, String string2) {
        String string3 = this.getAttrValue(attributes, string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private void indent() {
        int n = 0;
        while (n < this.indent) {
            System.out.print(" ");
            ++n;
        }
    }
}

