/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.conversions;

import java.math.BigDecimal;
import org.xmlmiddleware.conversions.ConvertLong;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class ConvertBigDecimal {
    private static final BigDecimal MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal MIN_DOUBLE = new BigDecimal(Double.MIN_VALUE);
    private static final BigDecimal MAX_FLOAT = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal MIN_FLOAT = new BigDecimal(1.4E-45f);
    private static final BigDecimal MAX_LONG = new BigDecimal(9.223372036854776E18);
    private static final BigDecimal MIN_LONG = new BigDecimal(-9.223372036854776E18);
    private static final BigDecimal MAX_INTEGER = new BigDecimal(2.147483647E9);
    private static final BigDecimal MIN_INTEGER = new BigDecimal(-2.147483648E9);
    private static final BigDecimal MAX_SHORT = new BigDecimal(32767.0);
    private static final BigDecimal MIN_SHORT = new BigDecimal(-32768.0);
    private static final BigDecimal MAX_BYTE = new BigDecimal(127.0);
    private static final BigDecimal MIN_BYTE = new BigDecimal(-128.0);
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigDecimal ONE = new BigDecimal(1.0);

    public static double toDouble(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(MAX_DOUBLE) == 1 || bigDecimal.compareTo(MIN_DOUBLE) == -1) {
            throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
        }
        return bigDecimal.doubleValue();
    }

    public static Double toDoubleObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Double(ConvertBigDecimal.toDouble(bigDecimal));
    }

    public static float toFloat(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(MAX_FLOAT) == 1 || bigDecimal.compareTo(MIN_FLOAT) == -1) {
            throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
        }
        return bigDecimal.floatValue();
    }

    public static Float toFloatObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Float(ConvertBigDecimal.toFloat(bigDecimal));
    }

    public static BigDecimal toBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal;
    }

    public static long toLong(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(MAX_LONG) == 1 || bigDecimal.compareTo(MIN_LONG) == -1) {
            throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
        }
        return bigDecimal.longValue();
    }

    public static Long toLongObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Long(ConvertBigDecimal.toLong(bigDecimal));
    }

    public static int toInteger(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(MAX_INTEGER) == 1 || bigDecimal.compareTo(MIN_INTEGER) == -1) {
            throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
        }
        return bigDecimal.intValue();
    }

    public static Integer toIntegerObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Integer(ConvertBigDecimal.toInteger(bigDecimal));
    }

    public static short toShort(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(MAX_SHORT) == 1 || bigDecimal.compareTo(MIN_SHORT) == -1) {
            throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
        }
        return ConvertLong.toShort(bigDecimal.longValue());
    }

    public static Short toShortObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Short(ConvertBigDecimal.toShort(bigDecimal));
    }

    public static byte toByte(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(MAX_BYTE) == 1 || bigDecimal.compareTo(MIN_BYTE) == -1) {
            throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
        }
        return ConvertLong.toByte(bigDecimal.longValue());
    }

    public static Byte toByteObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Byte(ConvertBigDecimal.toByte(bigDecimal));
    }

    public static boolean toBoolean(BigDecimal bigDecimal) throws XMLMiddlewareException {
        if (bigDecimal.compareTo(ZERO) == 0) {
            return false;
        }
        if (bigDecimal.compareTo(ONE) == 0) {
            return true;
        }
        throw new XMLMiddlewareException("Conversion resulted in truncation of significant digits.");
    }

    public static Boolean toBooleanObject(BigDecimal bigDecimal) throws XMLMiddlewareException {
        return new Boolean(ConvertBigDecimal.toBoolean(bigDecimal));
    }
}

