/*
 * Decompiled with CFR 0.152.
 */
package t4j;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import t4j.Configuration;
import t4j.TBlogException;
import t4j.TBlogSupport;
import t4j.data.Comment;
import t4j.data.DirectMessage;
import t4j.data.PagableResponseList;
import t4j.data.Paging;
import t4j.data.RecommendTopic;
import t4j.data.Status;
import t4j.data.User;
import t4j.data.Venue;
import t4j.http.AccessToken;
import t4j.http.PostParameter;
import t4j.http.RequestToken;
import t4j.http.Response;
import t4j.org.json.JSONArray;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBlog
extends TBlogSupport {
    public static final String CONSUMER_KEY = "";
    public static final String CONSUMER_SECRET = "";
    private String baseURL = String.valueOf(Configuration.getScheme()) + "api.t.163.com/";
    private String searchBaseURL = String.valueOf(Configuration.getScheme()) + "api.t.163.com/";
    private SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);

    public TBlog() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.http.setRequestTokenURL(String.valueOf(Configuration.getScheme()) + "api.t.163.com/oauth/request_token");
        this.http.setAccessTokenURL(String.valueOf(Configuration.getScheme()) + "api.t.163.com/oauth/access_token");
    }

    public void setToken(String token, String tokenSecret) {
        this.http.setToken(token, tokenSecret);
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    public void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.http.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TBlogException {
        return this.http.getOAuthRequestToken();
    }

    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws TBlogException {
        return this.http.getOAuthAccessToken(requestToken);
    }

    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TBlogException {
        AccessToken accessToken = this.http.getOAuthAccessToken(token, tokenSecret);
        this.setUserId(accessToken.getScreenName());
        return accessToken;
    }

    public AccessToken getXAuthAccessToken(String passport, String password) throws TBlogException {
        return this.http.getXAuthAccessToken(passport, password, false);
    }

    public AccessToken getXAuthAccessToken(String passport, String password, boolean isMD5) throws TBlogException {
        return this.http.getXAuthAccessToken(passport, password, isMD5);
    }

    public List<Status> getHomeTimeline() throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/home_timeline.json", true));
    }

    public List<Status> getHomeTimeline(Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/home_timeline.json", paging, true));
    }

    public List<Status> getPublicTimeline() throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/public_timeline.json", true));
    }

    public List<Status> getMentions() throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/mentions.json", true));
    }

    public List<Status> getMentions(Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/mentions.json", paging, true));
    }

    public List<Status> getUserTimeline(long userId) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json?user_id=" + String.valueOf(userId), true));
    }

    public List<Status> getUserTimeline(String screenName) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json?screen_name=" + screenName, true));
    }

    public List<Status> getUserTimeline(long userId, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json?user_id=" + String.valueOf(userId), paging, true));
    }

    public List<Status> getUserTimeline(long userId, int type, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json?user_id=" + String.valueOf(userId) + "&filter_type=" + String.valueOf(type), paging, true));
    }

    public List<Status> getUserTimeline(String screenName, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/user_timeline.json?screen_name=" + screenName, paging, true));
    }

    public List<Status> getRetweetsOfMe() throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets_of_me.json", true));
    }

    public Status updateStatus(String status) throws TBlogException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", new PostParameter[]{new PostParameter("status", status)}, true));
    }

    public Status updateStatus(String status, double latitude, double longitude) throws TBlogException {
        PostParameter[] params = new PostParameter[]{new PostParameter("status", status), new PostParameter("lat", String.valueOf(latitude)), new PostParameter("long", String.valueOf(longitude))};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", params, true));
    }

    public Status updateStatus(String status, long vid) throws TBlogException {
        PostParameter[] params = new PostParameter[]{new PostParameter("status", status), new PostParameter("vid", String.valueOf(vid))};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", params, true));
    }

    public Status updateStatus(String status, long inReplyStatusId, boolean dispatchToFollowers) throws TBlogException {
        PostParameter[] postParams = new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyStatusId)), new PostParameter("dispatch_to_followers", dispatchToFollowers ? 1 : 0)};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", postParams, true));
    }

    public Status updateStatus(String status, long inReplyStatusId, boolean dispatchToFollowers, double latitude, double longitude) throws TBlogException {
        PostParameter[] postParams = new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyStatusId)), new PostParameter("dispatch_to_followers", dispatchToFollowers ? 1 : 0), new PostParameter("lat", String.valueOf(latitude)), new PostParameter("long", String.valueOf(longitude))};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", postParams, true));
    }

    public Status updateStatus(String status, long inReplyStatusId, boolean dispatchToFollowers, long vid) throws TBlogException {
        PostParameter[] postParams = new PostParameter[]{new PostParameter("status", status), new PostParameter("in_reply_to_status_id", String.valueOf(inReplyStatusId)), new PostParameter("dispatch_to_followers", dispatchToFollowers ? 1 : 0), new PostParameter("vid", String.valueOf(vid))};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/update.json", postParams, true));
    }

    public Status retweet(long statusId) throws TBlogException {
        JSONObject json = this.http.post(String.valueOf(this.getBaseURL()) + "statuses/retweet/" + String.valueOf(statusId) + ".json", true).asJSONObject();
        try {
            if (!json.isNull("retweeted_status")) {
                return new Status(json.getJSONObject("retweeted_status"));
            }
            return null;
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
    }

    public Status retweet(long statusId, String status) throws TBlogException {
        String url = String.valueOf(this.getBaseURL()) + "statuses/retweet/" + String.valueOf(statusId) + ".json";
        PostParameter[] params = new PostParameter[]{new PostParameter("status", status)};
        return new Status(this.http.post(url, params, true));
    }

    public Status retweet(long statusId, String status, boolean is_comment, boolean is_comment_to_root) throws TBlogException {
        String url = String.valueOf(this.getBaseURL()) + "statuses/retweet/" + String.valueOf(statusId) + ".json";
        PostParameter[] params = new PostParameter[]{new PostParameter("status", status), new PostParameter("is_comment", is_comment ? 1 : 0), new PostParameter("is_comment_to_root", is_comment_to_root ? 1 : 0)};
        return new Status(this.http.post(url, params, true));
    }

    public Status showStatus(long statusId) throws TBlogException {
        return new Status(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/show/" + String.valueOf(statusId) + ".json", true));
    }

    public List<Comment> getComments(long id) throws TBlogException {
        return Comment.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments/" + String.valueOf(id) + ".json", true));
    }

    public List<Comment> getComments(long id, Paging paging) throws TBlogException {
        return Comment.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments/" + String.valueOf(id) + ".json", paging, true));
    }

    public List<Status> getRetweets(long id) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets/" + String.valueOf(id) + ".json", true));
    }

    public List<Status> getRetweets(long id, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/retweets/" + String.valueOf(id) + ".json", paging, true));
    }

    public List<Status> getTopRetweets(TopRetweetsType type) throws TBlogException {
        Response res = this.get(String.valueOf(this.getBaseURL()) + "statuses/topRetweets/" + (Object)((Object)type) + ".json", true);
        JSONArray array = res.asJSONArray();
        ArrayList<Status> statuses = new ArrayList<Status>(array.length());
        int i = 0;
        while (i < array.length()) {
            try {
                statuses.add(new Status(array.getJSONObject(i).getJSONObject("status")));
            }
            catch (JSONException e) {
                return statuses;
            }
            ++i;
        }
        return statuses;
    }

    public List<RecommendTopic> getRecommendedTopics() throws TBlogException {
        JSONArray trends;
        Response res = this.get(String.valueOf(this.getBaseURL()) + "trends/recommended.json", true);
        try {
            trends = res.asJSONObject().getJSONArray("trends");
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
        return RecommendTopic.constructTopics(trends);
    }

    public Status destroy(long statusId) throws TBlogException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/destroy/" + String.valueOf(statusId) + ".json", true));
    }

    public User showUser(long userId) throws TBlogException {
        return new User(this.http.get(String.valueOf(this.getBaseURL()) + "users/show.json?id=" + String.valueOf(userId), true));
    }

    public User showUser(String screenName) throws TBlogException {
        return new User(this.http.get(String.valueOf(this.getBaseURL()) + "users/show.json?screen_name=" + screenName, true));
    }

    public PagableResponseList<User> friends(long userId) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json?user_id=" + String.valueOf(userId), true));
    }

    public PagableResponseList<User> friends(long userId, long cursor) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json?user_id=" + String.valueOf(userId) + "&cursor=" + String.valueOf(cursor), true));
    }

    public PagableResponseList<User> friends(String screenName) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json?screen_name=" + screenName, true));
    }

    public PagableResponseList<User> friends(String screenName, long cursor) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/friends.json?screen_name=" + screenName + "&cursor=" + String.valueOf(cursor), true));
    }

    public PagableResponseList<User> followers(long userId) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json?user_id=" + String.valueOf(userId), true));
    }

    public PagableResponseList<User> followers(long userId, long cursor) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json?user_id=" + String.valueOf(userId) + "&cursor=" + String.valueOf(cursor), true));
    }

    public PagableResponseList<User> followers(String screenName) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json?screen_name=" + String.valueOf(screenName), true));
    }

    public PagableResponseList<User> followers(String screenName, long cursor) throws TBlogException {
        return User.createPagableUserList(this.http.get(String.valueOf(this.getBaseURL()) + "statuses/followers.json?screen_name=" + String.valueOf(screenName) + "&cursor=" + String.valueOf(cursor), true));
    }

    public User createFriendship(long userId) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create.json?user_id=" + String.valueOf(userId), true));
    }

    public User createFriendship(String screenName) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/create.json?screen_name=" + String.valueOf(screenName), true));
    }

    public User destroyFriendship(long userId) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/destroy.json?user_id=" + String.valueOf(userId), true));
    }

    public User destroyFriendship(String screenName) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "friendships/destroy.json?screen_name=" + String.valueOf(screenName), true));
    }

    public JSONObject showFriendship(long sourceId, long targetId) throws TBlogException {
        return this.get(String.valueOf(this.getBaseURL()) + "friendships/show.json?source_id=" + String.valueOf(sourceId) + "&target_id=" + String.valueOf(targetId), true).asJSONObject();
    }

    public JSONObject showFriendship(long targetId) throws TBlogException {
        return this.get(String.valueOf(this.getBaseURL()) + "friendships/show.json?target_id=" + String.valueOf(targetId), true).asJSONObject();
    }

    public List<DirectMessage> getDirectMessages() throws TBlogException {
        return DirectMessage.createDirectMessageList(this.get(String.valueOf(this.getBaseURL()) + "direct_messages.json", true));
    }

    public List<DirectMessage> getDirectMessages(Paging paging) throws TBlogException {
        return DirectMessage.createDirectMessageList(this.get(String.valueOf(this.getBaseURL()) + "direct_messages.json", paging, true));
    }

    public DirectMessage sendDirectMessage(String user, String text) throws TBlogException {
        PostParameter[] params = new PostParameter[]{new PostParameter("user", user), new PostParameter("text", text)};
        return new DirectMessage(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/new.json", params, true));
    }

    public DirectMessage destroyDirectMessage(long id) throws TBlogException {
        return new DirectMessage(this.http.post(String.valueOf(this.getBaseURL()) + "direct_messages/destroy/" + String.valueOf(id) + ".json", true));
    }

    public List<DirectMessage> getSentDirectMessages() throws TBlogException {
        return DirectMessage.createDirectMessageList(this.get(String.valueOf(this.getBaseURL()) + "direct_messages/sent.json", true));
    }

    public List<Status> getFavorites(long id) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites/" + String.valueOf(id) + ".json", true));
    }

    public List<Status> getFavorites(long id, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "favorites/" + String.valueOf(id) + ".json", paging, true));
    }

    public Status createFavorite(long id) throws TBlogException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/create/" + String.valueOf(id) + ".json", true));
    }

    public Status destroyFavorite(long id) throws TBlogException {
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "favorites/destroy/" + String.valueOf(id) + ".json", true));
    }

    public User verifyCredentials() throws TBlogException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "account/verify_credentials.json", true));
    }

    public User createBlock(long id) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/create.json?user_id=" + String.valueOf(id), true));
    }

    public User createBlock(String screenName) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/create.json?screen_name=" + screenName, true));
    }

    public User destroyBlock(long id) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/destroy.json?user_id=" + String.valueOf(id), true));
    }

    public User destroyBlock(String screenName) throws TBlogException {
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + "blocks/destroy.json?screen_name=" + screenName, true));
    }

    public User existsBlock(long id) throws TBlogException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "blocks/exists.json?user_id=" + String.valueOf(id), true));
    }

    public User existsBlock(String screenName) throws TBlogException {
        return new User(this.get(String.valueOf(this.getBaseURL()) + "blocks/exists.json?screen_name=" + String.valueOf(screenName), true));
    }

    public List<User> getBlockUsers() throws TBlogException {
        return User.createUserList(this.get(String.valueOf(this.getBaseURL()) + "blocks/blocking.json", true));
    }

    public long[] getBlockUserIds() throws TBlogException {
        JSONArray list = this.get(String.valueOf(this.getBaseURL()) + "blocks/blocking/ids.json", true).asJSONArray();
        long[] result = new long[list.length()];
        int i = 0;
        while (i < list.length()) {
            try {
                result[i] = list.getLong(i);
            }
            catch (JSONException jsone) {
                throw new TBlogException(jsone);
            }
            ++i;
        }
        return result;
    }

    public String updateImage(File file) throws TBlogException {
        JSONObject json = this.http.multPartURL("pic", String.valueOf(this.getBaseURL()) + "statuses/upload.json", new PostParameter[0], file, true).asJSONObject();
        try {
            if (!json.isNull("upload_image_url")) {
                return json.getString("upload_image_url");
            }
            return null;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
    }

    public JSONObject getLatestMessages() throws TBlogException {
        return this.get(String.valueOf(this.getBaseURL()) + "reminds/message/latest.json", true).asJSONObject();
    }

    public JSONObject getLatestMessages(long timestamp) throws TBlogException {
        return this.get(String.valueOf(this.getBaseURL()) + "reminds/message/latest.json?last_visit_time_millis=" + timestamp, true).asJSONObject();
    }

    public List<Status> searchStatus(String query) throws TBlogException {
        try {
            JSONObject json = this.get(String.valueOf(this.getBaseURL()) + "search.json?q=" + query, true).asJSONObject();
            if (json.isNull("results")) {
                return new ArrayList<Status>(0);
            }
            return Status.constructStatuses(json.getJSONArray("results"));
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
    }

    public List<Status> search(String query, int page, int perPage) throws TBlogException {
        String url = String.format(String.valueOf(this.getBaseURL()) + "statuses/search.json?q=%s&page=%s&perPage=%s", query, page, perPage);
        JSONArray json = this.get(url, true).asJSONArray();
        return Status.constructStatuses(json);
    }

    public List<Status> searchStatus(String query, int page, int pageSize) throws TBlogException {
        try {
            JSONObject json = this.get(String.valueOf(this.getBaseURL()) + "search.json?q=" + query + "&page=" + String.valueOf(page) + "&per_page=" + String.valueOf(pageSize), true).asJSONObject();
            if (json.isNull("results")) {
                return new ArrayList<Status>(0);
            }
            return Status.constructStatuses(json.getJSONArray("results"));
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
    }

    public List<User> searchUser(String query) throws TBlogException {
        return User.createUserList(this.get(String.valueOf(this.getBaseURL()) + "users/search.json?" + "q=" + query, true));
    }

    public List<User> searchUser(String query, int page, int pageSize) throws TBlogException {
        return User.createUserList(this.get(String.valueOf(this.getBaseURL()) + "users/search.json?" + "q=" + query + "&page=" + String.valueOf(page) + "&per_page=" + String.valueOf(pageSize), true));
    }

    public List<Venue> getVenues(double latitude, double longitude) throws TBlogException {
        return Venue.createVenueList(this.get(String.valueOf(this.getBaseURL()) + String.format("location/venues.json?lat=%s&long=%s", String.valueOf(latitude), String.valueOf(longitude)), true));
    }

    public List<Venue> getVenues(double latitude, double longitude, String query) throws TBlogException {
        return Venue.createVenueList(this.get(String.valueOf(this.getBaseURL()) + String.format("location/venues.json?lat=%s&long=%s&q=%s", String.valueOf(latitude), String.valueOf(longitude), query), true));
    }

    public List<Venue> getVenues(double latitude, double longitude, int count) throws TBlogException {
        return Venue.createVenueList(this.get(String.valueOf(this.getBaseURL()) + String.format("location/venues.json?lat=%s&long=%s&count=%s", String.valueOf(latitude), String.valueOf(longitude), String.valueOf(count)), true));
    }

    public List<Venue> getVenues(double latitude, double longitude, int count, String query) throws TBlogException {
        return Venue.createVenueList(this.get(String.valueOf(this.getBaseURL()) + String.format("location/venues.json?lat=%s&long=%s&count=%s&q=%s", String.valueOf(latitude), String.valueOf(longitude), String.valueOf(count), query), true));
    }

    public List<Status> getLocationTimeline(double latitude, double longitude) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + String.format("statuses/location_timeline.json?lat=%s&long=%s", String.valueOf(latitude), String.valueOf(longitude)), true));
    }

    public List<Status> getLocationTimeline(double latitude, double longitude, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + String.format("statuses/location_timeline.json?lat=%s&long=%s", String.valueOf(latitude), String.valueOf(longitude)), paging, true));
    }

    public List<Status> getLocationTimeline(long vid) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + String.format("statuses/location_timeline.json?vid=%s", String.valueOf(vid)), true));
    }

    public List<Status> getLocationTimeline(long vid, Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + String.format("statuses/location_timeline.json?vid=%s", String.valueOf(vid)), paging, true));
    }

    public Status updateImage(String status, File file) throws TBlogException {
        String url = this.updateImage(file);
        int i = 0;
        while (i < 3) {
            if (url != null) break;
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                break;
            }
            url = this.updateImage(file);
            ++i;
        }
        String text = null;
        if (url == null) {
            throw new TBlogException("\u9365\u5267\u5896\u93c8\u5d85\u59df\u9363\u3125\u7e56\u951b\u5c83\ue1ec\u7ecb\u5d85\u6097\u9350\u5d88\u762f\u951b\ufffd");
        }
        text = String.valueOf(status) + url;
        return this.updateStatus(text);
    }

    public User updatePassword(String oldPassword, String newPassword) throws TBlogException {
        String url = "account/update_password.json";
        PostParameter[] params = new PostParameter[]{new PostParameter("old_password", oldPassword), new PostParameter("new_password", newPassword)};
        return new User(this.http.post(String.valueOf(this.getBaseURL()) + url, params, true));
    }

    public List<Status> getCommentsByMe() throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_by_me.json", true));
    }

    public List<Status> getCommentsByMe(Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_by_me.json", paging, true));
    }

    public List<Status> getCommentsToMe() throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_to_me.json", true));
    }

    public List<Status> getCommentsToMe(Paging paging) throws TBlogException {
        return Status.constructStatuses(this.get(String.valueOf(this.getBaseURL()) + "statuses/comments_to_me.json", paging, true));
    }

    public Status reply(long id, String status) throws TBlogException {
        PostParameter[] params = new PostParameter[]{new PostParameter("id", String.valueOf(id)), new PostParameter("status", status)};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/reply.json", params, true));
    }

    public Status reply(long id, String status, boolean is_retweet, boolean is_comment_to_root) throws TBlogException {
        PostParameter[] params = new PostParameter[]{new PostParameter("id", String.valueOf(id)), new PostParameter("status", status), new PostParameter("is_retweet", is_retweet ? 1 : 0), new PostParameter("is_comment_to_root", is_comment_to_root ? 1 : 0)};
        return new Status(this.http.post(String.valueOf(this.getBaseURL()) + "statuses/reply.json", params, true));
    }

    public List<User> suggestedUsers(int count) throws TBlogException {
        Response res = this.http.get(String.valueOf(this.getBaseURL()) + "users/suggestions.json?count=" + String.valueOf(count), true);
        JSONArray users = null;
        try {
            users = res.asJSONObject().getJSONArray("users");
        }
        catch (JSONException e) {
            return new ArrayList<User>(0);
        }
        if (users == null) {
            return new ArrayList<User>(0);
        }
        return User.createUserList(users);
    }

    public List<User> suggestedIFollowers() throws TBlogException {
        return this.suggestedIFollowers(0);
    }

    public List<User> suggestedIFollowers(int cursor) throws TBlogException {
        Response res = this.http.get(String.valueOf(this.getBaseURL()) + "users/suggestions_i_followers.json?cursor=" + cursor, true);
        JSONArray users = null;
        try {
            users = res.asJSONObject().getJSONArray("users");
        }
        catch (JSONException e) {
            return new ArrayList<User>(0);
        }
        if (users == null) {
            return new ArrayList<User>(0);
        }
        return User.createUserList(users);
    }

    public List<String> friendsNames() throws TBlogException {
        Response result = this.http.get(String.valueOf(this.getBaseURL()) + "friends/names.json", true);
        JSONArray array = result.asJSONArray();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < array.length()) {
            try {
                names.add(array.getString(i));
            }
            catch (JSONException e) {
                return names;
            }
            ++i;
        }
        return names;
    }

    public long activateAccount(String nickName, String realName, String mobile, String idNum) throws TBlogException {
        long id;
        ArrayList<PostParameter> params = new ArrayList<PostParameter>();
        params.add(new PostParameter("nick_name", nickName));
        if (realName != null && realName.length() != 0) {
            params.add(new PostParameter("real_name", realName));
        }
        if (mobile != null && mobile.length() != 0) {
            params.add(new PostParameter("mobile", mobile));
        }
        if (idNum != null && idNum.length() != 0) {
            params.add(new PostParameter("id_num", idNum));
        }
        try {
            id = this.http.post(String.valueOf(this.getBaseURL()) + "account/activate.json", params.toArray(new PostParameter[params.size()]), true).asJSONObject().getLong("id");
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
        return id;
    }

    public User updateProfile(String nickName, String realName, String description, String province, String city) throws TBlogException {
        String[] args = new String[]{"nick_name", "real_name", "description", "province", "city"};
        String[] values = new String[]{nickName, realName, description, province, city};
        ArrayList<PostParameter> params = new ArrayList<PostParameter>();
        int i = 0;
        while (i < values.length) {
            if (values[i] != null && values[i].length() != 0) {
                params.add(new PostParameter(args[i], values[i]));
            }
            ++i;
        }
        Response res = this.http.post(String.valueOf(this.getBaseURL()) + "account/update_profile.json", params.toArray(new PostParameter[params.size()]), true);
        return new User(res);
    }

    public User updateProfileImage(File file) throws TBlogException {
        Response res = this.http.multPartURL("img", String.valueOf(this.getBaseURL()) + "account/update_profile_image.json", new PostParameter[0], file, true);
        return new User(res);
    }

    private Response get(String url, boolean authenticated) throws TBlogException {
        return this.http.get(url, authenticated);
    }

    protected Response get(String url, Paging paging, boolean authenticate) throws TBlogException {
        String paramList = "";
        if (paging != null) {
            ArrayList<String> params = new ArrayList<String>();
            try {
                if (paging.getMaxId() != null && !"".equals(paging.getMaxId())) {
                    params.add("max_id=" + URLEncoder.encode(String.valueOf(paging.getMaxId()), "UTF-8"));
                }
                if (paging.getSinceId() != null && !"".equals(paging.getSinceId())) {
                    params.add("since_id=" + URLEncoder.encode(String.valueOf(paging.getSinceId()), "UTF-8"));
                }
                if (-1 != paging.getCount()) {
                    params.add("count=" + URLEncoder.encode(String.valueOf(paging.getCount()), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new TBlogException(ex);
            }
            paramList = TBlog.join(params.toArray(new String[0]), "&");
        }
        if (paramList.length() == 0) {
            return this.get(url, authenticate);
        }
        if (url.indexOf(63) == -1) {
            return this.get(String.valueOf(url) + "?" + paramList, authenticate);
        }
        return this.get(String.valueOf(url) + "&" + paramList, authenticate);
    }

    private static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return TBlog.join(array, separator, 0, array.length);
    }

    private static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int bufSize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((bufSize = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());
        int i = startIndex;
        while (i < endIndex) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] != null) {
                buf.append(array[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TopRetweetsType {
        oneHour,
        sixHours,
        oneDay,
        oneWeek;

    }
}

