/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.util.StringUtils;

public class MethodUtils {
    private static Object getEntryPoint(Class targetClass, String methodName, Class[] argTypes, boolean isStaticReference) throws SecurityException, NoSuchMethodException {
        Object m = null;
        try {
            if (methodName != null) {
                m = targetClass.getMethod(methodName, argTypes);
                if (isStaticReference && !Modifier.isStatic(MethodUtils.entryGetModifiers(m))) {
                    throw new NoSuchMethodException(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference) + " resolved to instance " + m);
                }
                return m;
            }
            return targetClass.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            if (argTypes == null || argTypes.length == 0) {
                throw new NoSuchMethodException(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference) + " not found.");
            }
            Executable[] methods = methodName != null ? targetClass.getMethods() : targetClass.getConstructors();
            if (0 == methods.length) {
                throw new NoSuchMethodException("No methods!");
            }
            MoreSpecific best = new MoreSpecific();
            for (int i = 0; i < methods.length; ++i) {
                Executable mi = methods[i];
                if (!Modifier.isPublic(MethodUtils.entryGetModifiers(mi)) || methodName != null && !MethodUtils.entryGetName(mi).equals(methodName) || !MethodUtils.areMethodConvertable(MethodUtils.entryGetParameterTypes(mi), argTypes)) continue;
                best.addItem(mi);
            }
            m = best.getMostSpecific(targetClass, methodName, argTypes, isStaticReference);
            if (m == null) {
                throw new NoSuchMethodException(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference) + " -- no signature match");
            }
            if (methodName != null && isStaticReference && !Modifier.isStatic(MethodUtils.entryGetModifiers(m))) {
                throw new NoSuchMethodException(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference) + " resolved to instance: " + m);
            }
            return m;
        }
    }

    private static String callToString(Class targetClass, String methodName, Class[] argTypes, boolean isStaticReference) {
        StringBuffer buf = new StringBuffer(256);
        if (isStaticReference) {
            buf.append("static ");
        }
        buf.append(StringUtils.getClassName(targetClass));
        if (methodName != null) {
            buf.append(".").append(methodName);
        }
        buf.append("(");
        if (argTypes != null && argTypes.length > 0) {
            buf.append(StringUtils.getClassName(argTypes[0]));
            for (int i = 1; i < argTypes.length; ++i) {
                buf.append(",").append(StringUtils.getClassName(argTypes[i]));
            }
        } else {
            buf.append("[none]");
        }
        buf.append(")");
        return buf.toString();
    }

    private static boolean isMethodConvertable(Class parm, Class arg) {
        int argscore;
        int parmscore;
        if (parm.equals(arg)) {
            return true;
        }
        if (arg == null) {
            return !parm.isPrimitive();
        }
        while (parm.isArray()) {
            if (!arg.isArray()) {
                return false;
            }
            parm = parm.getComponentType();
            arg = arg.getComponentType();
        }
        if (arg.isArray()) {
            return false;
        }
        if (parm.isAssignableFrom(arg)) {
            return true;
        }
        if (parm.equals(Void.TYPE) || parm.equals(Boolean.TYPE) || arg.equals(Void.TYPE) || arg.equals(Boolean.TYPE)) {
            return false;
        }
        Class[] primTypes = new Class[]{Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        for (parmscore = 0; parmscore < primTypes.length && !parm.equals(primTypes[parmscore]); ++parmscore) {
        }
        if (parmscore >= primTypes.length) {
            return false;
        }
        for (argscore = 0; argscore < primTypes.length && !arg.equals(primTypes[argscore]); ++argscore) {
        }
        if (argscore >= primTypes.length) {
            return false;
        }
        return argscore < parmscore && (argscore != 0 || parmscore > 2);
    }

    private static boolean isAssignmentConvertable(Class parm, Class arg) {
        return arg.equals(Integer.TYPE) && (parm.equals(Byte.TYPE) || parm.equals(Short.TYPE) || parm.equals(Character.TYPE)) || MethodUtils.isMethodConvertable(parm, arg);
    }

    private static boolean areMethodConvertable(Class[] parms, Class[] args) {
        if (parms.length != args.length) {
            return false;
        }
        for (int i = 0; i < parms.length; ++i) {
            if (MethodUtils.isMethodConvertable(parms[i], args[i])) continue;
            return false;
        }
        return true;
    }

    static String entryGetName(Object entry) {
        return entry instanceof Method ? ((Method)entry).getName() : ((Constructor)entry).getName();
    }

    static int entryGetModifiers(Object entry) {
        return entry instanceof Method ? ((Method)entry).getModifiers() : ((Constructor)entry).getModifiers();
    }

    static Class[] entryGetParameterTypes(Object entry) {
        return entry instanceof Method ? ((Method)entry).getParameterTypes() : ((Constructor)entry).getParameterTypes();
    }

    static String entryToString(Object entry) {
        return entry instanceof Method ? ((Method)entry).toString() : ((Constructor)entry).toString();
    }

    public static Method getMethod(Object target, String methodName, Class[] argTypes) throws SecurityException, NoSuchMethodException {
        boolean staticRef = target instanceof Class;
        return MethodUtils.getMethod(staticRef ? (Class<?>)target : target.getClass(), methodName, argTypes, staticRef);
    }

    public static Method getMethod(Class target, String methodName, Class[] argTypes, boolean isStaticReference) throws SecurityException, NoSuchMethodException {
        return (Method)MethodUtils.getEntryPoint(target, methodName, argTypes, isStaticReference);
    }

    public static Constructor getConstructor(Class targetClass, Class[] argTypes) throws SecurityException, NoSuchMethodException {
        return (Constructor)MethodUtils.getEntryPoint(targetClass, null, argTypes, true);
    }

    private static class MoreSpecific
    extends Vector {
        private MoreSpecific() {
        }

        void addItem(Object newEntry) {
            if (this.size() == 0) {
                this.addElement(newEntry);
            } else {
                Class[] newargs = MethodUtils.entryGetParameterTypes(newEntry);
                boolean keep = true;
                Enumeration e = this.elements();
                while (keep & e.hasMoreElements()) {
                    Object oldEntry = e.nextElement();
                    Class[] oldargs = MethodUtils.entryGetParameterTypes(oldEntry);
                    if (MethodUtils.areMethodConvertable(oldargs, newargs)) {
                        this.removeElement(oldEntry);
                        continue;
                    }
                    if (!MethodUtils.areMethodConvertable(newargs, oldargs)) continue;
                    keep = false;
                }
                if (keep) {
                    this.addElement(newEntry);
                }
            }
        }

        Object getMostSpecific(Class targetClass, String methodName, Class[] argTypes, boolean isStaticReference) throws NoSuchMethodException {
            if (this.size() == 1) {
                return this.firstElement();
            }
            if (this.size() > 1) {
                StringBuffer buf = new StringBuffer(256);
                Enumeration e = this.elements();
                buf.append(e.nextElement());
                while (e.hasMoreElements()) {
                    buf.append(" and ").append(e.nextElement());
                }
                throw new NoSuchMethodException(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference) + " is ambiguous. It matches " + buf.toString());
            }
            return null;
        }
    }
}

