/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;
import org.jfree.xml.generator.DefaultModelReader;
import org.jfree.xml.generator.JavaSourceCollector;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.SplittingModelWriter;
import org.jfree.xml.generator.model.DescriptionModel;

public final class DescriptionGenerator {
    static /* synthetic */ Class class$org$jfree$xml$generator$DescriptionGenerator;

    private static Properties loadProperties(URL uRL) {
        Properties properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load properties from " + uRL);
        }
        return properties;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        Serializable serializable;
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        URL uRL = (class$org$jfree$xml$generator$DescriptionGenerator == null ? (class$org$jfree$xml$generator$DescriptionGenerator = DescriptionGenerator.class$("org.jfree.xml.generator.DescriptionGenerator")) : class$org$jfree$xml$generator$DescriptionGenerator).getResource("generator.properties");
        if (stringArray.length > 0) {
            serializable = new File(stringArray[0]);
            uRL = ((File)serializable).toURL();
        }
        if ((string = ((Properties)(serializable = DescriptionGenerator.loadProperties(uRL))).getProperty("attributedefinition")) != null) {
            object = DescriptionGenerator.loadProperties(new URL(uRL, string));
            ModelBuilder.getInstance().addAttributeHandlers((Properties)object);
        }
        object = ((Properties)serializable).getProperty("sourcedirectory", ".");
        String string2 = ((Properties)serializable).getProperty("targetfile", "model.xml");
        DescriptionModel descriptionModel = null;
        try {
            descriptionModel = new DefaultModelReader().load(string2);
        }
        catch (Exception exception) {
            Log.debug("Unable to load default model. Ignoring...");
        }
        descriptionModel = DescriptionGenerator.generate((String)object, (Properties)serializable, descriptionModel);
        descriptionModel.prune();
        DescriptionGenerator.writeMultiFile(string2, descriptionModel);
        System.exit(0);
    }

    public static DescriptionModel generate(String string, Properties properties, DescriptionModel descriptionModel) {
        JavaSourceCollector javaSourceCollector = new JavaSourceCollector(new File(string));
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.startsWith("ignore.baseclass.")) {
                javaSourceCollector.addIgnoredBaseClass(properties.getProperty(string2));
                continue;
            }
            if (!string2.startsWith("ignore.package.")) continue;
            javaSourceCollector.addIgnoredPackage(properties.getProperty(string2));
        }
        javaSourceCollector.collectFiles();
        return ModelBuilder.getInstance().buildModel(javaSourceCollector, descriptionModel);
    }

    public static void writeSingleFile(String string, DescriptionModel descriptionModel) throws IOException {
        Log.debug("Writing ...");
        ModelWriter modelWriter = new ModelWriter();
        modelWriter.setModel(descriptionModel);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        modelWriter.write(bufferedWriter);
        ((Writer)bufferedWriter).close();
    }

    public static void writeMultiFile(String string, DescriptionModel descriptionModel) throws IOException {
        Log.debug("Writing multiple files ...");
        SplittingModelWriter splittingModelWriter = new SplittingModelWriter();
        splittingModelWriter.setModel(descriptionModel);
        splittingModelWriter.write(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

