/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartImage;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.Storage;
import de.laures.cewolf.storage.SerializableChartImage;
import de.laures.cewolf.taglib.util.KeyGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class FileStorage
implements Storage {
    String basePath = null;
    List stored = new ArrayList();
    private boolean deleteOnExit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String storeChartImage(ChartImage cid, PageContext pageContext) {
        if (this.contains(cid, pageContext)) {
            return this.getKey(cid);
        }
        String id = this.getKey(cid);
        ObjectOutputStream oos = null;
        String fileName = this.getFileName(id);
        pageContext.getServletContext().log("Storing image to file " + fileName);
        File f = new File(fileName);
        if (this.deleteOnExit) {
            f.deleteOnExit();
        }
        oos = new ObjectOutputStream(new FileOutputStream(f));
        oos.writeObject(new SerializableChartImage(cid));
        oos.close();
        Object var8_9 = null;
        if (oos == null) return id;
        try {
            oos.close();
            return id;
        }
        catch (IOException ioex2) {
            ioex2.printStackTrace();
        }
        return id;
        {
            catch (IOException ioex) {
                ioex.printStackTrace();
                Object var8_10 = null;
                if (oos == null) return id;
                try {
                    oos.close();
                    return id;
                }
                catch (IOException ioex2) {
                    ioex2.printStackTrace();
                }
                return id;
            }
            catch (CewolfException cwex) {
                cwex.printStackTrace();
                Object var8_11 = null;
                if (oos == null) return id;
                try {
                    oos.close();
                    return id;
                }
                catch (IOException ioex2) {
                    ioex2.printStackTrace();
                }
                return id;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ioex2) {
                ioex2.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChartImage getChartImage(String id, HttpServletRequest request) {
        ChartImage res = null;
        ObjectInputStream ois = null;
        ois = new ObjectInputStream(new FileInputStream(this.getFileName(id)));
        res = (ChartImage)ois.readObject();
        ois.close();
        Object var7_5 = null;
        if (ois == null) return res;
        try {
            ois.close();
            return res;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return res;
        {
            catch (Exception ex) {
                ex.printStackTrace();
                Object var7_6 = null;
                if (ois == null) return res;
                try {
                    ois.close();
                    return res;
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
                return res;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            throw throwable;
        }
    }

    public boolean contains(ChartImage chartImage, PageContext pageContext) {
        return new File(this.getFileName(chartImage)).exists();
    }

    public String getKey(ChartImage chartImage) {
        return String.valueOf(KeyGenerator.generateKey((Serializable)((Object)chartImage)));
    }

    public void init(ServletContext servletContext) throws CewolfException {
        this.basePath = servletContext.getRealPath("/");
        Configuration config = Configuration.getInstance(servletContext);
        this.deleteOnExit = "true".equalsIgnoreCase("" + config.getParameters().get("FileStorage.deleteOnExit"));
        servletContext.log("FileStorage initialized, deleteOnExit=" + this.deleteOnExit);
    }

    private String getFileName(ChartImage chartImage) {
        return this.getFileName(this.getKey(chartImage));
    }

    private String getFileName(String id) {
        return this.basePath + "_chart" + id;
    }
}

