/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGConvolveOp
extends AbstractSVGFilterConverter {
    public SVGConvolveOp(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        if (bufferedImageOp instanceof ConvolveOp) {
            return this.toSVG((ConvolveOp)bufferedImageOp);
        }
        return null;
    }

    public SVGFilterDescriptor toSVG(ConvolveOp convolveOp) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(convolveOp);
        Document document = this.generatorContext.domFactory;
        if (sVGFilterDescriptor == null) {
            Kernel kernel = convolveOp.getKernel();
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "filter");
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "feConvolveMatrix");
            element2.setAttributeNS(null, "order", kernel.getWidth() + " " + kernel.getHeight());
            StringBuffer stringBuffer = new StringBuffer();
            float[] fArray = kernel.getKernelData(null);
            int n = 0;
            while (n < fArray.length) {
                stringBuffer.append(AbstractSVGFilterConverter.doubleString(fArray[n]));
                stringBuffer.append(" ");
                ++n;
            }
            element2.setAttributeNS(null, "kernelMatrix", stringBuffer.toString().trim());
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("convolve"));
            if (convolveOp.getEdgeCondition() == 1) {
                element2.setAttributeNS(null, "edgeMode", "duplicate");
            } else {
                element2.setAttributeNS(null, "edgeMode", "none");
            }
            StringBuffer stringBuffer2 = new StringBuffer("url(");
            stringBuffer2.append("#");
            stringBuffer2.append(element.getAttributeNS(null, "id"));
            stringBuffer2.append(")");
            sVGFilterDescriptor = new SVGFilterDescriptor(stringBuffer2.toString(), element);
            this.defSet.add(element);
            this.descMap.put(convolveOp, sVGFilterDescriptor);
        }
        return sVGFilterDescriptor;
    }
}

