/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.MapBase;
import org.xmlmiddleware.xmldbms.maps.Table;

public class Key
extends MapBase {
    public static final int UNKNOWN = 0;
    public static final int PRIMARY_KEY = 1;
    public static final int UNIQUE_KEY = 2;
    public static final int FOREIGN_KEY = 3;
    public static final int DOCUMENT = 1;
    public static final int KEYGENERATOR = 2;
    public static final int DATABASE = 3;
    private static final String PRIMARYKEY = "PrimaryKey";
    private String name;
    private int type = 0;
    private int generate = 0;
    private String generatorName;
    private Column[] columns;
    private Table pointsToTable;
    private Key pointsToKey;

    private Key(String string, int n) {
        this.name = string;
        this.type = n;
        if (n == 1) {
            this.generate = 1;
        }
    }

    public static Key createPrimaryKey(String string) {
        if (string == null) {
            string = PRIMARYKEY;
        }
        return new Key(string, 1);
    }

    public static Key createUniqueKey(String string) {
        MapBase.checkArgNull(string, "keyName");
        if (string.equals(PRIMARYKEY)) {
            throw new IllegalArgumentException("Only the primary key can be named 'PrimaryKey'.");
        }
        return new Key(string, 2);
    }

    public static Key createForeignKey(String string) {
        MapBase.checkArgNull(string, "keyName");
        if (string.equals(PRIMARYKEY)) {
            throw new IllegalArgumentException("Only the primary key can be named 'PrimaryKey'.");
        }
        return new Key(string, 3);
    }

    public final String getName() {
        return this.name;
    }

    public final int getType() {
        return this.type;
    }

    public final int getKeyGeneration() {
        return this.generate;
    }

    public final String getKeyGeneratorName() {
        return this.generatorName;
    }

    public void setKeyGeneration(int n, String string) {
        if (this.type != 1) {
            throw new IllegalStateException("This method can only be called for primary keys. Call getType() first to determine the key type.");
        }
        if (n == 2 && string == null || n != 2 && string != null) {
            throw new IllegalArgumentException("The generatorName argument must be non-null if generate is Key.KEYGENERATOR and null otherwise.");
        }
        this.generate = n;
        this.generatorName = string;
    }

    public final Column[] getColumns() {
        return this.columns;
    }

    public void setColumns(Column[] columnArray) {
        if (columnArray != null && columnArray.length == 0) {
            throw new IllegalArgumentException("Columns array must have non-zero length.");
        }
        this.columns = columnArray;
    }

    public final Table getRemoteTable() {
        if (this.type != 3) {
            throw new IllegalStateException("This method may only be called for foreign keys.");
        }
        return this.pointsToTable;
    }

    public final Key getRemoteKey() {
        if (this.type != 3) {
            throw new IllegalStateException("This method may only be called for foreign keys.");
        }
        return this.pointsToKey;
    }

    public final void setRemoteKey(Table table, Key key) {
        Key key2;
        if (this.type != 3) {
            throw new IllegalStateException("This method may only be called for foreign keys.");
        }
        int n = key.getType();
        if (n == 1) {
            key2 = table.getPrimaryKey();
        } else if (n == 2) {
            String string = key.getName();
            key2 = table.getUniqueKey(string);
        } else {
            throw new IllegalArgumentException("The remote key must be a primary or unique key.");
        }
        if (key2 != null && key2.equals(key)) {
            this.pointsToKey = key;
            this.pointsToTable = table;
            return;
        }
        throw new IllegalArgumentException("The remote key is not a primary or unique key in the remote table.");
    }
}

