/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.DataSource;
import org.xmlmiddleware.db.ConnectionPool;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class ArrayDataSource
extends ConnectionPool
implements DataSource {
    protected Stack m_connections;
    private static String ARRAYCONNECTION = "ArrayConnection";

    public ArrayDataSource(Connection connection) {
        Connection[] connectionArray = new Connection[]{connection};
        this.init(connectionArray);
    }

    public ArrayDataSource(Connection[] connectionArray) {
        this.init(connectionArray);
    }

    private void init(Connection[] connectionArray) {
        this.m_connections = new Stack();
        int n = 0;
        while (n < connectionArray.length) {
            this.m_connections.push(connectionArray[n]);
            ++n;
        }
    }

    protected Object createObject(Object object) throws XMLMiddlewareException {
        if (this.m_connections.empty()) {
            throw new XMLMiddlewareException("ArrayDataSource: No more connections available.");
        }
        return this.m_connections.pop();
    }

    protected void closeObject(Object object) throws XMLMiddlewareException {
        if (!(object instanceof Connection)) {
            throw new XMLMiddlewareException("ArrayDataSource: Invalid connection passed to ArrayDataSource");
        }
        this.m_connections.push(object);
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.checkOut(ARRAYCONNECTION);
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            if (xMLMiddlewareException.getException() instanceof SQLException) {
                throw (SQLException)xMLMiddlewareException.getException();
            }
            throw new SQLException(xMLMiddlewareException.getMessage());
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    public void setLoginTimeout(int n) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return -1;
    }
}

