/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.conversions.formatters;

import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class BooleanFormatter
implements StringFormatter {
    public String[] trueValues = new String[]{"true", "yes", "1"};
    public String[] falseValues = new String[]{"false", "no", "0"};
    public boolean caseSensitive = false;
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private boolean firstTime = true;

    public Object parse(String string, int n) throws XMLMiddlewareException {
        this.changeArrayCase();
        if (n == -7) {
            String string2 = this.caseSensitive ? string.toUpperCase() : string;
            int n2 = 0;
            while (n2 < this.trueValues.length) {
                if (string2.equals(this.trueValues[n2])) {
                    return TRUE;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.falseValues.length) {
                if (string2.equals(this.falseValues[n2])) {
                    return FALSE;
                }
                ++n2;
            }
            throw new XMLMiddlewareException("Value can't be parsed as true or false: " + string);
        }
        throw new XMLMiddlewareException("Conversion to specified JDBC type not supported.");
    }

    public String format(Object object) throws XMLMiddlewareException {
        this.changeArrayCase();
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueValues[0];
            }
            return this.falseValues[0];
        }
        throw new XMLMiddlewareException("Object must be a Boolean.");
    }

    public boolean canConvert(int n) {
        return n == -7;
    }

    private void changeArrayCase() {
        if (!this.firstTime) {
            return;
        }
        this.firstTime = false;
        if (this.caseSensitive) {
            return;
        }
        int n = 0;
        while (n < this.trueValues.length) {
            this.trueValues[n] = this.trueValues[n].toUpperCase();
            ++n;
        }
        n = 0;
        while (n < this.falseValues.length) {
            this.falseValues[n] = this.falseValues[n].toUpperCase();
            ++n;
        }
    }
}

