/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMysqlText {
    private static String getClob(Reader p_reader) throws Exception {
        if (p_reader == null) {
            return null;
        }
        StringBuffer txtBuff = null;
        char[] buff = new char[8192];
        int nLen = -1;
        while ((nLen = p_reader.read(buff)) != -1) {
            if (txtBuff == null) {
                txtBuff = new StringBuffer(nLen);
            }
            txtBuff.append(buff, 0, nLen);
        }
        buff = null;
        p_reader.close();
        if (txtBuff == null) {
            return "";
        }
        return txtBuff.toString();
    }

    public static String getClob(ResultSet p_rsData, String p_sFieldName) throws CMyException {
        try {
            Reader reader = p_rsData.getCharacterStream(p_sFieldName);
            return CMysqlText.getClob(reader);
        }
        catch (Exception ex) {
            throw new CMyException(40, I18NMessage.get(CMysqlText.class, "CMysqlText.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6Text\u5b57\u6bb5\u65f6\u51fa\u9519(CMysqlText.getText)"), ex);
        }
    }

    public static String getClob(ResultSet p_rsData, int p_nFieldIndex) throws CMyException {
        try {
            Reader reader = p_rsData.getCharacterStream(p_nFieldIndex);
            return CMysqlText.getClob(reader);
        }
        catch (Exception ex) {
            throw new CMyException(40, I18NMessage.get(CMysqlText.class, "CMysqlText.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6Text\u5b57\u6bb5\u65f6\u51fa\u9519(CMysqlText.getText)"), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setClob(Connection p_oConn, String p_sValue, String p_sUpdateSQL, String p_sFieldName) throws CMyException {
        if (p_sValue == null) {
            return true;
        }
        try {
            PreparedStatement pstmt = p_oConn.prepareStatement(p_sUpdateSQL);
            pstmt.setObject(1, (Object)p_sValue, -1);
            pstmt.executeUpdate();
            pstmt.close();
            return true;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CMysqlText.class, "CMysqlText.label2", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CMysqlText.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CMysqlText.class, "CMysqlText.label2", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CMysqlText.setClob)"), ex);
        }
    }

    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, I18NMessage.get(CMysqlText.class, "CMysqlText.label3", "\u53c2\u6570\u65e0\u6548(CMysqlText.setClob)"));
        }
        String strSQL = "UPDATE " + p_sTableName + " SET " + p_sClobFieldName + "=? WHERE " + p_sWhere;
        return CMysqlText.setClob(p_oConn, p_sValue, strSQL, p_sClobFieldName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int i;
        int nClobCount = p_asFieldsAndValues.length / 2;
        if (nClobCount <= 0) throw new CMyException(10, I18NMessage.get(CMysqlText.class, "CMysqlText.label4", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(CMysqlText.setClob)"));
        if (nClobCount * 2 != p_asFieldsAndValues.length) {
            throw new CMyException(10, I18NMessage.get(CMysqlText.class, "CMysqlText.label4", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(CMysqlText.setClob)"));
        }
        String strSQL = "UPDATE " + p_sTableName + " SET " + p_asFieldsAndValues[0] + "=?";
        for (i = 1; i < nClobCount; ++i) {
            strSQL = strSQL + "," + p_asFieldsAndValues[i * 2] + "=?";
        }
        strSQL = strSQL + " WHERE " + p_sWhere;
        try {
            PreparedStatement pstmt = p_oConn.prepareStatement(strSQL);
            i = 0;
            while (true) {
                if (i >= nClobCount) {
                    pstmt.executeUpdate();
                    pstmt.close();
                    return true;
                }
                String sValue = p_asFieldsAndValues[i * 2 + 1];
                if (sValue == null) {
                    sValue = "";
                }
                pstmt.setObject(i + 1, (Object)sValue, -1);
                ++i;
            }
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CMysqlText.class, "CMysqlText.label2", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CMysqlText.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CMysqlText.class, "CMysqlText.label5", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u95192(CMysqlText.setClob)"), ex);
        }
    }
}

