/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class TRSImportsOrgnize {
    public static final String CLASSES_PATH_FLAG = File.separatorChar + "classes" + File.separatorChar;
    public static final String FLAG_PAGE_START = "include file=\"";
    public static final int TYPE_NOFLAG = -1;
    public static final int TYPE_PAGE_START = 0;
    public static final int TYPE_INCLUDE = 1;
    public static final int TYPE_HTML_VALUE = 2;
    public static final int TYPE_CODE_START = 3;
    public static final int TYPE_CODE_END = 4;
    public static final int TYPE_COMMENT = 5;
    public static final String[] OPERATION_STR = new String[]{"<%!", "<%=", "<%", "%>", "-", "=", "(", ")", ".", "!"};
    public static final String[] EXCLUDE_PATH = new String[]{"images", "include", "cvs"};
    public static ArrayList arExcludeClass = new ArrayList();
    public static Hashtable hTRSClasses;
    private static final String FLAG_WCM_IMPORTS_BEGIN = "<!------- WCM IMPORTS BEGIN ------------>";
    private static final String FLAG_WCM_IMPORTS_END = "<!------- WCM IMPORTS END ------------>";

    private static void initClasses(String _sClassPath) {
        TRSImportsOrgnize.initExcludeClass();
        hTRSClasses = TRSImportsOrgnize.getFileHashtable(_sClassPath);
    }

    private static void initExcludeClass() {
        arExcludeClass.add("ExceptionNumber.class");
        arExcludeClass.add("User.class");
        arExcludeClass.add("ContextHelper.class");
        arExcludeClass.add("WCMException.class");
        arExcludeClass.add("LoginHelper.class");
        arExcludeClass.add("RequestParser.class");
        arExcludeClass.add("ResponseHelper.class");
        arExcludeClass.add("DreamFactory.class");
    }

    public static boolean isExcludeClass(String _sClassName) {
        return arExcludeClass.indexOf(_sClassName) >= 0;
    }

    public static String transformPathToClassPath(String _sAbsoluteFile) {
        int nPose = _sAbsoluteFile.lastIndexOf(".");
        if (nPose < 0 || nPose < _sAbsoluteFile.lastIndexOf(File.separatorChar)) {
            return _sAbsoluteFile;
        }
        String sClassPath = _sAbsoluteFile.substring(0, nPose);
        nPose = _sAbsoluteFile.indexOf(CLASSES_PATH_FLAG);
        if (nPose < 0) {
            return _sAbsoluteFile;
        }
        sClassPath = sClassPath.substring(nPose + CLASSES_PATH_FLAG.length());
        return sClassPath.replace(File.separatorChar, '.');
    }

    public static Hashtable getFileHashtable(String _sPath) {
        Hashtable<String, String> hClassesMap = new Hashtable<String, String>();
        FileService newFile = new FileService(_sPath);
        FileStore[] arFile = newFile.listFiles();
        if (arFile == null) {
            return hClassesMap;
        }
        for (int i = 0; i < arFile.length; ++i) {
            if (arFile[i].isFile()) {
                if (TRSImportsOrgnize.isExcludeClass(arFile[i].getName())) continue;
                String sClassPath = TRSImportsOrgnize.transformPathToClassPath(arFile[i].getAbsolutePath());
                hClassesMap.put(arFile[i].getName(), sClassPath);
            }
            if (!arFile[i].isDirectory()) continue;
            hClassesMap.putAll(TRSImportsOrgnize.getFileHashtable(arFile[i].getPath()));
        }
        return hClassesMap;
    }

    public static String mapClassFullPath(String _sClassName) {
        if (_sClassName.indexOf(".") < 0) {
            _sClassName = _sClassName + ".class";
        }
        return (String)hTRSClasses.get(_sClassName);
    }

    private static boolean isExcludePath(String _sPath) {
        String sPathName = CMyFile.extractFileName(_sPath);
        for (int i = 0; i < EXCLUDE_PATH.length; ++i) {
            if (!EXCLUDE_PATH[i].equalsIgnoreCase(sPathName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeFile(String _sFileName) {
        String sFileExt = CMyFile.extractFileExt(_sFileName);
        return !sFileExt.equalsIgnoreCase("jsp");
    }

    public static void dowithPath(String _sPath) throws Exception {
        FileService newFile = new FileService(_sPath);
        if (newFile.isFile()) {
            TRSImportsOrgnize.dowithFile(newFile.getAbsolutePath());
            return;
        }
        if (TRSImportsOrgnize.isExcludePath(newFile.getName())) {
            return;
        }
        FileStore[] arFile = newFile.listFiles();
        for (int i = 0; i < arFile.length; ++i) {
            if (arFile[i].isFile()) {
                TRSImportsOrgnize.dowithFile(arFile[i].getAbsolutePath());
                continue;
            }
            if (!arFile[i].isDirectory()) continue;
            TRSImportsOrgnize.dowithPath(arFile[i].getPath());
        }
    }

    public static String dowithFile(String _sFileName) throws CMyException {
        if (TRSImportsOrgnize.isExcludeFile(_sFileName)) {
            return null;
        }
        InputStreamReader fileReader = null;
        StringBuffer buffContentBefore = null;
        StringBuffer buffContentAfter = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        ArrayList arClassPath = new ArrayList();
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, CMyString.FILE_WRITING_ENCODING));
            boolean bCodeStart = false;
            boolean bDowithLine = false;
            int nLineCount = 0;
            boolean bImportStart = false;
            boolean bImportEnd = false;
            while ((sLine = buffReader.readLine()) != null) {
                if (!bImportEnd) {
                    if (bImportStart) {
                        if (sLine.indexOf(FLAG_WCM_IMPORTS_END) < 0) continue;
                        bImportEnd = true;
                        bImportStart = false;
                        continue;
                    }
                    if (sLine.indexOf(FLAG_WCM_IMPORTS_BEGIN) >= 0) {
                        bImportStart = true;
                        continue;
                    }
                    if (buffContentBefore == null) {
                        buffContentBefore = new StringBuffer();
                    } else {
                        buffContentBefore.append('\n');
                    }
                    buffContentBefore.append(sLine);
                    continue;
                }
                if (buffContentAfter == null) {
                    buffContentAfter = new StringBuffer();
                    buffContentBefore.append('\n');
                }
                buffContentAfter.append('\n');
                buffContentAfter.append(sLine);
                ++nLineCount;
                int nLineType = TRSImportsOrgnize.getLineType(sLine);
                switch (nLineType) {
                    case 5: {
                        bDowithLine = false;
                        break;
                    }
                    case 3: {
                        if (!bCodeStart) {
                            bCodeStart = sLine.indexOf("%>") <= 0;
                        } else {
                            System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label1", "\u5206\u6790\u7b2c[") + nLineCount + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label2", "]\u884c[") + sLine + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label3", "]\u53d1\u73b0\u5f02\u5e38:\u4ee5\u524d\u7684\u4ee3\u7801\u6ca1\u6709\u7ed3\u675f!"));
                        }
                        bDowithLine = true;
                        break;
                    }
                    case 4: {
                        if (bCodeStart) {
                            bCodeStart = false;
                        } else {
                            System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label1", "\u5206\u6790\u7b2c[") + nLineCount + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label2", "]\u884c[") + sLine + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label4", "]\u53d1\u73b0\u5f02\u5e38:\u6ca1\u6709\u5f00\u59cb!"));
                        }
                        bDowithLine = true;
                        break;
                    }
                    case 2: {
                        sLine = TRSImportsOrgnize.subHTMLValue(sLine);
                        bDowithLine = sLine != null;
                        break;
                    }
                    case -1: {
                        bDowithLine = bCodeStart;
                        break;
                    }
                }
                if (!bDowithLine) continue;
                arClassPath = TRSImportsOrgnize.mergeArrayList(arClassPath, TRSImportsOrgnize.dowithLine(sLine));
                bDowithLine = false;
            }
            if (buffContentAfter == null) {
                System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label5", "\u6587\u4ef6[") + _sFileName + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label6", "]\u4e0d\u662f\u7cfb\u7edf\u89c4\u8303\u6587\u4ef6\uff01\u4e0d\u5728\u5904\u7406\u8303\u56f4\u5185"));
                String string = null;
                return string;
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label7", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label8", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        String sImports = TRSImportsOrgnize.createImportContent(arClassPath);
        CMyFile.writeFile(_sFileName, buffContentBefore + sImports + buffContentAfter);
        return "";
    }

    private static ArrayList dowithLine(String _sLine) {
        String sLine = _sLine;
        if ((sLine = sLine.trim()).length() <= 0) {
            return null;
        }
        for (int i = 0; i < OPERATION_STR.length; ++i) {
            sLine = CMyString.replaceStr(sLine, OPERATION_STR[i], " ");
        }
        if ((sLine = sLine.trim()).length() <= 0) {
            return null;
        }
        ArrayList<String> arImportClasses = new ArrayList<String>();
        String sClassPath = null;
        sLine = CMyString.replaceStr(sLine, "\t", " ");
        String[] arObject = sLine.split(" ");
        for (int i = 0; i < arObject.length; ++i) {
            if (arObject[i].trim().length() == 0 || (sClassPath = TRSImportsOrgnize.mapClassFullPath(arObject[i])) == null || arImportClasses.indexOf(sClassPath) >= 0) continue;
            arImportClasses.add(sClassPath);
        }
        return arImportClasses;
    }

    private static int getLineType(String _sLine) {
        if ((_sLine = _sLine.trim()).indexOf(FLAG_PAGE_START) >= 0) {
            return 0;
        }
        if (_sLine.indexOf("<%@include ") >= 0) {
            return 1;
        }
        if (_sLine.indexOf("<%=") >= 0) {
            return 2;
        }
        if (_sLine.indexOf("<%") >= 0) {
            return 3;
        }
        if (_sLine.indexOf("%>") >= 0) {
            return 4;
        }
        if (_sLine.indexOf("//") == 0 || _sLine.indexOf("*") == 0 || _sLine.indexOf("/*") == 0 || _sLine.indexOf("page import=") > 0) {
            return 5;
        }
        return -1;
    }

    private static String subHTMLValue(String _sLine) {
        int nStart = 0;
        int nEnd = 0;
        String sCode = null;
        while (nEnd >= 0) {
            nStart = _sLine.indexOf("<%=", nEnd);
            if (nStart < 0) {
                return sCode;
            }
            nEnd = _sLine.indexOf("%>", nStart);
            if (nEnd < 0) {
                return sCode;
            }
            sCode = sCode + " " + _sLine.substring(nStart + 3, nEnd);
        }
        return sCode;
    }

    private static ArrayList mergeArrayList(ArrayList _oldList, ArrayList _newList) {
        if (_newList == null || _newList.isEmpty()) {
            return _oldList;
        }
        Object oValue = null;
        for (int i = 0; i < _newList.size(); ++i) {
            oValue = _newList.get(i);
            if (_oldList.indexOf(oValue) >= 0) continue;
            _oldList.add(oValue);
        }
        return _oldList;
    }

    private static String createImportContent(ArrayList _classesList) {
        Collections.sort(_classesList);
        String sClassPath = null;
        String sImportContent = "";
        for (int i = 0; i < _classesList.size(); ++i) {
            sClassPath = (String)_classesList.get(i);
            sImportContent = sImportContent + "<%@ page import=\"" + sClassPath + "\" %>";
            if (i + 1 >= _classesList.size()) continue;
            sImportContent = sImportContent + "\n";
        }
        return "<!------- WCM IMPORTS BEGIN ------------>\n" + sImportContent + "\n" + FLAG_WCM_IMPORTS_END;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("\u5fc5\u987b\u6307\u5b9a\u4e24\u4e2a\u53c2\u6570\n\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3aClass\u7684\u5b58\u653e\u8def\u5f84\uff0c\u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u5f85\u5904\u7406\u7684\u6587\u4ef6\u6216\u76ee\u5f55");
            return;
        }
        String sClassPath = args[0];
        String sFilePath = args[1];
        FileService aFile = new FileService(sClassPath);
        if (!aFile.exists()) {
            System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label9", "\u6307\u5b9a\u7684ClassPath[") + sClassPath + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label10", "]\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        TRSImportsOrgnize.initClasses(sClassPath);
        aFile = new FileService(sFilePath);
        if (!aFile.exists()) {
            System.out.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label11", "\u6307\u5b9a\u5f85\u5904\u7406\u7684\u76ee\u5f55\u6216\u6587\u4ef6[") + sFilePath + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label10", "]\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        try {
            if (aFile.isDirectory()) {
                TRSImportsOrgnize.dowithPath(sFilePath);
            } else {
                TRSImportsOrgnize.dowithFile(sFilePath);
            }
        }
        catch (Exception ex) {
            System.err.println(I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label12", "\u5904\u7406\u76ee\u5f55\u6216\u6587\u4ef6\u7684Imports[") + sFilePath + I18NMessage.get(TRSImportsOrgnize.class, "TRSImportsOrgnize.label13", "]\u65f6\u5019\u51fa\u73b0\u5f02\u5e38\uff01"));
            ex.printStackTrace();
        }
    }

    static {
        try {
            TRSImportsOrgnize.initClasses("D:/MyWorkspace/TRSWCM52SRC/context/WEB-INF/classes/");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

