/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.util.BASE64EncoderStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BASE64DecoderStream
extends FilterInputStream {
    static final byte[] detable;
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private byte[] decode_buffer = new byte[4];
    private int index = 0;

    public static final byte[] decode(byte[] inbuff) {
        int iSize = inbuff.length / 4 * 3;
        if (iSize == 0) {
            return inbuff;
        }
        if (inbuff[inbuff.length - 1] == 61) {
            if (inbuff[inbuff.length - 2] == 61) {
                --iSize;
            }
            --iSize;
        }
        int inposi = 0;
        int outpos = 0;
        byte[] outbuf = new byte[iSize];
        for (iSize = inbuff.length; iSize > 0; iSize -= 4) {
            byte a = detable[inbuff[inposi++] & 0xFF];
            byte b = detable[inbuff[inposi++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (inbuff[inposi] == 61) break;
            a = b;
            b = detable[inbuff[inposi++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
            if (inbuff[inposi] == 61) break;
            a = b;
            b = detable[inbuff[inposi++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
        }
        return outbuf;
    }

    public static final byte[] decode(String encoded) {
        char[] charbuff = encoded.toCharArray();
        byte[] bytebuff = new byte[charbuff.length];
        for (int i = charbuff.length - 1; i >= 0; --i) {
            bytebuff[i] = (byte)charbuff[i];
        }
        return BASE64DecoderStream.decode(bytebuff);
    }

    public BASE64DecoderStream(InputStream in) {
        super(in);
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.decode();
            if (this.bufsize == 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                int c = this.read();
                if (c == -1) {
                    if (i == 0) {
                        i = -1;
                    }
                    break;
                }
                b[off + i] = (byte)c;
            }
        }
        catch (IOException e) {
            i = -1;
        }
        return i;
    }

    private void decode() throws IOException {
        int got;
        int i;
        this.bufsize = 0;
        do {
            if ((i = this.in.read()) != -1) continue;
            return;
        } while (i == 10 || i == 13);
        this.decode_buffer[0] = (byte)i;
        int need = 3;
        int start = 1;
        while ((got = this.in.read(this.decode_buffer, start, need)) != need) {
            if (got == -1) {
                throw new IOException("Error in encoded stream");
            }
            need -= got;
            start += got;
        }
        byte a = detable[this.decode_buffer[0] & 0xFF];
        byte b = detable[this.decode_buffer[1] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
        if (this.decode_buffer[2] == 61) {
            return;
        }
        a = b;
        b = detable[this.decode_buffer[2] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
        if (this.decode_buffer[3] == 61) {
            return;
        }
        a = b;
        b = detable[this.decode_buffer[3] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
    }

    static {
        int i;
        detable = new byte[256];
        for (i = 0; i < 255; ++i) {
            BASE64DecoderStream.detable[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            BASE64DecoderStream.detable[BASE64EncoderStream.entable[i]] = (byte)i;
        }
    }
}

