/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.tagparser.WCMTagParserDocuments;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.database.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class WCMTagParserRollDocuments
extends WCMTagParserDocuments {
    public static int TIME_EXEC_WARN = 1500;
    private static final int MAX_EXP_NUMBER = 1000;
    private static final int MAX_SITE_LEVEL = 4;
    private static Logger logger = Logger.getLogger(WCMTagParserRollDocuments.class);
    protected Channels m_oQuoteContentChannels = null;
    protected String m_sQuoteConteteChannelIds = null;
    private int m_nSiteId = 0;
    private boolean m_zQuerySiteDocs = false;

    public WCMTagParserRollDocuments() {
        this.m_bForceSetCurrFolderOfContent = false;
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        super.getBeanInfo();
        TagBeanAttrInfo tbai = null;
        s_TagBeanInfo.setName("TRS_ROLLDOCUMENTS");
        s_TagBeanInfo.setDesc("TRS_ROLLDOCUMENTS");
        s_TagBeanInfo.setType(TagBeanInfo.BodyType.TAMPLATE);
        tbai = new TagBeanAttrInfo();
        tbai.setName("FROMCHANNELIDS");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("AUTOTRIGGER");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setEnumValue(new String[]{"true", "false"});
        tbai.setDefaultValue("false");
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("QUERYDAY");
        tbai.setType(TagBeanAttrInfo.Type.INTEGER);
        tbai.setDefaultValue("-1");
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("TIMERANGE");
        tbai.setType(TagBeanAttrInfo.Type.INTEGER);
        tbai.setDefaultValue("1");
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("SELECT");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("WHERE");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("FROM");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("ORDERBY");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("MODAL");
        tbai.setDesc(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label1", "\u6587\u6863\u7684\u5f15\u7528\u7c7b\u578b,\u4ee5\u5b57\u7b26','\u5206\u9694\u7684\u5b57\u7b26\u4e32"));
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("SITEID");
        tbai.setDesc(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label2", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9(ID)\u7684\u6587\u6863"));
        tbai.setType(TagBeanAttrInfo.Type.INTEGER);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("SITENAME");
        tbai.setDesc(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label3", "\u83b7\u53d6\u6307\u5b9a\u7ad9\u70b9(\u540d\u79f0)\u7684\u6587\u6863"));
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("PARENTCHANNELID");
        tbai.setDesc(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label4", "\u83b7\u53d6\u6307\u5b9a\u7236\u9891\u9053\u4e0b\u7684\u5b50\u9891\u9053\u6587\u6863\u96c6\u5408,\u4e0eCHILDLEVEL\u4e00\u8d77\u4f5c\u7528"));
        tbai.setType(TagBeanAttrInfo.Type.INTEGER);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("CHILDLEVEL");
        tbai.setDesc(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label5", "\u83b7\u53d6\u51e0\u7ea7\u7684\u5b50\u9891\u9053"));
        tbai.setType(TagBeanAttrInfo.Type.INTEGER);
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("CHNLTYPE");
        tbai.setDesc(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label6", "\u680f\u76ee/\u9891\u9053\u7c7b\u578b"));
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue("0");
        s_TagBeanInfo.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("INCLUDEPARENT");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setEnumValue(new String[]{"true", "false"});
        tbai.setDefaultValue("false");
        s_TagBeanInfo.addAttrInfo(tbai);
        return s_TagBeanInfo;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        if (!this.initQuoteContentChannels(null)) {
            return null;
        }
        if (!"TRUE".equalsIgnoreCase(this.m_tagItem.getAttribute("AUTOTRIGGER"))) {
            return null;
        }
        TemplateQuote[] pTemplateQuote = new TemplateQuote[this.m_oQuoteContentChannels.size()];
        int nSize = this.m_oQuoteContentChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)this.m_oQuoteContentChannels.getAt(i);
            if (channel == null) continue;
            TemplateQuote aQuote = new TemplateQuote();
            aQuote.setQuoteType(1);
            aQuote.setQuotedFolder(channel.getWCMType(), channel.getId(), -1);
            pTemplateQuote[i] = aQuote;
        }
        return pTemplateQuote;
    }

    private boolean initQuoteContentChannels(PublishTagContext _tagContext) throws WCMException {
        if (_tagContext != null && this.isQueryChildDocs(_tagContext)) {
            return true;
        }
        if (this.m_sQuoteConteteChannelIds == null) {
            if (_tagContext != null) {
                this.m_sQuoteConteteChannelIds = _tagContext.getAttribute("FromChannelIds");
            } else {
                this.m_sQuoteConteteChannelIds = this.m_tagItem.getAttribute("FromChannelIds");
                if (TagItem.isVariableParameter(this.m_sQuoteConteteChannelIds)) {
                    return false;
                }
            }
        }
        if (this.m_oQuoteContentChannels == null) {
            this.m_oQuoteContentChannels = Channels.findByIds(User.getSystem(), this.m_sQuoteConteteChannelIds);
        }
        return this.m_oQuoteContentChannels != null && !this.m_oQuoteContentChannels.isEmpty();
    }

    @Override
    protected IPublishElements getAllContentsInCurrentFolder(PublishTagContext _tagContext, WCMFilter _filter) throws WCMException {
        if (this.isQuerySiteDocs(_tagContext)) {
            this.initSiteChnls(_tagContext);
        } else if (this.isQueryChildDocs(_tagContext)) {
            this.initChildChnls(_tagContext);
        }
        return this.getPublishedContentsInCurrentFolder(_tagContext, _filter);
    }

    @Override
    protected IPublishElements getPublishedContentsInCurrentFolder(PublishTagContext _context, WCMFilter _filter) throws WCMException {
        if (this.isQuerySiteDocs(_context)) {
            this.initSiteChnls(_context);
        } else if (this.isQueryChildDocs(_context)) {
            this.initChildChnls(_context);
        }
        if (!this.initQuoteContentChannels(_context) && this.m_nSiteId <= 0 && !this.m_zQuerySiteDocs) {
            if (this.m_oCurrFolder != null) {
                this.m_sQuoteConteteChannelIds = String.valueOf(this.m_oCurrFolder.getId());
                this.m_oQuoteContentChannels = Channels.findByIds(null, this.m_sQuoteConteteChannelIds);
            } else {
                return null;
            }
        }
        if (!(this.m_zQuerySiteDocs || this.m_sQuoteConteteChannelIds != null && this.m_sQuoteConteteChannelIds.length() != 0)) {
            return null;
        }
        WCMFilter filter = new WCMFilter();
        filter.mergeWith(_filter);
        int nMaxNum = _context.getAttribute("NUM", 20);
        filter.setMaxRowNumber(nMaxNum);
        String sOrderBy = _context.getAttributeTrim("ORDER");
        if (sOrderBy == null || sOrderBy.length() == 0) {
            sOrderBy = "CrTime Desc";
        }
        filter.setOrder(sOrderBy);
        int nPublishDay = _context.getAttribute("QUERYDAY", -1);
        int nTimeRange = _context.getAttribute("TimeRange", 1);
        CMyDateTime dtStartTime = null;
        CMyDateTime dtEndTime = null;
        try {
            if (nPublishDay >= 0) {
                String sDate = CMyDateTime.now().dateAdd(3, -nPublishDay).toString("yyyy-MM-dd");
                dtEndTime = new CMyDateTime();
                dtEndTime.setDateTimeWithString(sDate + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                dtStartTime = new CMyDateTime();
                dtStartTime.setDateTimeWithString(sDate + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
            } else {
                dtStartTime = CMyDateTime.now().dateAdd(3, -nTimeRange);
            }
        }
        catch (Exception e) {
            dtStartTime = CMyDateTime.now();
        }
        String sModal = _context.getAttribute("MODAL");
        if (CMyString.isEmpty(sModal)) {
            sModal = "1";
        }
        DebugTimer timer = new DebugTimer();
        timer.start();
        IPublishElements contents = this.queryRollDocuments(filter, dtStartTime, dtEndTime, sModal);
        timer.stop();
        if (timer.getTime() > (long)TIME_EXEC_WARN) {
            logger.warn((Object)"========Template Info=========");
            logger.warn((Object)_context.getPageContext().getTemplate());
            IPublishFolder root = _context.getPageContext().getTemplate().getRoot();
            if (root != null) {
                logger.warn((Object)"========Template Site=========");
                logger.warn((Object)root.getInfo());
            }
            logger.warn((Object)"========TagItem Info=========");
            logger.warn((Object)_context.getTagItem());
            logger.warn((Object)("========Parse use [" + timer.getTime() + "]ms========="));
        }
        return contents;
    }

    private IPublishElements queryRollDocuments(WCMFilter _filter, CMyDateTime _dtStartTime, CMyDateTime _dtEndTime, String _sModal) throws WCMException {
        String enableOracleHint;
        DebugTimer timer = new DebugTimer();
        timer.start();
        DBManager dbMgr = DBManager.getDBManager();
        StringBuffer sbQuerySQL = new StringBuffer(200);
        sbQuerySQL.append("select");
        if (dbMgr.getDBTypeAsInt() == 1 && (enableOracleHint = ConfigServer.getServer().getSysConfigValue("Roll_Document_Oracle_Hint", "true")).equalsIgnoreCase("true")) {
            sbQuerySQL.append(" /*+ index (WCMCHNLDOC IX_WCMCHNLDOC_CHNL )*/ ");
        }
        sbQuerySQL.append(" WCMCHNLDOC.DOCID,WCMCHNLDOC.Modal,WCMCHNLDOC.ChnlId");
        sbQuerySQL.append(" from WCMCHNLDOC");
        String sOrder = _filter.getOrder();
        if (CMyString.isEmpty(sOrder)) {
            sOrder = "WCMCHNLDOC.CrTime Desc";
        } else if (sOrder.toUpperCase().indexOf("WCMDOCUMENT.") != -1) {
            sbQuerySQL.append(" ,WCMDOCUMENT");
        }
        int[] arChnlIds = null;
        if (_sModal.indexOf(44) == -1) {
            sbQuerySQL.append(" Where WCMCHNLDOC.Modal=");
            sbQuerySQL.append(_sModal);
        } else {
            sbQuerySQL.append(" Where WCMCHNLDOC.Modal in(");
            sbQuerySQL.append(_sModal);
            sbQuerySQL.append(")");
        }
        if (this.m_zQuerySiteDocs && this.m_nSiteId > 0) {
            sbQuerySQL.append(" and WCMCHNLDOC.DocStatus=10 ");
            sbQuerySQL.append("and exists(select channelid from wcmchannel where siteid=?");
            sbQuerySQL.append(" and WCMCHNLDOC.CHNLID=wcmchannel.channelid)");
        } else {
            arChnlIds = CMyString.splitToInt(this.m_sQuoteConteteChannelIds, ",");
            if (arChnlIds.length < 1000) {
                sbQuerySQL.append(" and WCMCHNLDOC.DocStatus=10 and ChnlId in(?");
                int len = arChnlIds.length;
                for (int i = 1; i < len; ++i) {
                    sbQuerySQL.append(",?");
                }
                sbQuerySQL.append(")");
            } else {
                sbQuerySQL.append(" and WCMCHNLDOC.DocStatus=10 and (");
                int[] range = new int[arChnlIds.length];
                int index = 0;
                StringBuffer buff = new StringBuffer(768);
                Arrays.sort(arChnlIds);
                int len = arChnlIds.length;
                for (int i = 0; i < len; ++i) {
                    int current;
                    int left = current = arChnlIds[i];
                    while (i < len - 1 && arChnlIds[i + 1] == current + 1) {
                        current = arChnlIds[++i];
                    }
                    if (left == current) {
                        buff.append(" or ChnlId=?");
                        range[index++] = left;
                        continue;
                    }
                    buff.append(" or ChnlId>=? and ChnlId<=?");
                    range[index++] = left;
                    range[index++] = current;
                }
                sbQuerySQL.append(buff.substring(4));
                arChnlIds = new int[index];
                System.arraycopy(range, 0, arChnlIds, 0, index);
                sbQuerySQL.append(")");
            }
        }
        DBType dbType = dbMgr.getDBType();
        if (_dtEndTime != null) {
            sbQuerySQL.append(" and WCMCHNLDOC.CrTime>=" + dbType.sqlDate(_dtStartTime.toString()) + " and WCMCHNLDOC.CrTime<=" + dbType.sqlDate(_dtEndTime.toString()));
        } else {
            sbQuerySQL.append(" and WCMCHNLDOC.CrTime>=" + dbType.sqlDate(_dtStartTime.toString()));
        }
        if (_filter.getWhere() != null && _filter.getWhere().trim().length() > 0) {
            sbQuerySQL.append(" and (");
            sbQuerySQL.append(_filter.getWhere());
            sbQuerySQL.append(")");
        }
        if (sbQuerySQL.toString().toUpperCase().indexOf("WCMDOCUMENT") != -1) {
            sbQuerySQL.append(" and WCMCHNLDOC.DOCID=WCMDOCUMENT.DOCID");
        }
        sbQuerySQL.append(" order by ").append(sOrder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"=============query SQL of rolldocuments====================");
            logger.debug((Object)sbQuerySQL);
        }
        Documents documents = new Documents(null);
        documents.setFilter(_filter);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        int nMaxSize = _filter.getMaxRowNumber();
        if (nMaxSize <= 0) {
            nMaxSize = 200;
        }
        int[] pChannelIdsOfMirror = new int[nMaxSize];
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(sbQuerySQL.toString());
            if (nMaxSize > 0) {
                oStmt.setMaxRows(nMaxSize);
            }
            int ix = 1;
            if (this.m_zQuerySiteDocs && this.m_nSiteId > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("=============query param" + ix + "=" + this.m_nSiteId + " of rolldocuments===================="));
                }
                oStmt.setInt(ix++, this.m_nSiteId);
            } else if (arChnlIds != null) {
                boolean zDebugEnable = logger.isDebugEnabled();
                int len = arChnlIds.length;
                for (int i = 0; i < len; ++i) {
                    if (zDebugEnable) {
                        logger.debug((Object)("=============query param" + ix + "=" + arChnlIds[i] + " of rolldocuments===================="));
                    }
                    oStmt.setInt(ix++, arChnlIds[i]);
                }
            }
            rsData = oStmt.executeQuery();
            int nIndex = 0;
            while (rsData.next()) {
                int nDocId = rsData.getInt(1);
                boolean bAddSuccess = false;
                bAddSuccess = documents.indexOf(nDocId) < 0;
                documents.addElement(nDocId);
                if (!bAddSuccess) continue;
                pChannelIdsOfMirror[nIndex] = rsData.getInt(3);
                ++nIndex;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cSQL\u8bed\u53e5\u53ef\u80fd\u4e0d\u5bf9\uff1f\uff1aSQL=" + sbQuerySQL.toString(), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u6709\u95ee\u9898\uff1f\uff1aSQL=" + sbQuerySQL.toString(), ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
        }
        timer.stop();
        if (timer.getTime() > 1000L) {
            logger.warn((Object)("excute SQL[" + sbQuerySQL + "] use[" + timer.getTime() + "] ms!"));
            logger.warn((Object)("CrTime>=" + _dtStartTime));
        }
        PublishElementsListImpl contents = new PublishElementsListImpl();
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel;
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(document);
            try {
                contents.add(content);
            }
            catch (Exception ignore) {
                ignore.printStackTrace(System.err);
                logger.error((Object)"Exception to add roll document", (Throwable)ignore);
            }
            int nChannelId = pChannelIdsOfMirror[i];
            if (nChannelId <= 0 || (channel = Channel.findById(nChannelId)) == null) continue;
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            content.setFolder(folder);
        }
        return contents;
    }

    @Override
    public String parseAutoMore(IPublishFolder _currFolder, PublishTagContext _context) throws Exception {
        return null;
    }

    private boolean isQuerySiteDocs(PublishTagContext context) throws WCMException {
        int nSiteId = context.getAttribute("SITEID", 0);
        String sSiteName = context.getAttribute("SITENAME");
        return nSiteId > 0 || !CMyString.isEmpty(sSiteName);
    }

    private void initSiteChnls(PublishTagContext _context) throws WCMException {
        int nSiteId = _context.getAttribute("SITEID", 0);
        String sSiteName = _context.getAttribute("SITENAME");
        if (nSiteId <= 0) {
            WebSites sites = new WebSites(null);
            WCMFilter sitefilter = new WCMFilter();
            sitefilter.setSelect("WCMWEBSITE");
            sitefilter.setWhere("SITENAME=?");
            sitefilter.addSearchValues(sSiteName);
            sitefilter.setMaxRowNumber(1);
            sites.open(sitefilter);
            if (!sites.isEmpty()) {
                WebSite site = (WebSite)sites.getAt(0);
                nSiteId = site.getId();
            }
        }
        if (nSiteId <= 0) {
            return;
        }
        this.initSiteChnls0(nSiteId, _context.getAttribute("CHILDLEVEL", -1), _context.getAttribute("CHNLTYPE"));
    }

    private boolean isQueryChildDocs(PublishTagContext context) {
        String parentid = context.getAttribute("PARENTCHANNELID");
        return parentid != null && parentid.trim().length() > 0;
    }

    private void initChildChnls(PublishTagContext context) throws WCMException {
        String sChnlType;
        int nChnlId;
        block13: {
            nChnlId = 0;
            sChnlType = context.getAttribute("CHNLTYPE");
            try {
                String paretnid = context.getAttribute("PARENTCHANNELID");
                nChnlId = Integer.parseInt(paretnid);
                Channel channel = Channel.findById(nChnlId);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label10", "\u6307\u5b9a\u7684\u9891\u9053\u6ca1\u6709\u627e\u5230[Id=") + nChnlId + "]!");
                }
                if (channel.isDeleted()) {
                    throw new WCMException(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label11", "\u6307\u5b9a\u7684\u9891\u9053[") + channel + I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label12", "]\u5df2\u5220\u9664!"));
                }
            }
            catch (NumberFormatException e) {
                BaseChannel parent = WCMTagParserRollDocuments.findIdAppointedFolder(context, true);
                nChnlId = parent.getId();
                if (!parent.isSite()) break block13;
                this.initSiteChnls0(nChnlId, context.getAttribute("CHILDLEVEL", -1), sChnlType);
                return;
            }
        }
        DBManager manager = DBManager.getDBManager();
        int nLevel = context.getAttribute("CHILDLEVEL", 0);
        StringBuffer buff = new StringBuffer(256);
        if (!CMyString.isEmpty(sChnlType) && !"0".equals(sChnlType)) {
            StringBuffer sql = new StringBuffer(128);
            sql.append("select channelid from wcmchannel where ");
            sql.append("parentid=? and status=0");
            int[] nTypes = CMyString.splitToInt(sChnlType, ",");
            if (nTypes.length == 1) {
                if (nTypes[0] != -1) {
                    sql.append(" and chnltype=?");
                } else {
                    nTypes = new int[]{};
                }
            } else {
                sql.append(" and chnltype in(?");
                int len = nTypes.length;
                for (int i = 1; i < len; ++i) {
                    sql.append(",?");
                }
                sql.append(")");
            }
            this.getChildIdsWithType(manager, sql.toString(), nLevel, buff, nChnlId, nTypes);
        } else {
            this.getChildIds(manager, nLevel, buff, nChnlId);
        }
        if ("TRUE".equalsIgnoreCase(context.getAttribute("INCLUDEPARENT"))) {
            buff.append(',').append(nChnlId);
        }
        if (buff.length() > 1) {
            this.m_sQuoteConteteChannelIds = buff.substring(1);
        }
    }

    private void getChildIdsWithType(DBManager manager, String sql, int nLevel, StringBuffer buff, int nParentId, int[] types) throws WCMException {
        if (nLevel < 0) {
            return;
        }
        PreparedStatement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql);
            int ix = 1;
            pstmt.setInt(ix++, nParentId);
            int len = types.length;
            for (int i = 0; i < len; ++i) {
                pstmt.setInt(ix++, types[i]);
            }
            rs = pstmt.executeQuery();
            int nId = 0;
            buff.append(',').append(nParentId);
            while (rs.next()) {
                nId = rs.getInt(1);
                buff.append(',').append(nId);
                this.getChildIdsWithType(manager, sql, nLevel - 1, buff, nId, types);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label13", "\u83b7\u53d6\u9891\u9053\u96c6\u5408\u5931\u8d25!"), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                manager.freeConnection(conn);
            }
        }
    }

    private void initSiteChnls0(int nSiteId, int nLevel, String sChnlType) throws WCMException {
        if (nLevel < 0 || nLevel >= 4) {
            this.m_nSiteId = nSiteId;
            this.m_zQuerySiteDocs = true;
            return;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select channelid from wcmchannel where ");
        sql.append("status=0 and parentid=0 and siteid=?");
        int[] nTypes = null;
        if (CMyString.isEmpty(sChnlType)) {
            nTypes = new int[]{0};
            sql.append(" and chnltype=?");
        } else if ("-1".equals(sChnlType)) {
            nTypes = new int[]{};
        } else {
            nTypes = CMyString.splitToInt(sChnlType, ",");
            if (nTypes.length == 1) {
                sql.append(" and chnltype=?");
            } else {
                sql.append(" and chnltype in(?");
                int len = nTypes.length;
                for (int i = 1; i < len; ++i) {
                    sql.append(",?");
                }
                sql.append(")");
            }
        }
        DBManager manager = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql.toString());
            int ix = 1;
            pstmt.setInt(ix++, nSiteId);
            int len = nTypes.length;
            for (int i = 0; i < len; ++i) {
                pstmt.setInt(ix++, nTypes[i]);
            }
            rs = pstmt.executeQuery();
            StringBuffer buff = new StringBuffer(128);
            int nChnlId = 0;
            if (nLevel > 0) {
                sql.setLength(0);
                sql.append("select channelid from wcmchannel ");
                sql.append(" where status=0 and parentid=?");
                sql.append(" and chnltype in(?");
                int len2 = nTypes.length;
                for (int i = 1; i < len2; ++i) {
                    sql.append(",?");
                }
                sql.append(")");
                while (rs.next()) {
                    buff.append(',');
                    nChnlId = rs.getInt(1);
                    this.getChildIdsWithType(manager, sql.toString(), nLevel - 1, buff, nChnlId, nTypes);
                }
            } else {
                while (rs.next()) {
                    buff.append(',');
                    nChnlId = rs.getInt(1);
                    buff.append(nChnlId);
                }
            }
            if (buff.length() > 1) {
                this.m_sQuoteConteteChannelIds = buff.substring(1);
                this.m_oQuoteContentChannels = Channels.findByIds(User.getSystem(), this.m_sQuoteConteteChannelIds);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label13", "\u83b7\u53d6\u9891\u9053\u96c6\u5408\u5931\u8d25!"), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                manager.freeConnection(conn);
            }
        }
    }

    private static BaseChannel findIdAppointedFolder(PublishTagContext _context, boolean _bIsFromAllCataTag) throws WCMException {
        BaseChannel channelOrSite;
        IPublishElement _upperHost = _context.getUpperHost();
        IPublishFolder _root = _context.getRoot();
        String sName = _context.getAttribute("PARENTCHANNELID");
        int nHashcode = sName == null || (sName = sName.trim()).length() == 0 ? (_bIsFromAllCataTag ? 2545479 : 75627155) : sName.toUpperCase().hashCode();
        switch (nHashcode) {
            case 2545479: {
                if (_upperHost == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    channelOrSite = _upperHost instanceof IPublishFolder ? (BaseChannel)_upperHost.getSubstance() : (BaseChannel)_upperHost.getFolder().getSubstance();
                    if (channelOrSite.isSite()) break;
                    channelOrSite = channelOrSite.getSite();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case 75627155: {
                if (_upperHost == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    if (_upperHost instanceof IPublishFolder) {
                        channelOrSite = (BaseChannel)_upperHost.getSubstance();
                        break;
                    }
                    channelOrSite = (BaseChannel)_upperHost.getFolder().getSubstance();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case -1942094678: {
                if (_upperHost == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    channelOrSite = _upperHost instanceof IPublishFolder ? (BaseChannel)_upperHost.getSubstance() : (BaseChannel)_upperHost.getFolder().getSubstance();
                    if (channelOrSite.isSite()) break;
                    channelOrSite = channelOrSite.getHost();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            default: {
                channelOrSite = Channel.findByName(_root.getId(), sName);
                if (channelOrSite != null) break;
                String sMsg = I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label14", "\u6307\u5b9a\u7684\u9891\u9053 [") + sName + I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label15", "]\u5728") + _root.getInfo() + I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label16", "\u6ca1\u6709\u627e\u5230!");
                if (PublishServerConfigMapper.isIgnoreIfHostNotFound()) {
                    _context.addWarning(sMsg);
                    return null;
                }
                throw new WCMException(233, sMsg);
            }
        }
        return channelOrSite;
    }

    private void getChildIds(DBManager manager, int nLevel, StringBuffer buff, int nParentId) throws WCMException {
        if (nLevel < 0) {
            return;
        }
        String sql = "select channelid from wcmchannel where parentid=? and chnltype=0 and status=0";
        PreparedStatement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, nParentId);
            rs = pstmt.executeQuery();
            int nId = 0;
            while (rs.next()) {
                nId = rs.getInt(1);
                buff.append(',').append(nId);
                this.getChildIds(manager, nLevel - 1, buff, nId);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserRollDocuments.class, "WCMTagParserRollDocuments.label13", "\u83b7\u53d6\u9891\u9053\u96c6\u5408\u5931\u8d25!"), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                manager.freeConnection(conn);
            }
        }
    }
}

