/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.logger;

import com.trs.cms.logger.IObjLogger;
import com.trs.cms.logger.LogInfo;
import com.trs.cms.logger.OperTypeHelper;
import com.trs.components.wcm.content.domain.LoggerSwitchMgr;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import java.util.Iterator;
import java.util.Map;

public abstract class ObjLoggerBase
implements IObjLogger {
    protected static final int LINE_MAX_LEN = 100;

    @Override
    public LogInfo makeLogOnAdd(BaseObj newobj) {
        if (!LoggerSwitchMgr.getInstance().checkLoggerState(this.getClass().getName())) {
            return null;
        }
        String sObjName = this.makeName(newobj);
        return new LogInfo(this.getAddOpType(newobj), sObjName, "\u65b0\u5efa" + sObjName);
    }

    protected String makeName(BaseObj object) {
        String sObjName = this.getObjName(object);
        if (sObjName == null) {
            sObjName = object.toString();
        }
        if (sObjName.indexOf(91) == -1) {
            String typeName = WCMTypes.getObjName(object.getWCMType(), true);
            if ("\u672a\u77e5".equals(typeName) || "unknown".equals(typeName.toLowerCase())) {
                typeName = object.getClassName(false);
            }
            sObjName = sObjName + " [" + typeName + "-" + object.getId() + "]";
        }
        return sObjName;
    }

    @Override
    public LogInfo makeLogOnDel(BaseObj objdeleted) {
        if (!LoggerSwitchMgr.getInstance().checkLoggerState(this.getClass().getName())) {
            return null;
        }
        String sObjName = this.makeName(objdeleted);
        return new LogInfo(this.getDeleteOpType(objdeleted), sObjName, "\u5220\u9664" + sObjName);
    }

    @Override
    public LogInfo makeLogOnModify(BaseObj objmodified) {
        if (!LoggerSwitchMgr.getInstance().checkLoggerState(this.getClass().getName())) {
            return null;
        }
        String name = this.makeName(objmodified);
        StringBuffer detail = new StringBuffer(128);
        detail.append("\u4fee\u6539").append(name);
        detail.append(",\u4e3b\u8981\u5c5e\u6027\u4fee\u6539\u60c5\u51b5\u5982\u4e0b:\n");
        Map keys = this.getMajorKeys();
        if (keys != null && !keys.isEmpty()) {
            Iterator itrKey = keys.entrySet().iterator();
            Map.Entry entry = null;
            boolean changedMajor = false;
            while (itrKey.hasNext()) {
                String key;
                entry = itrKey.next();
                if (entry == null || !objmodified.isChangeProperty(key = (String)entry.getKey())) continue;
                detail.append(entry.getValue()).append(":");
                String value = objmodified.getPropertyAsString(key, "");
                detail.append(this.format(value));
                detail.append(" --> ");
                value = objmodified.getNewPropertyAsString(key);
                detail.append(this.format(value));
                detail.append('\n');
                changedMajor = true;
            }
            if (!changedMajor) {
                return null;
            }
        }
        return new LogInfo(this.getModifyOpType(objmodified), name, detail.toString());
    }

    protected String format(String value) {
        if (value == null) {
            return "";
        }
        if (value.length() > 100) {
            StringBuffer buff = new StringBuffer(value.length() + 20);
            while (value.length() > 100) {
                buff.append(value.substring(0, 100));
                buff.append("\n\t");
                value = value.substring(100);
            }
            if (value.length() > 0) {
                buff.append(value);
            }
            return buff.toString();
        }
        return value;
    }

    protected int getAddOpType(BaseObj object) {
        return OperTypeHelper.getAddOp(object);
    }

    protected int getModifyOpType(BaseObj object) {
        return OperTypeHelper.getModifyOp(object);
    }

    protected int getDeleteOpType(BaseObj object) {
        return OperTypeHelper.getDeleteOp(object);
    }

    @Override
    public abstract int getLogObjType();

    protected abstract Map getMajorKeys();

    protected abstract String getObjName(BaseObj var1);
}

