/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class ClusterLocker {
    private User lockUser = null;
    private CMSObj lockedObj = null;
    private static final String SQL_INS = "insert into WCMCLUSTERLOCK(OBJID,OBJTYPE,LOCKEDUSER,LOCKEDTIME) values(?,?,?,?)";
    private static final String SQL_DEL = "delete from WCMCLUSTERLOCK where OBJID=? and OBJTYPE=? and LOCKEDUSER=?";

    public ClusterLocker(User lockuser, CMSObj lockedObj) {
        this.lockUser = lockuser;
        this.lockedObj = lockedObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        if (this.lockUser == null || this.lockedObj == null) {
            return false;
        }
        if (this.lockedObj.getId() == 0) {
            return true;
        }
        DBManager dbmanager = DBManager.getDBManager();
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(SQL_INS);
            pstmt.setInt(1, this.lockedObj.getId());
            pstmt.setInt(2, this.lockedObj.getWCMType());
            pstmt.setString(3, this.lockUser.getName());
            pstmt.setTimestamp(4, CMyDateTime.now().toTimestamp());
            boolean bl = pstmt.executeUpdate() == 1;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock() {
        if (this.lockUser == null || this.lockedObj == null) {
            return false;
        }
        if (this.lockedObj.getId() == 0) {
            return true;
        }
        DBManager dbmanager = DBManager.getDBManager();
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(SQL_DEL);
            pstmt.setInt(1, this.lockedObj.getId());
            pstmt.setInt(2, this.lockedObj.getWCMType());
            pstmt.setString(3, this.lockUser.getName());
            boolean bl = pstmt.executeUpdate() == 1;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
    }
}

