/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.resource.Status;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class DocStatusChangeLogger
extends AbstractLogger {
    private static Logger LOG = Logger.getLogger(DocStatusChangeLogger.class);
    private static final int MAX_DOCSIZE = 20;

    @Override
    public int startLog(MethodConfig conf, MethodContext context) {
        try {
            User loginUser = ContextHelper.getLoginUser();
            Status status = Status.findById(context.getValue("StatusId", 0));
            String sObjectIds = context.getObjectIds();
            StringBuffer buff = new StringBuffer(1024);
            buff.append("\u6279\u91cf\u6539\u53d8\u6587\u6863\u7684\u72b6\u6001\u4e3a");
            buff.append(status.getDisp());
            buff.append("\n\u88ab\u4fee\u6539\u7684\u5bf9\u8c61\u4e3a: ");
            buff.append(sObjectIds);
            ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, sObjectIds);
            if (chnldocs.isEmpty()) {
                return 0;
            }
            Document logobj = null;
            Channel channel = null;
            int size = chnldocs.size();
            for (int i = 0; i < size && i < 20; ++i) {
                Document doc;
                ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
                if (chnldoc == null || (doc = chnldoc.getDocument()) == null) continue;
                if (logobj == null) {
                    logobj = doc;
                }
                if (channel == null) {
                    channel = chnldoc.getChannel();
                    buff.insert(0, "\u5728" + channel + "\u4e2d");
                }
                buff.append(doc);
                buff.append(", ");
            }
            if (chnldocs.size() > 20) {
                buff.append(" ...(\u7565). ID\u5e8f\u5217\u4e3a:").append(sObjectIds);
            }
            if (logobj == null) {
                LOG.warn((Object)"No need to log a pubish operate: no object found.");
                return 0;
            }
            return this.log(conf, buff.toString(), logobj);
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to log a docstatus change log", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public String getClassDesc() {
        return "\u4fee\u6539\u6587\u6863\u72b6\u6001";
    }
}

