/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.session.util;

import com.trs.infra.session.RequestSessionInfo;
import com.trs.infra.session.Session;
import com.trs.infra.session.SessionContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class HttpServletRequestFacade
extends HttpServletRequestWrapper {
    private SessionContext context;
    private Session session;
    private HttpServletResponse response;
    private RequestSessionInfo requestSessionInfo;

    public HttpServletRequestFacade(HttpServletRequest request, SessionContext sessionContext, HttpServletResponse response, Session session) {
        super(request);
        this.context = sessionContext;
        this.response = response;
        this.session = session;
    }

    public HttpServletRequestFacade(HttpServletRequest request, SessionContext sessionContext, HttpServletResponse response) {
        super(request);
        this.context = sessionContext;
        this.response = response;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create && (this.session == null || !this.session.isValid())) {
            this.session = this.context.makeSession((HttpServletRequest)this.getRequest(), this.response, false);
        }
        if (this.session != null) {
            return this.session.getHttpSession();
        }
        return null;
    }

    public String getRequestedSessionId() {
        if (this.requestSessionInfo == null) {
            this.requestSessionInfo = this.context.loadSessionInfo((HttpServletRequest)this.getRequest());
        }
        return this.requestSessionInfo.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestSessionInfo == null) {
            this.requestSessionInfo = this.context.loadSessionInfo((HttpServletRequest)this.getRequest());
        }
        return this.requestSessionInfo.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestSessionInfo == null) {
            this.requestSessionInfo = this.context.loadSessionInfo((HttpServletRequest)this.getRequest());
        }
        return this.requestSessionInfo.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestSessionInfo == null) {
            this.requestSessionInfo = this.context.loadSessionInfo((HttpServletRequest)this.getRequest());
        }
        return this.requestSessionInfo.isRequestedSessionIdValid();
    }
}

