/*
 * Decompiled with CFR 0.152.
 */
package t4j;

import java.util.logging.Level;
import java.util.logging.Logger;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

public class TBlogException
extends Exception {
    private static final long serialVersionUID = -2623309261327598087L;
    private int statusCode = -1;
    private int ErrorCode = -1;
    private int MessageCode = -1;
    private String sErrorMsg = "";

    public TBlogException(String msg) {
        super(msg);
        this.initMessage(msg);
    }

    public TBlogException(Exception cause) {
        super(cause);
        this.initMessage(cause.getMessage());
    }

    public TBlogException(String msg, int statusCode) {
        super(msg);
        this.initMessage(msg);
    }

    public TBlogException(String msg, Exception cause) {
        super(msg, cause);
        this.initMessage(cause.getMessage());
    }

    public TBlogException(String msg, Exception cause, int statusCode) {
        super(msg, cause);
        this.statusCode = statusCode;
        this.initMessage(cause.getMessage());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.ErrorCode;
    }

    public int getMessageCode() {
        return this.MessageCode;
    }

    public String getSErrorMsg() {
        return this.sErrorMsg;
    }

    private void initMessage(String msg) {
        JSONObject oErrorJson = null;
        if (msg.indexOf("{") < 0 || msg.indexOf("}") < 0) {
            return;
        }
        msg = msg.substring(msg.indexOf("{"), msg.lastIndexOf("}") + 1);
        try {
            oErrorJson = new JSONObject(msg);
        }
        catch (JSONException e) {
            Logger logger = Logger.getLogger(JSONException.class.getName());
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (oErrorJson != null) {
            try {
                if (oErrorJson.get("error") != null) {
                    this.sErrorMsg = (String)oErrorJson.get("error");
                }
                if (oErrorJson.get("error_code") != null) {
                    this.ErrorCode = oErrorJson.getInt("error_code");
                }
                if (oErrorJson.get("message_code") != null) {
                    this.MessageCode = oErrorJson.getInt("message_code");
                }
            }
            catch (JSONException e) {
                return;
            }
        }
    }
}

