/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2Socket;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class DB2Trace {
    protected static String NEWLINE = "\n";
    public static int TracePid = 0;
    public static boolean TraceOn = false;
    public static boolean TraceFlush = false;
    protected static String TracePathName = "";
    protected static Hashtable threadTable = new Hashtable(43);
    protected static Stack timeStack = new Stack();
    protected static boolean fApplet = false;
    static DB2Socket TraceSocket = null;
    private static boolean fInitialized = false;
    protected StringBuffer sb = new StringBuffer("");
    protected FileWriter fw = null;
    protected String TraceThreadName = "";
    protected StringBuffer traceBuffer = new StringBuffer("");
    protected DB2Socket db2socket = null;
    protected DB2Request db2req = null;

    public DB2Trace() {
        if (fApplet) {
            this.DB2TraceNet();
        } else {
            this.DB2TraceApp();
        }
    }

    public DB2Trace(int n) {
        fApplet = false;
        TracePid = n;
        NEWLINE = System.getProperty("line.separator");
        this.DB2TraceApp();
        fInitialized = true;
    }

    public DB2Trace(String string, int n) {
        fApplet = true;
        if (TraceSocket == null) {
            try {
                TraceSocket = new DB2Socket(new Socket(string, n));
            }
            catch (IOException iOException) {
                System.err.println(String.valueOf(this.getClass().getName()) + " - DB2Trace( " + string + ", " + n + " ) Error: " + iOException.toString());
                TraceSocket = null;
            }
        }
        this.DB2TraceNet();
        fInitialized = true;
    }

    public void DB2TraceApp() {
        try {
            Properties properties = System.getProperties();
            String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
            String string2 = String.valueOf(TracePid) + string + ".trc";
            File file = new File(TracePathName, string2);
            this.fw = new FileWriter(file.getAbsolutePath(), true);
            String string3 = String.valueOf(NEWLINE) + "========================================================" + NEWLINE + "|    DB2 JDBC App Driver                                " + NEWLINE + "|                                                       " + NEWLINE + "|    Trace beginning on " + DB2Trace.getTimeStamp() + NEWLINE + "========================================================" + NEWLINE + NEWLINE + "System Properties:" + NEWLINE + "------------------" + NEWLINE;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = properties.getProperty(string4);
                string3 = String.valueOf(string3) + string4 + " = " + string5 + NEWLINE;
            }
            string3 = String.valueOf(string3) + "----------------------------------------" + NEWLINE + NEWLINE;
            this.writeToFile(string3);
            threadTable.put(string2, this);
            TraceOn = true;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this.getClass().getName()) + " - DB2TraceApp() Error: " + exception.toString());
        }
    }

    public void DB2TraceNet() {
        this.db2socket = TraceSocket;
        this.db2req = new DB2Request(this.db2socket);
        try {
            String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
            this.TraceThreadName = String.valueOf(string) + ".trc";
            String string2 = "java.version";
            String string3 = String.valueOf(string2) + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "java.vendor";
            string3 = String.valueOf(string3) + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "java.class.version";
            string3 = String.valueOf(string3) + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "os.name";
            string3 = String.valueOf(string3) + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "os.arch";
            string3 = String.valueOf(string3) + string2 + " = " + System.getProperty(string2) + NEWLINE;
            string2 = "os.version";
            string3 = String.valueOf(string3) + string2 + " = " + System.getProperty(string2) + NEWLINE;
            String string4 = String.valueOf(NEWLINE) + "========================================================" + NEWLINE + "|    DB2 JDBC Net Driver                                " + NEWLINE + "|                                                       " + NEWLINE + "|    Trace beginning on " + DB2Trace.getTimeStamp() + NEWLINE + "========================================================" + NEWLINE + NEWLINE + "db2java version: " + 2 + NEWLINE + "db2jd   version: " + DB2Connection.DB2JDBC_SERVER_VERSION + NEWLINE + NEWLINE + "System Properties:" + NEWLINE + "------------------" + NEWLINE + string3 + NEWLINE + "----------------------------------------" + NEWLINE + NEWLINE;
            this.sendToServer(string4);
            threadTable.put(this.TraceThreadName, this);
            TraceOn = true;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this.getClass().getName()) + " - DB2TraceNet() Error: " + exception.toString());
        }
    }

    public void close() {
        if (fApplet) {
            if (this.isFlushNeeded()) {
                this.flushToServer();
            }
        } else if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(this.getClass().getName()) + " - close() Error: " + exception.toString());
            }
            this.fw = null;
        }
    }

    public static double computeTimeDiff(long l, long l2) {
        return (double)(l2 - l) / 1000.0;
    }

    public static void data(int n, String string) {
        if (TraceOn) {
            DB2Trace.getTraceObj().println(String.valueOf(n) + ": " + string);
        }
    }

    public static void data(int n, String string, int n2) {
        DB2Trace.data(n, String.valueOf(string) + " = " + n2);
    }

    public static void data(int n, String string, long l) {
        DB2Trace.data(n, String.valueOf(string) + " = " + l);
    }

    public static void data(int n, String string, String string2) {
        DB2Trace.data(n, String.valueOf(string) + " = " + string2);
    }

    public void finalize() {
        this.close();
    }

    public static void flush() {
        if (TraceOn) {
            DB2Trace dB2Trace = DB2Trace.getTraceObj();
            if (fApplet) {
                if (dB2Trace.isFlushNeeded()) {
                    dB2Trace.flushToServer();
                }
            } else {
                dB2Trace.flushToFile();
            }
        }
    }

    private void flushToFile() {
        if (this.fw == null) {
            return;
        }
        try {
            this.fw.flush();
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.getClass().getName()) + " - writeToFile() Error: " + iOException.toString());
            this.fw = null;
        }
    }

    private void flushToServer() {
        if (this.db2socket == null) {
            return;
        }
        try {
            this.db2req.write((short)118);
            this.db2req.write(this.TraceThreadName);
            this.db2req.write(this.traceBuffer.toString());
            this.db2req.sendAndRecv();
            int n = this.db2req.readInt();
            if (n != 0) {
                TraceOn = false;
            }
            this.traceBuffer.setLength(0);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this.getClass().getName()) + " - sendToServer() Error: " + exception.toString());
        }
    }

    public static String getNewline() {
        if (TraceOn) {
            return String.valueOf(NEWLINE) + DB2Trace.getTraceObj().sb.toString() + "| ";
        }
        return "";
    }

    public static String getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        String string = String.valueOf(n) + "-" + n2 + "-" + n3 + " " + n4 + ":" + n5 + ":" + n6 + "." + n7;
        return string;
    }

    public static DB2Trace getTraceObj() {
        String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
        String string2 = null;
        DB2Trace dB2Trace = null;
        string2 = fApplet ? String.valueOf(string) + ".trc" : String.valueOf(TracePid) + string + ".trc";
        dB2Trace = (DB2Trace)threadTable.get(string2);
        if (dB2Trace == null) {
            dB2Trace = new DB2Trace();
        }
        return dB2Trace;
    }

    public static DB2Trace getTraceObj(DB2Connection dB2Connection) {
        String string = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
        String string2 = String.valueOf(string) + ".trc";
        DB2Trace dB2Trace = (DB2Trace)threadTable.get(string2);
        if (dB2Trace == null) {
            dB2Trace = new DB2Trace();
        }
        return dB2Trace;
    }

    public boolean isFlushNeeded() {
        return this.traceBuffer.length() > 0;
    }

    public static boolean isInitialized() {
        return fInitialized;
    }

    public void listProperties(Properties properties) {
        if (fApplet || properties == null) {
            return;
        }
        if (this.fw == null) {
            String string = "";
            Enumeration<?> enumeration = properties.propertyNames();
            String string2 = this.sb.toString();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                if (string3.equals("password")) {
                    string4 = "XXXXXX";
                }
                string2 = String.valueOf(string2) + string + string3 + " = " + string4;
                string = ", ";
            }
            string2 = String.valueOf(string2) + NEWLINE;
            this.writeToFile(string2);
        }
    }

    public static void methodEntry(Object object, String string) {
        if (TraceOn) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            timeStack.push(timestamp);
            DB2Trace.getTraceObj().traceEntry(object, string, timestamp.toString());
        }
    }

    public static void methodExit(Object object, String string) {
        DB2Trace.methodExit(object, string, "");
    }

    public static void methodExit(Object object, String string, double d) {
        DB2Trace.methodExit(object, string, String.valueOf(d));
    }

    public static void methodExit(Object object, String string, float f) {
        DB2Trace.methodExit(object, string, String.valueOf(f));
    }

    public static void methodExit(Object object, String string, int n) {
        DB2Trace.methodExit(object, string, String.valueOf(n));
    }

    public static void methodExit(Object object, String string, long l) {
        DB2Trace.methodExit(object, string, String.valueOf(l));
    }

    public static void methodExit(Object object, String string, String string2) {
        if (TraceOn) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            Timestamp timestamp2 = timeStack.empty() ? timestamp : (Timestamp)timeStack.pop();
            long l = ((Date)timestamp2).getTime() + (long)(timestamp2.getNanos() / 1000000);
            long l2 = ((Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000);
            DB2Trace.getTraceObj().traceExit(object, string, string2, DB2Trace.computeTimeDiff(l, l2), timestamp.toString());
        }
    }

    public static void methodExit(Object object, String string, short s) {
        DB2Trace.methodExit(object, string, String.valueOf(s));
    }

    public static void methodExit(Object object, String string, boolean bl) {
        DB2Trace.methodExit(object, string, String.valueOf(bl));
    }

    public void print(int n) {
        String string = " " + n;
        this.print(string);
    }

    public void print(String string) {
        if (string != null) {
            int n = string.length();
            if (n > 500) {
                String string2 = string.substring(0, 500);
                this.write(String.valueOf(string2) + "(Truncated! Length was =" + n + ") " + NEWLINE);
            } else {
                this.write(string);
            }
        } else {
            this.print("null");
        }
    }

    public void println(int n) {
        String string = " " + n;
        this.println(string);
    }

    public void println(String string) {
        this.print(String.valueOf(String.valueOf(this.sb)) + string + NEWLINE);
    }

    public void println(String string, byte[] byArray) {
        if (byArray != null) {
            String string2 = "";
            int n = Math.min(4096, byArray.length);
            int n2 = 0;
            while (n2 < n) {
                string2 = String.valueOf(string2) + byArray[n2];
                ++n2;
            }
            this.println(String.valueOf(string) + string2);
        } else {
            this.println(String.valueOf(string) + "null");
        }
    }

    private void sendToServer(String string) {
        this.traceBuffer.append(string);
        if (TraceFlush || this.traceBuffer.length() > 16300) {
            this.flushToServer();
        }
    }

    public static void setTraceFlush(boolean bl) {
        TraceFlush = bl;
    }

    public static void setTraceOff() {
        TraceOn = false;
    }

    public static void setTraceOn() {
        TraceOn = true;
    }

    public static void setTracePath(String string) {
        TracePathName = string;
    }

    public static long timeInMilli() {
        long l = System.currentTimeMillis();
        return l;
    }

    public static long timer() {
        long l = DB2Trace.timeInMilli();
        return l;
    }

    public void traceEntry(Object object) {
        this.traceEntry(object, "");
    }

    public void traceEntry(Object object, String string) {
        if (object != null) {
            this.traceEntry(object.getClass().getName().substring(12), string);
        }
    }

    public void traceEntry(Object object, String string, String string2) {
        if (object != null) {
            this.traceEntry(object.getClass().getName().substring(12), string, string2);
        }
    }

    public void traceEntry(String string, String string2) {
        this.traceEntry(string, string2, DB2Trace.getTimeStamp());
    }

    public void traceEntry(String string, String string2, String string3) {
        this.println(String.valueOf(string) + " -> " + string2 + " (" + string3 + ")");
        this.sb.append("| ");
    }

    public void traceExit(Object object) {
        this.traceExit(object, "");
    }

    public void traceExit(Object object, String string) {
        this.traceExit(object, string, "", -1.0);
    }

    public void traceExit(Object object, String string, String string2, double d) {
        if (object != null) {
            this.traceExit(object.getClass().getName().substring(12), string, string2, d, DB2Trace.getTimeStamp());
        }
    }

    public void traceExit(Object object, String string, String string2, double d, String string3) {
        if (object != null) {
            this.traceExit(object.getClass().getName().substring(12), string, string2, d, string3);
        }
    }

    public void traceExit(String string, String string2) {
        this.traceExit(string, string2, "", -1.0);
    }

    private void traceExit(String string, String string2, String string3, double d, String string4) {
        int n = this.sb.length() - 2;
        if (n < 0) {
            n = 0;
        }
        this.sb.setLength(n);
        String string5 = "";
        if (this.sb.length() == 0) {
            string5 = NEWLINE;
        }
        this.println(String.valueOf(string) + " <- " + string2 + (string3 == "" ? "" : " returns " + string3) + (d == -1.0 ? "" : " [Time Elapsed = " + d + "]") + (string4 == "" ? "" : " (" + string4 + ")") + string5);
    }

    public void write(String string) {
        if (fApplet) {
            this.sendToServer(string);
        } else {
            this.writeToFile(string);
        }
    }

    private void writeToFile(String string) {
        if (this.fw == null) {
            return;
        }
        try {
            this.fw.write(string);
            if (TraceFlush) {
                this.fw.flush();
            }
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(this.getClass().getName()) + " - writeToFile() Error: " + iOException.toString());
            this.fw = null;
        }
    }
}

