/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix4j;

import com.google.gson.Gson;
import com.zabbix4j.ZabbixApiException;
import com.zabbix4j.ZabbixApiRequest;
import com.zabbix4j.ZabbixApiResponse;
import com.zabbix4j.utils.json.JSONException;
import com.zabbix4j.utils.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixApiMethod {
    private static Logger logger = LoggerFactory.getLogger(ZabbixApiMethod.class);
    protected String apiUrl;
    protected String auth;

    public ZabbixApiMethod(String apiUrl, String auth) {
        this.apiUrl = apiUrl;
        this.auth = auth;
    }

    public String sendRequest(String requestJson) throws ZabbixApiException {
        JSONObject responseJson;
        CloseableHttpResponse httpResponse;
        HttpPost httpPost = new HttpPost(this.apiUrl);
        String responseBody = null;
        try {
            httpPost.setHeader("Content-Type", "application/json-rpc");
            httpPost.setEntity((HttpEntity)new StringEntity(requestJson.toString(), "UTF-8"));
            DefaultHttpClient client = new DefaultHttpClient();
            httpResponse = client.execute((HttpUriRequest)httpPost);
            responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            throw new ZabbixApiException("HTTP Request Error");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new ZabbixApiException("HTTP Error : " + responseBody);
        }
        try {
            responseJson = new JSONObject(responseBody);
        }
        catch (Exception e) {
            throw new ZabbixApiException(e.getMessage());
        }
        if (responseJson.has("error")) {
            String message;
            try {
                message = "API Error : " + responseJson.getJSONObject("error").toString();
            }
            catch (JSONException e) {
                throw new ZabbixApiException(e.getMessage());
            }
            message = message + "\nRequest:" + requestJson.toString();
            throw new ZabbixApiException(message);
        }
        Gson gson = new Gson();
        ZabbixApiRequest request = (ZabbixApiRequest)gson.fromJson(requestJson, ZabbixApiRequest.class);
        ZabbixApiResponse response = (ZabbixApiResponse)gson.fromJson(responseBody, ZabbixApiResponse.class);
        if (!request.getId().equals(response.getId())) {
            throw new ZabbixApiException("id mismatch");
        }
        return responseBody;
    }
}

