/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.webframework.exception.ServiceInvocationException;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class NoLoginServiceControler
extends HttpServlet {
    private static Logger logger = Logger.getLogger(NoLoginServiceControler.class);
    private static final long serialVersionUID = -2124220278229482688L;
    private String m_sRedirectURI = null;
    private String[] m_pAllowIPPaths = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sCurrUser;
        String sRemoteAddress = request.getRemoteAddr();
        logger.info((Object)("IP[" + sRemoteAddress + "]\u4e8e[" + CMyDateTime.now() + "]\u8bbf\u95ee\u7cfb\u7edf\uff01"));
        String sEnableAllowIP = "true";
        try {
            sEnableAllowIP = ConfigServer.getServer().getSysConfigValue("ENABLE_ALLOW_IP", "true");
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (!"false".equalsIgnoreCase(sEnableAllowIP)) {
            String sAccessIPPath = sRemoteAddress;
            String sXForwardedFor = this.getXForwardedFor(request, response);
            if (!CMyString.isEmpty(sXForwardedFor)) {
                sAccessIPPath = sAccessIPPath + "/" + sXForwardedFor;
            }
            if (!this.isAllowIPPath(sAccessIPPath)) {
                logger.error((Object)("\u60a8\u7684IP[" + sAccessIPPath + "]\u4e0d\u5728\u5141\u8bb8\u8bbf\u95ee\u7684IP\u5217\u8868\u4e2d\uff01"));
                throw new ServletException("\u975e\u6cd5\u8bbf\u95ee\uff01");
            }
        }
        if (CMyString.isEmpty(sCurrUser = ConfigServer.getServer().getInitProperty("SERVICE_CURR_USER"))) {
            sCurrUser = "system";
        }
        User currUser = User.findByName(sCurrUser);
        request.getSession().setAttribute("WCM52.loginUser", (Object)currUser.getKey());
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(this.m_sRedirectURI);
        if (dispatcher == null) {
            throw new ServiceInvocationException("\u65e0\u6cd5\u83b7\u53d6\u9875\u9762[" + this.m_sRedirectURI + "]!");
        }
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ServletException ex) {
            throw ex;
        }
        finally {
            ContextHelper.clear();
            request.getSession().removeAttribute("WCM52.loginUser");
        }
    }

    private String getXForwardedFor(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String sForwardedFor = null;
        Enumeration oForwardedFors = request.getHeaders("X-Forwarded-For");
        if (oForwardedFors == null) {
            return sForwardedFor;
        }
        int index = 0;
        while (oForwardedFors.hasMoreElements()) {
            sForwardedFor = (String)oForwardedFors.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ForwardedFors-" + index + ":" + sForwardedFor));
            }
            if (++index < 2) continue;
            throw new ServletException("\u975e\u6cd5\u8bbf\u95ee\uff01");
        }
        if (sForwardedFor == null) {
            return null;
        }
        String[] sIp = sForwardedFor.trim().split("\\.");
        for (int i = 0; i < sIp.length; ++i) {
            Integer.parseInt(sIp[i]);
        }
        return sForwardedFor;
    }

    private boolean isAllowIPPath(String sAccessIPPath) {
        if (this.m_pAllowIPPaths.length == 0) {
            return false;
        }
        String[] pAccessIPs = sAccessIPPath.split("/");
        for (int i = 0; i < this.m_pAllowIPPaths.length; ++i) {
            String[] pAllowIPs;
            String sAllowIPPath = this.m_pAllowIPPaths[i].trim();
            if (CMyString.isEmpty(sAllowIPPath) || (pAllowIPs = sAllowIPPath.split("/")).length != pAccessIPs.length) continue;
            boolean bInnerResult = true;
            for (int j = 0; j < pAccessIPs.length; ++j) {
                if (this.isAllowIP(pAllowIPs[j], pAccessIPs[j])) continue;
                bInnerResult = false;
                break;
            }
            if (!bInnerResult) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowIP(String _sStandardAddr, String _sRemoteAddr) {
        String[] pRemoteIPList;
        String[] pAllowIPList;
        if (CMyString.isEmpty(_sStandardAddr)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("_sStandardAddr:" + _sStandardAddr + ";_sRemoteAddr:" + _sRemoteAddr));
        }
        if ((pAllowIPList = _sStandardAddr.split("\\.")).length != (pRemoteIPList = _sRemoteAddr.split("\\.")).length) {
            return false;
        }
        for (int j = 0; j < pRemoteIPList.length; ++j) {
            if (pAllowIPList[j].equals("*") || pRemoteIPList[j].equals(pAllowIPList[j])) continue;
            return false;
        }
        return true;
    }

    public void init() throws ServletException {
        String sServiceAllowIPs = CMyString.showEmpty(ConfigServer.getServer().getInitProperty("SERVICE_ALLOW_IPS"));
        this.m_pAllowIPPaths = sServiceAllowIPs.split(",");
        this.m_sRedirectURI = CMyString.showNull(this.getInitParameter("RedirectURI"), "/center.do");
        if (!this.m_sRedirectURI.startsWith("/")) {
            this.m_sRedirectURI = "/" + this.m_sRedirectURI;
        }
        super.init();
    }
}

