/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.controler.servlet;

import com.trs.cms.ContextHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FileUploadHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyFileX;
import com.trs.infra.util.CMyString;
import com.trs.webframework.controler.servlet.LoginValidatorFactory;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FileUploader
extends HttpServlet {
    private static final long serialVersionUID = -6116748461001338662L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (!response.containsHeader("SelfDefinedContentType")) {
                response.setContentType("text/xml;charset=utf-8");
            }
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", -1L);
            response.setDateHeader("max-age", 0L);
            request.setCharacterEncoding("ISO-8859-1");
            byte[] bFileContent = StreamBuddy.readFromInputStream((InputStream)request.getInputStream());
            if (!LoginValidatorFactory.createLoginValidator().isLogin(request)) {
                response.setHeader("TRSNotLogin", "true");
                return;
            }
            String result = null;
            String sFileType = request.getHeader("FileExt");
            if (FileUploadHelper.isForbidFileExt(sFileType)) {
                throw new WCMException("\u4e0d\u5141\u8bb8\u7684\u6587\u4ef6\u540e\u7f00[" + sFileType + "]");
            }
            String sFileFlag = request.getHeader("FileFlag");
            if (CMyString.isEmpty(sFileFlag)) {
                sFileFlag = "U0";
            }
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sSaveFile = null;
            String sShowName = null;
            sSaveFile = aFilesMan.getNextFilePathName(sFileFlag, sFileType);
            CMyFileX.writeFile(sSaveFile, bFileContent);
            sShowName = CMyFile.extractFileName(sSaveFile, "/");
            sShowName = CMyFile.extractFileName(sShowName, "\\");
            PrintWriter writer = response.getWriter();
            result = sShowName;
            if (result == null) {
                ((Writer)writer).write("");
            } else if (result instanceof String) {
                ((Writer)writer).write("<result><ShowName><![CDATA[" + CMyString.encodeForCDATA(result) + "]]></ShowName></result>");
            } else {
                ((Writer)writer).write(I18NMessage.get(FileUploader.class, "FileUploader.label1", "<result>\u4e0d\u652f\u6301\u5904\u7406\u7684\u7c7b\u578b[") + result.getClass() + "]!</result>");
            }
        }
        catch (Throwable ex) {
            response.setContentType("text/xml;charset=utf-8");
            PrintWriter wirter = response.getWriter();
            response.setHeader("TRSException", "true");
            if (ex instanceof RuntimeException && !(ex instanceof ServiceInvocationException) && ex.getCause() != null) {
                Throwable throwable = ex = ex.getCause() != null ? ex.getCause() : ex;
            }
            if (ex instanceof ServiceInvocationException) {
                ServiceInvocationException exTmp = (ServiceInvocationException)ex;
                this.writeFault(wirter, exTmp.getErrorCode(), ex.getMessage(), exTmp.getCause() == null ? exTmp : exTmp.getCause(), exTmp.getSuggestion());
            } else {
                this.writeFault(wirter, "5000", ex.getMessage(), ex, "");
            }
            ((Writer)wirter).flush();
            ((Writer)wirter).close();
        }
        finally {
            ContextHelper.clear();
        }
    }

    private void writeFault(Writer _wirter, String _sCode, String _sMessage, Object _detail, String _sSuggestion) throws IOException {
        Element element;
        Element root = DocumentHelper.createElement((String)"fault");
        root.addCDATA(_sCode);
        if (_sCode != null) {
            element = root.addElement("code");
            element.addCDATA(_sCode);
        }
        if (_sMessage != null) {
            element = root.addElement("message");
            if (CMyString.containsCDATAStr(_sMessage)) {
                element.addText(_sMessage);
            } else {
                element.addCDATA(_sMessage);
            }
        }
        if (_detail != null) {
            String sDetail = _detail.toString();
            if (_detail instanceof Throwable) {
                sDetail = sDetail + CMyException.getStackTraceText((Throwable)_detail);
            }
            Element element2 = root.addElement("detail");
            if (CMyString.containsCDATAStr(sDetail)) {
                element2.addText(sDetail);
            } else {
                element2.addCDATA(sDetail);
            }
        }
        if (_sSuggestion != null) {
            element = root.addElement("suggestion");
            if (CMyString.containsCDATAStr(_sSuggestion)) {
                element.addText(_sSuggestion);
            } else {
                element.addCDATA(_sSuggestion);
            }
        }
        _wirter.write(root.asXML());
    }
}

