/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.config;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.support.config.ConfigServer;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.ServiceConfig;
import com.trs.webframework.config.ServiceConfigStartServer;
import com.trs.webframework.config.ServiceFilterConfig;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.exception.NoSuchServiceException;
import com.trs.webframework.exception.ServiceCreationFailException;
import com.trs.webframework.provider.IDeleteServiceProvider;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.IFindByIdsServiceProvider;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISaveServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import com.trs.webframework.provider.IServiceProvider;
import java.io.File;
import org.apache.log4j.Logger;

public class ServiceConfigHelper {
    private static Logger logger = Logger.getLogger(ServiceConfigHelper.class);

    public static String getSeviceConfigRootPath() {
        ServiceConfigStartServer configServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (configServer == null) {
            return null;
        }
        return configServer.getConfigPath();
    }

    public static String getSevicesConfigFileName(String _sServiceId) {
        StringBuffer buff = new StringBuffer(256);
        if (ConfigServer.getServer().isShowDetailErrorInfo()) {
            buff.append(ServiceConfigHelper.getSeviceConfigRootPath());
        }
        buff.append(_sServiceId.replace('_', File.separatorChar));
        buff.append(".xml");
        return buff.toString();
    }

    public static MethodConfig findMethodConfig(String _sServiceId, String _sMethodName) {
        ServiceConfig serviceConfig = ServiceConfigHelper.findServiceConfig(_sServiceId);
        if (serviceConfig == null) {
            return null;
        }
        return serviceConfig.findMethodByName(_sMethodName);
    }

    public static ServiceConfig findServiceConfig(String _sServiceId) {
        ServiceConfigStartServer configServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (configServer == null) {
            return null;
        }
        ServiceConfig serviceConfig = configServer.findServiceConfigById(_sServiceId);
        if (serviceConfig == null) {
            return null;
        }
        return serviceConfig;
    }

    public static IServiceProvider makeProvider(String _sProviderClassName, String _sDecoratorClassName) {
        try {
            IServiceProvider service = (IServiceProvider)Class.forName(_sProviderClassName).newInstance();
            if (_sDecoratorClassName != null && _sDecoratorClassName.trim().length() != 0) {
                IServiceProvider decorator = ServiceConfigHelper.makeDecorator(_sDecoratorClassName, service);
                return decorator;
            }
            return service;
        }
        catch (InstantiationException ex) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label1", "\u65e0\u6cd5\u6b63\u786e\u521b\u5efa\u540d\u4e3a[") + _sProviderClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label2", "]\u7684Provider"), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label3", "\u65e0\u6cd5\u8bbf\u95ee\u540d\u4e3a[") + _sProviderClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label4", "]\u7684Provider\u7684\u6784\u9020\u5668\uff01"), ex);
        }
        catch (ClassNotFoundException ex) {
            throw new NoSuchServiceException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label5", "\u6307\u5b9a\u7684Provider[") + _sProviderClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label6", "]\u6ca1\u6709\u627e\u5230\uff01"), ex);
        }
    }

    public static ServiceFilterConfig[] findServiceFilterConfigs(String _sServiceId, String _sMethodName) {
        ServiceConfigStartServer configServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (configServer == null) {
            return new ServiceFilterConfig[0];
        }
        return configServer.findServiceFilterConfigs(_sServiceId, _sMethodName);
    }

    public static ServiceListenerConfig[] findServiceListenerConfigs(String _sServiceId, String _sMethodName) {
        ServiceConfigStartServer configServer = (ServiceConfigStartServer)TRSConfigServer.findConfigServerById("service");
        if (configServer == null) {
            return new ServiceListenerConfig[0];
        }
        return configServer.findServiceListenerConfigs(_sServiceId, _sMethodName);
    }

    private static IServiceProvider makeDecorator(String _sDecoratorClassName, IServiceProvider _decoratee) {
        IServiceProvider decorator = null;
        try {
            Class[] classes = new Class[]{IServiceProvider.class};
            Object[] params = new Object[]{_decoratee};
            decorator = (IServiceProvider)Class.forName(_sDecoratorClassName).getConstructor(classes).newInstance(params);
        }
        catch (InstantiationException ex) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label1", "\u65e0\u6cd5\u6b63\u786e\u521b\u5efa\u540d\u4e3a[") + _sDecoratorClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label7", "]\u7684Decorator"), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServiceCreationFailException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label3", "\u65e0\u6cd5\u8bbf\u95ee\u540d\u4e3a[") + _sDecoratorClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label8", "]\u7684Decorator\u7684\u6784\u9020\u5668\uff01"), ex);
        }
        catch (ClassNotFoundException ex) {
            throw new NoSuchServiceException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label9", "\u6307\u5b9a\u7684Decorator[") + _sDecoratorClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label6", "]\u6ca1\u6709\u627e\u5230\uff01"), ex);
        }
        catch (Exception ex) {
            throw new NoSuchServiceException(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label10", "\u6784\u9020[") + _sDecoratorClassName + I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label11", "]\u65f6\u53d1\u751f\u9519\u8bef\uff01Caused by: \n") + ex, ex);
        }
        return decorator;
    }

    public static IServiceProvider makeProvider(String _sProviderClassName) {
        return ServiceConfigHelper.makeProvider(_sProviderClassName, null);
    }

    public static IServiceProvider validateProvider(int _nMethodType, IServiceProvider _service) {
        String sProviderClassName = _service.getClass().getName();
        switch (_nMethodType) {
            case 107944136: {
                if (_service instanceof IQueryServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label12", "Service\u7c7b\u578b\u4e0d\u5339\u914d! IQueryServiceProvider [Class=") + sProviderClassName + "]"));
                return null;
            }
            case 3522941: {
                if (_service instanceof ISaveServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label13", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 ISaveServiceProvider [Class=") + sProviderClassName + "]"));
                return null;
            }
            case -1335458389: {
                if (_service instanceof IDeleteServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label14", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IDeleteServiceProvider [Class=") + sProviderClassName + "]"));
                return null;
            }
            case 433016040: {
                if (_service instanceof IFindByIdsServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label15", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IFindByIdsServiceProvider [Class=") + sProviderClassName + "]"));
                return null;
            }
            case -678768405: {
                if (_service instanceof IFindByIdServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label16", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IFindByIdServiceProvider [Class=") + sProviderClassName + "]"));
                return null;
            }
            default: {
                if (_service instanceof ISelfDefinedServiceProvider) break;
                logger.error((Object)(I18NMessage.get(ServiceConfigHelper.class, "ServiceConfigHelper.label17", "Service\u7c7b\u578b\u4e0d\u5339\u914d! \u6ca1\u6709\u5b9e\u73b0 IWebServiceUserDefine [Class=") + sProviderClassName + "]"));
                return null;
            }
        }
        return _service;
    }

    public static boolean isSelfDefinedMethodName(String _sMethodName) {
        return ServiceConfigHelper.isSelfDefinedMethodName(_sMethodName.toLowerCase().hashCode());
    }

    public static boolean isSelfDefinedMethodName(int _nMethodNameHashCode) {
        for (int i = 0; i < FrameworkConstants.METHOD_TYPES.length; ++i) {
            if (_nMethodNameHashCode != FrameworkConstants.METHOD_TYPES[i]) continue;
            return false;
        }
        return true;
    }
}

