/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyFileX;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.IMagicImage;
import com.trs.wcm.photo.ImageInfo;
import com.trs.wcm.photo.ImageLibHelper;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import org.apache.log4j.Logger;

public class ImageLibMgrImpl
implements IImageLibMgr {
    private DBManager m_oDBMgr = DBManager.getDBManager();
    static final String SQL_DELETE_DOC_QUOTE_IMGS = "delete from WCMDocQuoteImage where DocId=?";
    static final String SQL_GET_QUOTE_DOCUMENTS = "EXISTS(SELECT WCMDocQuoteImage.DocId from WCMDocQuoteImage where WCMDocQuoteImage.QuoteImageId=? and WCMDocument.DocId=WCMDocQuoteImage.DocId)";
    static final String SQL_INSERT_DOC_QUOTE_IMG = "insert into WCMDocQuoteImage(DocId, QuoteImageId) values(?, ?)";
    static final String SQL_EXISTS_DOC_QUOTE_IMG = "SELECT DOCID FROM WCMDocQuoteImage WHERE DocId=? AND QuoteImageId=?";
    private static Logger logger = Logger.getLogger(ImageLibMgrImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo saveImageInfo(ImageInfo _imageInfo) throws WCMException {
        if (_imageInfo == null) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label1", "\u4f20\u5165\u7684ImageInfo\u4e3a\u7a7a\uff01"));
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Document document = null;
        String sSrcFileSavedInServer = null;
        try {
            if (_imageInfo.isAddMode()) {
                document = Document.createNewInstance();
                document.setType(10);
                document.setContent(_imageInfo.getImageTitle());
                sSrcFileSavedInServer = this.saveImageFileToServer(_imageInfo.getImageFileName(), "P0");
                document.setAttribute("SRCFILE", sSrcFileSavedInServer);
                document.setReleaseTime(CMyDateTime.now());
            } else {
                document = Document.findById(_imageInfo.getId());
                document.canEdit(ContextHelper.getLoginUser());
                sSrcFileSavedInServer = document.getAttributeValue("SRCFILE");
                if (!sSrcFileSavedInServer.equalsIgnoreCase(_imageInfo.getImageFileName()) && _imageInfo.getImageFileName() != null && _imageInfo.getImageFileName().length() > 0) {
                    try {
                        CMyFile.deleteFile(this.convertToAbsolutePath(sSrcFileSavedInServer));
                        sSrcFileSavedInServer = this.saveImageFileToServer(_imageInfo.getImageFileName(), "P0");
                        document.setAttribute("SRCFILE", sSrcFileSavedInServer);
                    }
                    catch (CMyException e) {
                        throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01"), e);
                    }
                }
            }
            try {
                this.markOriginalImg(document, sSrcFileSavedInServer, _imageInfo);
            }
            catch (WCMException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01"), ex);
            }
            _imageInfo.setImageFileName(sSrcFileSavedInServer);
            String sImageFiles = this.scaleImage0(_imageInfo, document);
            this.addWaterMark(_imageInfo, CMyString.split(sImageFiles, ","));
            document.setAttribute("WATERMARKFILE", _imageInfo.getMarkImageFile());
            int[] sWaterMarkPos = _imageInfo.getMarkPos();
            String pos = "";
            if (sWaterMarkPos != null && sWaterMarkPos.length > 0) {
                for (int i = 0; i < sWaterMarkPos.length; ++i) {
                    pos = pos + sWaterMarkPos[i] + ",";
                }
            }
            document.setAttribute("WATERMAREKPOS", pos);
            int nDocChannelId = _imageInfo.getImageKindId();
            if (_imageInfo.isAddMode()) {
                Channel docChannel = Channel.findById(nDocChannelId);
                if (docChannel == null) {
                    throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label3", "\u6307\u5b9a\u7684\u4e3b\u5206\u7c7b[ID=") + nDocChannelId + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
                }
                document.setChannel(docChannel);
            }
            if (_imageInfo.isAddMode()) {
                document.setTitle(_imageInfo.getImageTitle());
            }
            document = documentMgr.save(document);
            if (_imageInfo.isAddMode()) {
                int[] pOtherChannelIds = _imageInfo.getOtherImageKinedId();
                for (int i = 0; i < pOtherChannelIds.length; ++i) {
                    if (pOtherChannelIds[i] == nDocChannelId) continue;
                    Channel channel = Channel.findById(pOtherChannelIds[i]);
                    if (channel == null) {
                        throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label5", "\u6307\u5b9a\u5206\u7c7b[ID=") + pOtherChannelIds[i] + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
                    }
                    documentMgr.quoteTo(document, channel);
                }
            }
            _imageInfo.setId(document.getId());
            ImageInfo imageInfo = _imageInfo;
            return imageInfo;
        }
        finally {
            if (!_imageInfo.isAddMode() && document != null && document.isLocked()) {
                document.cancelUpdate(ContextHelper.getLoginUser());
            }
        }
    }

    private void markOriginalImg(Document document, String srcFileSavedInServer, ImageInfo info) throws Exception {
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        if (!imageLibConfig.isOriginalMarked()) {
            return;
        }
        String markedfn = document.getAttributeValue("SRCFILEMARKED");
        FilesMan fileman = FilesMan.getFilesMan();
        String fext = CMyFile.extractFileExt(srcFileSavedInServer);
        if (CMyString.isEmpty(markedfn)) {
            markedfn = fileman.copyWCMFile(srcFileSavedInServer, "W0");
        } else {
            CMyFile.copyFile(CMyFileX.autoToAbsoluteFilePath(srcFileSavedInServer), CMyFileX.autoToAbsoluteFilePath(markedfn));
        }
        int[] scalesizes = imageLibConfig.getScaleSizes();
        if (imageLibConfig.isCmdUsed()) {
            String bmp2type;
            ImageMagickCmd.ImageObj src = new ImageMagickCmd.ImageObj(markedfn);
            if ("bmp".equals(fext.toLowerCase()) && !CMyString.isEmpty(bmp2type = info.getConvertToImageType()) && !"bmp".equals(bmp2type)) {
                try {
                    ImageMagickCmd.convertBmp(src, bmp2type);
                    fext = bmp2type;
                    markedfn = CMyFile.extractFileName(src.filename);
                }
                catch (Exception e) {
                    throw new WCMException("\u8f6c\u6362\u56fe\u7247[" + markedfn + "]\u4e3a[" + bmp2type + "]\u5931\u8d25", e);
                }
            }
            if (info.isAddMark()) {
                int[] arMarkpos = info.getMarkPos();
                String watermarkfile = info.getMarkImageFile();
                ImageMagickCmd.ImageObj watermark = new ImageMagickCmd.ImageObj();
                watermark.setFilename(watermarkfile);
                watermarkfile = fileman.mapFilePath(watermarkfile, 0) + watermarkfile;
                String tempwatermarkfile = fileman.getNextFileName("ST", CMyFile.extractFileExt(watermarkfile), CMyDateTime.now(), true);
                ImageMagickCmd.ImageObj tempwatermark = new ImageMagickCmd.ImageObj(tempwatermarkfile, 0, 0);
                this.addWatermarkWithCmd(imageLibConfig, scalesizes[scalesizes.length - 1], watermark, tempwatermark, watermarkfile, tempwatermarkfile, src.filename, arMarkpos);
            }
        } else {
            int nWaterWidth;
            String bmp2type;
            IMagicImage magicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
            if ("bmp".equals(fext.toLowerCase()) && !CMyString.isEmpty(bmp2type = info.getConvertToImageType()) && !"bmp".equals(bmp2type)) {
                try {
                    magicImage.initMagicImage(markedfn);
                    magicImage.convertImageFormat(bmp2type);
                    String temp = magicImage.writeImageToWCMData("W0");
                    fileman.deleteFile(markedfn);
                    markedfn = temp;
                }
                catch (Exception e) {
                    throw new WCMException("\u8f6c\u6362\u56fe\u7247[" + markedfn + "]\u4e3a[" + bmp2type + "]\u5931\u8d25", e);
                }
            }
            if (info.isAddMark() && (nWaterWidth = imageLibConfig.getWaterMarkSize(scalesizes[scalesizes.length - 1])) > 0) {
                magicImage.initMagicImage(info.getMarkImageFile());
                this.addWaterMark(markedfn, magicImage, nWaterWidth, info.getMarkPos());
            }
        }
        document.setAttribute("SRCFILEMARKED", markedfn);
    }

    protected String scaleImage0(ImageInfo _imageInfo, Document _document) throws WCMException {
        String names;
        String bmp2type;
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int[] pScaleSizes = imageLibConfig.getScaleSizes();
        if (imageLibConfig.isCmdUsed()) {
            this.scaleImageWithCmd(imageLibConfig, _imageInfo, _document);
            return null;
        }
        String sSrcImage = this.saveImageFileToServer(_imageInfo.getImageFileName(), "W0");
        IMagicImage magicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        try {
            magicImage.initMagicImage(sSrcImage);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label6", "\u521d\u59cb\u5316\u539f\u59cb\u56fe\u7247\u5931\u8d25\uff01[File=") + sSrcImage + "]", e);
        }
        if (CMyFile.extractFileExt(_imageInfo.getImageFileName()).equalsIgnoreCase("BMP") && !CMyString.isEmpty(bmp2type = _imageInfo.getConvertToImageType()) && !"bmp".equals(bmp2type)) {
            try {
                magicImage.initMagicImage(sSrcImage);
                magicImage.convertImageFormat(bmp2type);
                String sTemp = sSrcImage;
                sSrcImage = magicImage.writeImageToWCMData("W0");
                CMyFile.deleteFile(this.convertToAbsolutePath(sTemp));
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label7", "\u8f6c\u6362\u56fe\u7247[") + sSrcImage + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label8", "]\u4e3a[") + bmp2type + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label9", "]\u5931\u8d25"), e);
            }
        }
        String[] pOldFileNames = null;
        if (!_document.isAddMode() && !CMyString.isEmpty(names = _document.getRelateWords())) {
            this.deleteUnUsedImages(names, _document.getId());
        }
        StringBuffer result = new StringBuffer(24 * (pScaleSizes.length + 1));
        try {
            magicImage.scaleImage(75, 75);
            String fn = this.writeImage2File(magicImage, pOldFileNames, 0);
            result.append(fn);
            int nWidth = (int)magicImage.getWidth();
            int nHeight = (int)magicImage.getHeight();
            boolean bScaleWidth = "width".equals(imageLibConfig.getScaleStyle()) || "auto".equalsIgnoreCase(imageLibConfig.getScaleStyle()) && nWidth > nHeight;
            int nCurrScale = bScaleWidth ? nWidth : nHeight;
            int nScaleSize = 0;
            int len = pScaleSizes.length;
            for (int i = 1; i < len; ++i) {
                nScaleSize = pScaleSizes[i];
                if (nScaleSize > nCurrScale) {
                    break;
                }
                if (bScaleWidth) {
                    magicImage.scaleImage(nScaleSize, 0);
                } else {
                    magicImage.scaleImage(0, nScaleSize);
                }
                fn = this.writeImage2File(magicImage, pOldFileNames, i);
                result.append(",").append(fn);
            }
        }
        catch (WCMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label10", "\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01"), e);
        }
        finally {
            CMyFile.deleteFile(this.convertToAbsolutePath(sSrcImage));
        }
        _document.setRelateWords(result.toString());
        return result.toString();
    }

    private String scaleImageWithCmd(IImageLibConfig conf, ImageInfo info, Document _document) throws WCMException {
        StringBuffer result;
        block20: {
            String names;
            String sSrcImage = info.getImageFileName();
            FilesMan fileman = FilesMan.getFilesMan();
            if (!_document.isAddMode() && !CMyString.isEmpty(names = _document.getRelateWords())) {
                this.deleteUnUsedImages(names, _document.getId());
            }
            int[] pScaleSizes = conf.getScaleSizes();
            boolean zAddWatermark = info.isAddMark();
            int[] arMarkpos = info.getMarkPos();
            String watermarkfile = null;
            String tempwatermarkfile = null;
            ImageMagickCmd.ImageObj watermark = null;
            ImageMagickCmd.ImageObj tempwatermark = null;
            result = new StringBuffer(24 * (pScaleSizes.length + 1));
            try {
                boolean bScaleWidth;
                String bmp2type;
                if (zAddWatermark) {
                    watermarkfile = info.getMarkImageFile();
                    watermark = new ImageMagickCmd.ImageObj();
                    watermark.setFilename(watermarkfile);
                    watermarkfile = fileman.mapFilePath(watermarkfile, 0) + watermarkfile;
                    tempwatermarkfile = fileman.getNextFileName("ST", CMyFile.extractFileExt(watermarkfile), CMyDateTime.now(), true);
                    tempwatermark = new ImageMagickCmd.ImageObj(tempwatermarkfile, 0, 0);
                }
                ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj();
                srcimg.setFilename(sSrcImage);
                String fext = CMyFile.extractFileExt(sSrcImage);
                if ("bmp".equals(fext.toLowerCase()) && !CMyString.isEmpty(bmp2type = info.getConvertToImageType()) && !"bmp".equals(bmp2type)) {
                    try {
                        ImageMagickCmd.convertBmp(srcimg, bmp2type);
                        fext = bmp2type;
                    }
                    catch (Exception e) {
                        throw new WCMException("\u8f6c\u6362\u56fe\u7247[" + sSrcImage + "]\u4e3a[" + bmp2type + "]\u5931\u8d25", e);
                    }
                }
                String fn = fileman.getNextFileName("W0", fext, CMyDateTime.now(), true);
                ImageMagickCmd.ImageObj dstimg = new ImageMagickCmd.ImageObj(fn, 75, 75);
                ImageMagickCmd.scale(srcimg, dstimg);
                result.append(CMyFile.extractFileName(fn));
                int nScaleSize = 0;
                boolean bl = bScaleWidth = "width".equals(conf.getScaleStyle()) || "auto".equalsIgnoreCase(conf.getScaleStyle()) && srcimg.width > srcimg.height;
                if (bScaleWidth) {
                    int nCurrScale = srcimg.width;
                    dstimg.height = 0;
                    int len = pScaleSizes.length;
                    for (int i = 1; i < len; ++i) {
                        nScaleSize = pScaleSizes[i];
                        if (nScaleSize > nCurrScale) {
                            break block20;
                        }
                        fn = fileman.getNextFileName("W0", fext, CMyDateTime.now(), true);
                        if (nScaleSize == nCurrScale) {
                            result.append(",").append(CMyFile.extractFileName(fn));
                            String sOriginalImage = FilesMan.getFilesMan().mapFilePath(sSrcImage, 0) + sSrcImage;
                            CMyFile.copyFile(sOriginalImage, fn);
                            break block20;
                        }
                        dstimg.width = nScaleSize;
                        dstimg.filename = fn;
                        ImageMagickCmd.scale(srcimg, dstimg);
                        if (zAddWatermark) {
                            this.addWatermarkWithCmd(conf, nScaleSize, watermark, tempwatermark, watermarkfile, tempwatermarkfile, fn, arMarkpos);
                        }
                        result.append(",").append(CMyFile.extractFileName(fn));
                    }
                    break block20;
                }
                int nCurrScale = srcimg.height;
                dstimg.width = 0;
                int len = pScaleSizes.length;
                for (int i = 1; i < len; ++i) {
                    nScaleSize = pScaleSizes[i];
                    if (nScaleSize > nCurrScale) {
                        break;
                    }
                    fn = fileman.getNextFileName("W0", fext, CMyDateTime.now(), true);
                    if (nScaleSize == nCurrScale) {
                        result.append(",").append(CMyFile.extractFileName(fn));
                        String sOriginalImage = FilesMan.getFilesMan().mapFilePath(sSrcImage, 0) + sSrcImage;
                        CMyFile.copyFile(sOriginalImage, fn);
                        break;
                    }
                    dstimg.height = nScaleSize;
                    dstimg.filename = fn;
                    ImageMagickCmd.scale(srcimg, dstimg);
                    if (zAddWatermark) {
                        this.addWatermarkWithCmd(conf, nScaleSize, watermark, tempwatermark, watermarkfile, tempwatermarkfile, fn, arMarkpos);
                    }
                    result.append(",").append(CMyFile.extractFileName(fn));
                }
            }
            catch (Exception e) {
                throw new WCMException("\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01", e);
            }
            finally {
                if (tempwatermarkfile != null) {
                    // empty if block
                }
            }
        }
        _document.setRelateWords(result.toString());
        return result.toString();
    }

    private String getWebPic(String attributeValue) {
        String sResult = "";
        if (attributeValue != null) {
            int nIndex = attributeValue.lastIndexOf(47);
            if (nIndex >= 0) {
                sResult = attributeValue.substring(nIndex + 1);
            } else if (attributeValue.startsWith("W0")) {
                sResult = attributeValue;
            }
        }
        return sResult;
    }

    private void deleteUnUsedImages(String names, int nPhotoDocId) throws WCMException {
        IImageLibMgr m_libManager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        Documents docs = m_libManager.getDocumentsQuoteImage(nPhotoDocId);
        Document tempDoc = null;
        String sUsedUrl = "";
        int size = docs.size();
        for (int i = 0; i < size; ++i) {
            tempDoc = (Document)docs.getAt(i);
            if (tempDoc == null) continue;
            HtmlElementFinder finder = new HtmlElementFinder(tempDoc.getHtmlContent());
            HtmlElement photo = null;
            String photourl = null;
            while ((photo = finder.findNextElement("img")) != null) {
                if (!"1".equals(photo.getAttributeValue("fromphoto")) || (photourl = this.getWebPic(photo.getAttributeValue("src"))).equals("")) continue;
                sUsedUrl = sUsedUrl + photourl + ",";
            }
        }
        String sWhere = "RelatePhotoIds = ? AND APPFLAG = 20";
        WCMFilter filter = new WCMFilter("WCMAPPENDIX", sWhere, "");
        filter.addSearchValues(nPhotoDocId + "");
        Appendixes appendixs = Appendixes.openWCMObjs(null, filter);
        Appendix tempAppendix = null;
        int size2 = appendixs.size();
        for (int i = 0; i < size2; ++i) {
            tempAppendix = (Appendix)appendixs.getAt(i);
            if (tempAppendix == null || tempAppendix.getFile() == null) continue;
            sUsedUrl = sUsedUrl + tempAppendix.getFile() + ",";
        }
        String[] temp = names.split(",");
        FilesMan fileMan = FilesMan.getFilesMan();
        int len = temp.length;
        for (int i = 0; i < len; ++i) {
            if (sUsedUrl.indexOf(temp[i]) >= 0) continue;
            fileMan.deleteFile(temp[i]);
        }
    }

    private void addWatermarkWithCmd(IImageLibConfig conf, int nScaleSize, ImageMagickCmd.ImageObj watermark, ImageMagickCmd.ImageObj tempwatermark, String watermarkfile, String tempwatermarkfile, String fn, int[] arMarkpos) throws Exception {
        int nWatermarkWidth = conf.getWaterMarkSize(nScaleSize);
        if (nWatermarkWidth <= 0) {
            return;
        }
        int w = watermark.width;
        if (w > nWatermarkWidth) {
            int h = watermark.height;
            tempwatermark.width = nWatermarkWidth;
            tempwatermark.height = h * nWatermarkWidth / w <= 10 ? h : 0;
            ImageMagickCmd.scale(watermark, tempwatermark);
            ImageMagickCmd.addWaterkmark(tempwatermarkfile, fn, arMarkpos);
        } else {
            ImageMagickCmd.addWaterkmark(watermarkfile, fn, arMarkpos);
        }
    }

    private String writeImage2File(IMagicImage _magicImage, String[] _oldFileNames, int _index) throws Exception {
        String fn = null;
        if (_oldFileNames != null && _oldFileNames.length > _index) {
            fn = _oldFileNames[_index];
            _magicImage.writeImage(fn);
            fn = CMyFile.extractFileName(fn);
        } else {
            fn = _magicImage.writeImageToWCMData("W0");
        }
        return fn;
    }

    protected String scaleImage(ImageInfo _imageInfo, Document _document) throws WCMException {
        String bmp2type;
        IMagicImage magicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        String sSrcImageFilePath = this.saveImageFileToServer(_imageInfo.getImageFileName(), "W0");
        int[] pScaleSizes = imageLibConfig.getScaleSizes();
        if (CMyFile.extractFileExt(_imageInfo.getImageFileName()).equalsIgnoreCase("BMP") && !CMyString.isEmpty(bmp2type = _imageInfo.getConvertToImageType()) && !"bmp".equals(bmp2type)) {
            try {
                magicImage.initMagicImage(sSrcImageFilePath);
                magicImage.convertImageFormat(_imageInfo.getConvertToImageType());
                sSrcImageFilePath = magicImage.writeImageToWCMData("W0");
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label7", "\u8f6c\u6362\u56fe\u7247[") + sSrcImageFilePath + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label8", "]\u4e3a[") + _imageInfo.getConvertToImageType() + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label9", "]\u5931\u8d25"), e);
            }
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        StringBuffer sbImageFiles = new StringBuffer(24 * (pScaleSizes.length + 1));
        String[] pOldFileNames = null;
        if (!_document.isAddMode()) {
            pOldFileNames = ImageLibHelper.getAllImageFiles(_document);
        }
        try {
            magicImage.initMagicImage(sSrcImageFilePath);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label6", "\u521d\u59cb\u5316\u539f\u59cb\u56fe\u7247\u5931\u8d25\uff01[File=") + sSrcImageFilePath + "]", e);
        }
        try {
            boolean bScaleWidth = magicImage.getWidth() > magicImage.getHeight();
            for (int i = 0; i < pScaleSizes.length; ++i) {
                int nCurrScale = (int)(bScaleWidth ? magicImage.getWidth() : magicImage.getHeight());
                if (i == 0 || nCurrScale >= pScaleSizes[i]) {
                    if (bScaleWidth) {
                        magicImage.scaleImage(pScaleSizes[i], i == 0 ? 75 : 0);
                    } else {
                        magicImage.scaleImage(i == 0 ? 75 : 0, pScaleSizes[i]);
                    }
                    String sCurrFileName = null;
                    if (pOldFileNames != null && pOldFileNames.length > i) {
                        String sOldFilePath = filesMan.mapFilePath(pOldFileNames[i], 0) + pOldFileNames[i];
                        magicImage.writeImage(sOldFilePath);
                        sCurrFileName = pOldFileNames[i];
                    } else {
                        sCurrFileName = magicImage.writeImageToWCMData("W0");
                    }
                    if (i > 0) {
                        sbImageFiles.append(',');
                    }
                    sbImageFiles.append(sCurrFileName);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label10", "\u7f29\u653e\u56fe\u7247\u5931\u8d25\uff01"), e);
        }
        _document.setRelateWords(sbImageFiles.toString());
        return sbImageFiles.toString();
    }

    private void addWaterMark(ImageInfo _imageInfo, String[] _pScaleImageFiles) throws WCMException {
        if (_pScaleImageFiles == null || _pScaleImageFiles.length <= 0) {
            return;
        }
        if (!_imageInfo.isAddMark()) {
            return;
        }
        MagicImageImpl warterMarkImage = new MagicImageImpl();
        try {
            warterMarkImage.initMagicImage(_imageInfo.getMarkImageFile());
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label12", "\u8bfb\u53d6\u6c34\u5370\u6587\u4ef6[") + _imageInfo.getMarkImageFile() + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"));
        }
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int[] pScaleSizes = imageLibConfig.getScaleSizes();
        try {
            int scaleImagesCount = _pScaleImageFiles.length;
            int nWaterWidth = 0;
            int[] pWaterMarkpos = _imageInfo.getMarkPos();
            for (int i = 0; i < pScaleSizes.length && scaleImagesCount > i; ++i) {
                nWaterWidth = imageLibConfig.getWaterMarkSize(pScaleSizes[i]);
                if (nWaterWidth <= 0) continue;
                this.addWaterMark(_pScaleImageFiles[i], warterMarkImage, nWaterWidth, pWaterMarkpos);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label14", "\u56fe\u7247\u52a0\u6c34\u5370\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    public void addWaterMark(String _sImageFile, String _sWaterMarkFile, int[] _pWarterMarkPos) throws Exception {
        int nWidth;
        IImageLibConfig imageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        FilesMan fileman = FilesMan.getFilesMan();
        int[] scalesizes = imageLibConfig.getScaleSizes();
        if (imageLibConfig.isCmdUsed()) {
            ImageMagickCmd.ImageObj src = new ImageMagickCmd.ImageObj(_sImageFile);
            int[] arMarkpos = _pWarterMarkPos;
            String watermarkfile = _sWaterMarkFile;
            ImageMagickCmd.ImageObj watermark = new ImageMagickCmd.ImageObj();
            watermark.setFilename(watermarkfile);
            watermarkfile = fileman.mapFilePath(watermarkfile, 0) + watermarkfile;
            String tempwatermarkfile = fileman.getNextFileName("ST", CMyFile.extractFileExt(watermarkfile), CMyDateTime.now(), true);
            ImageMagickCmd.ImageObj tempwatermark = new ImageMagickCmd.ImageObj(tempwatermarkfile, 0, 0);
            this.addWatermarkWithCmd(imageLibConfig, scalesizes[scalesizes.length - 1], watermark, tempwatermark, watermarkfile, tempwatermarkfile, src.filename, arMarkpos);
            return;
        }
        IMagicImage oSrcMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        IMagicImage oWaterMarkMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        try {
            oSrcMagicImage.initMagicImage(_sImageFile);
            oWaterMarkMagicImage.initMagicImage(_sWaterMarkFile);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label15", "\u521d\u59cb\u5316\u56fe\u7247[") + _sImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), e);
        }
        try {
            float fConfigValue = Float.parseFloat(ConfigServer.getServer().getSysConfigValue("WATERMARK_SIZE_FOR_DOC_APPENDIX", "50"));
            double nSrcWidth = oSrcMagicImage.getWidth();
            nWidth = (int)(fConfigValue >= 1.0f ? fConfigValue : (float)Math.round(nSrcWidth * (double)fConfigValue));
            if (nWidth > (int)Math.round(nSrcWidth)) {
                nWidth = Math.round(nWidth) / 2;
            }
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u548c\u6e90\u56fe\u7247\u7684\u5bbd\u5ea6\u5931\u8d25\uff01", e);
        }
        this.addWaterMark(_sImageFile, oWaterMarkMagicImage, nWidth, _pWarterMarkPos);
    }

    private void addWaterMark(String _sImageFile, IMagicImage _warterMarkImage, int _nWarterWidth, int[] _pWarterMarkPos) throws WCMException {
        IMagicImage oSrcMagicImage = (IMagicImage)DreamFactory.createObjectById("IMagicImage");
        boolean bScaleWidth = true;
        try {
            oSrcMagicImage.initMagicImage(_sImageFile);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label15", "\u521d\u59cb\u5316\u56fe\u7247[") + _sImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), e);
        }
        String sWaterMarkImageFile = _warterMarkImage.getSrcImageFileName();
        try {
            int w;
            if (!bScaleWidth) {
                _warterMarkImage.rotateImage(90.0);
                sWaterMarkImageFile = _warterMarkImage.writeImageToSystemTemp();
                _warterMarkImage.initMagicImage(sWaterMarkImageFile);
            }
            if ((w = (int)_warterMarkImage.getWidth()) > _nWarterWidth) {
                _warterMarkImage.scaleImage(_nWarterWidth, 0);
                sWaterMarkImageFile = _warterMarkImage.writeImageToSystemTemp();
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label16", "\u6c34\u5370\u6587\u4ef6[") + sWaterMarkImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label17", "]\u7f29\u653e\u5931\u8d25\uff01"), e);
        }
        String sTempImageFile = null;
        try {
            oSrcMagicImage.addWaterMark(sWaterMarkImageFile, _pWarterMarkPos);
            sTempImageFile = oSrcMagicImage.writeImageToSystemTemp();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label18", "\u7ed9\u6587\u4ef6[") + _sImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label19", "]\u6dfb\u52a0\u6c34\u5370[") + sWaterMarkImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), e);
        }
        try {
            oSrcMagicImage.initMagicImage(sTempImageFile);
            CMyFile.moveFile(sTempImageFile, CMyFileX.autoToAbsoluteFilePath(_sImageFile));
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label18", "\u7ed9\u6587\u4ef6[") + _sImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label19", "]\u6dfb\u52a0\u6c34\u5370[") + sWaterMarkImageFile + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01")), (Throwable)e);
        }
    }

    private String saveImageFileToServer(String _sImageFileName, String _sPathFlag) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sImageFileName = this.convertToAbsolutePath(_sImageFileName);
        String sNewFileName = filesMan.getNextFileName(_sPathFlag, CMyFile.extractFileExt(sImageFileName));
        String sNewFilePath = filesMan.mapFilePath(sNewFileName, 0) + sNewFileName;
        try {
            CMyFile.copyFile(sImageFileName, sNewFilePath);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label20", "\u4fdd\u5b58\u6587\u4ef6[") + sImageFileName + "]-->[" + sNewFilePath + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label13", "]\u5931\u8d25\uff01"), e);
        }
        return sNewFileName;
    }

    private String convertToAbsolutePath(String _sImageFileName) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sImageFileName = _sImageFileName;
        if (CMyFile.fileExists(sImageFileName)) {
            return sImageFileName;
        }
        try {
            sImageFileName = filesMan.mapFilePath(_sImageFileName, 0) + _sImageFileName;
        }
        catch (WCMException wCMException) {
            // empty catch block
        }
        if (!CMyFile.fileExists(sImageFileName)) {
            throw new WCMException(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label21", "\u6307\u5b9a\u7684\u56fe\u7247\u6587\u4ef6[") + sImageFileName + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label4", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return sImageFileName;
    }

    @Override
    public void deleteDocumentQuoteImage(int _nDocumentId, int _nImageId) throws WCMException {
        String[] SQL_DELETE_DOC_QUOTE_IMG = new String[]{"delete from WCMDocQuoteImage where DocId=? and QuoteImageId=?"};
        int[] pParameters = new int[]{_nDocumentId, _nImageId};
        this.m_oDBMgr.sqlExecuteUpdate(SQL_DELETE_DOC_QUOTE_IMG, pParameters);
    }

    @Override
    public void deleteDocumentQuoteImage(int _nDocumentId, String _sExcludeImageIds) throws WCMException {
        boolean bDeleteAll = _sExcludeImageIds == null || _sExcludeImageIds.length() == 0;
        String[] deleteSQL = new String[]{SQL_DELETE_DOC_QUOTE_IMGS + (bDeleteAll ? "" : " and QuoteImageId not in(" + _sExcludeImageIds + ")")};
        int[] pParameters = new int[]{_nDocumentId};
        this.m_oDBMgr.sqlExecuteUpdate(deleteSQL, pParameters);
    }

    @Override
    public void deleteDocumentQuoteImage(int _nDocumentId) throws WCMException {
        String[] deleteSQL = new String[]{SQL_DELETE_DOC_QUOTE_IMGS};
        int[] pParameters = new int[]{_nDocumentId};
        this.m_oDBMgr.sqlExecuteUpdate(deleteSQL, pParameters);
    }

    @Override
    public Documents getDocumentsQuoteImage(int _nImageId) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", SQL_GET_QUOTE_DOCUMENTS, "");
        WCMFilter filter2 = new WCMFilter("wcmdocument d JOIN WCMDocQuoteImage q ON d.DocId = q.DocId", "q.QuoteImageId=? AND q.QuoteImageId IS NOT NULL", " ");
        filter2.setSelect(" DISTINCT q.DOCID");
        filter2.addSearchValues(0, _nImageId);
        return Documents.openWCMObjs(null, filter2);
    }

    @Override
    public void recordDocumentQuoteImage(int _nDocumentId, int _nImageId) throws WCMException {
        boolean bExistsData;
        int[] pParameters = new int[]{_nDocumentId, _nImageId};
        boolean bl = bExistsData = this.m_oDBMgr.sqlExecuteIntQuery(SQL_EXISTS_DOC_QUOTE_IMG, pParameters) > 0;
        if (bExistsData) {
            return;
        }
        this.m_oDBMgr.sqlExecuteUpdate(new String[]{SQL_INSERT_DOC_QUOTE_IMG}, pParameters);
    }

    @Override
    public Appendixes getImageAppendixes(WCMFilter _extraFilter, BaseChannel _oChannelOrSite, boolean _bIncludeImported) throws WCMException {
        int nParamIndex = 0;
        WCMFilter filter = new WCMFilter("", null, "");
        filter.addSearchValues(nParamIndex++, 20);
        filter.addSearchValues(nParamIndex++, 30);
        String sWhere = "AppFlag in(?, ?)";
        if (!_bIncludeImported) {
            sWhere = sWhere + " and IsImportToImageLib=?";
            filter.addSearchValues(nParamIndex++, 0);
        }
        if (_oChannelOrSite != null) {
            if (_oChannelOrSite.isSite()) {
                String sSiteWhere = "exists(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChnlDoc.ChnlId=WCMChannel.ChannelId)";
                sWhere = sWhere + " and exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.Modal=1 and " + sSiteWhere + " and WCMAppendix.AppDocId=WCMChnlDoc.DocId)";
            } else {
                sWhere = sWhere + " and exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.Modal=1 and WCMChnlDoc.ChnlId=? and WCMAppendix.AppDocId=WCMChnlDoc.DocId)";
            }
            filter.addSearchValues(nParamIndex++, _oChannelOrSite.getId());
        }
        filter.setWhere(sWhere);
        filter.mergeWith(_extraFilter);
        return Appendixes.openWCMObjs(null, filter);
    }

    @Override
    public ImageInfo importImageAppendix(User _currUser, int _nAppendixId, ImageInfo _imageInfo) throws WCMException {
        Appendix appendix = Appendix.findById(_nAppendixId);
        if (appendix == null) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label22", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u56fe\u7247\u9644\u4ef6\uff01[ID=") + _nAppendixId + "]"));
            return null;
        }
        if (appendix.getFlag() != 20 && appendix.getFlag() != 30) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label23", "\u6307\u5b9a\u7684\u9644\u4ef6[ID=") + _nAppendixId + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label24", "]\u4e0d\u662f\u56fe\u7247\uff01")));
            return null;
        }
        Document document = Document.findById(appendix.getDocId());
        if (document == null) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label25", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u56fe\u7247\u9644\u4ef6[ID=") + _nAppendixId + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label26", "]\u7684\u6240\u5c5e\u6587\u6863\uff01[DocId=") + appendix.getDocId() + "]"));
            return null;
        }
        int nTypeQuoted = ImageLibHelper.getTypeQuotedImageLib(appendix);
        if (nTypeQuoted != 0) {
            logger.error((Object)(I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label27", "\u6307\u5b9a\u7684\u56fe\u7247\u9644\u4ef6[ID=") + _nAppendixId + I18NMessage.get(ImageLibMgrImpl.class, "ImageLibMgrImpl.label28", "]\u662f\u5f15\u7528\u56fe\u7247\u5e93\u7684\u9644\u4ef6\uff01")));
            return null;
        }
        _imageInfo.setImageTitle(document.getTitle());
        _imageInfo.setImageFileName(appendix.getFile());
        _imageInfo.setSrcFileName(appendix.getSrcFile());
        ImageInfo result = this.saveImageInfo(_imageInfo);
        if (appendix.getPropertyAsInt("IsImportToImageLib", 0) == 0) {
            appendix.canEdit(_currUser);
            appendix.setProperty("IsImportToImageLib", 1L);
            appendix.update(_currUser);
        }
        return result;
    }
}

