/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.wcm.photo.IImageLibConfig;

public class ImageLibHelper {
    public static String getImageFileNameByScaleIndex(Document _document, int _nScaleIndex) throws WCMException {
        return ImageLibHelper.getImageFileNameByScaleIndex(_document, _nScaleIndex, true);
    }

    public static String getImageFileNameByScaleIndex(Document _document, int _nScaleIndex, boolean _bOnlyFileName) throws WCMException {
        String[] pImageFile = ImageLibHelper.getAllImageFiles(_document);
        if (pImageFile == null) {
            return "";
        }
        if (pImageFile.length <= _nScaleIndex) {
            _nScaleIndex = pImageFile.length - 1;
        }
        String sFileName = pImageFile[_nScaleIndex];
        if (_bOnlyFileName) {
            return sFileName;
        }
        return FilesMan.getFilesMan().mapFilePath(sFileName, 1) + sFileName;
    }

    public static String getOrigImageFilePath(Document _document, boolean _bOnlyFileName) throws WCMException {
        String sFileName = _document.getAttributeValue("srcfile");
        if (sFileName == null || sFileName.length() <= 0) {
            return "";
        }
        if (_bOnlyFileName) {
            return sFileName;
        }
        sFileName = FilesMan.getFilesMan().copyWCMFile(sFileName, "W0");
        return FilesMan.getFilesMan().mapFilePath(sFileName, 1) + sFileName;
    }

    public static String getOrigImageFileName(Document _document, boolean _bOnlyFileName) throws WCMException {
        String[] pImageFile = ImageLibHelper.getAllImageFiles(_document);
        if (pImageFile == null) {
            return "";
        }
        int nScaleIndex = pImageFile.length - 1;
        String sFileName = pImageFile[nScaleIndex];
        if (_bOnlyFileName) {
            return sFileName;
        }
        if (_document.getStatusId() == 10) {
            IPublishContent content = PublishElementFactory.makeContentFrom(_document, null);
            PublishPathCompass compass = new PublishPathCompass();
            return compass.getAbsoluteHttpPath(content) + sFileName;
        }
        return FilesMan.getFilesMan().mapFilePath(sFileName, 1) + sFileName;
    }

    public static String[] getAllImageFiles(Document _document) {
        String sImageFiles = _document.getRelateWords();
        if (sImageFiles == null || sImageFiles.length() <= 0) {
            return null;
        }
        String[] pImageFile = CMyString.split(sImageFiles, ",");
        return pImageFile;
    }

    public static String getImageFileNameByScale(Document _document, int _nScale) throws WCMException {
        return ImageLibHelper.getImageFileNameByScale(_document, _nScale, true);
    }

    public static String getImageFileNameByScale(Document _document, int _nScale, boolean _bOnlyFileName) throws WCMException {
        IImageLibConfig oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
        int nScaleIndex = -1;
        int[] pScales = oImageLibConfig.getScaleSizes();
        for (int i = 0; i < pScales.length; ++i) {
            if (pScales[i] != _nScale) continue;
            nScaleIndex = i;
            break;
        }
        if (nScaleIndex < 0) {
            throw new WCMException(I18NMessage.get(ImageLibHelper.class, "ImageLibHelper.label2", "\u6307\u5b9a\u7684\u5c3a\u5bf8[") + _nScale + I18NMessage.get(ImageLibHelper.class, "ImageLibHelper.label3", "]\u5728\u7cfb\u7edf\u4e2d\u6ca1\u6709\u5b9a\u4e49\uff01"));
        }
        return ImageLibHelper.getImageFileNameByScaleIndex(_document, nScaleIndex, _bOnlyFileName);
    }

    public static int getTypeQuotedImageLib(Appendix _appendix) {
        String sFileName = _appendix.getFile();
        if (_appendix.getFlag() != 20 || sFileName.indexOf(47) < 0) {
            return 0;
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        if (sFileName.startsWith(filesMan.getPathConfigValue("W0", 1))) {
            return 1;
        }
        return 2;
    }
}

