/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUrl;
import com.trs.infra.util.IURLAcceptor;
import com.trs.infra.util.WCMHTMLContentURLAcceptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFilter {
    public static String stripTags(String _sText, String[] _sTags) throws WCMException {
        if (CMyString.isEmpty(_sText)) {
            return _sText;
        }
        if (_sTags == null || _sTags.length == 0) {
            return _sText;
        }
        String sRegStart = "(?i)<\\s*(";
        String sRegEnd = "<\\s*/\\s*(";
        for (int i = 0; i < _sTags.length; ++i) {
            if (_sTags[i].trim() == "") continue;
            if (i < _sTags.length - 1) {
                sRegStart = sRegStart + _sTags[i] + "|";
                sRegEnd = sRegEnd + _sTags[i] + "|";
                continue;
            }
            sRegStart = sRegStart + _sTags[i] + ")[^>]*>";
            sRegEnd = sRegEnd + _sTags[i] + ")\\s*>";
        }
        _sText = _sText.replaceAll(sRegStart + "[^<]*" + sRegEnd, "");
        _sText = _sText.replaceAll(sRegStart, "");
        return _sText;
    }

    public static String stripTags(String _sText) throws WCMException {
        if (CMyString.isEmpty(_sText)) {
            return _sText;
        }
        String sRegStartAndEnd = "(?i)<\\s*(script|iframe|frame|link)[^>]*>[^<]*<\\s*/\\s*(script|iframe|frame|link)\\s*>";
        String sRegAlone = "(?i)<\\s*link[^>]*>";
        _sText = _sText.replaceAll(sRegStartAndEnd, "");
        _sText = _sText.replaceAll(sRegAlone, "");
        return _sText;
    }

    public static String stripUrl(String _sText, String _sPrefix, String[] _sSuffixes, IURLAcceptor urlAcceptor) throws WCMException {
        if (CMyString.isEmpty(_sText)) {
            return _sText;
        }
        if (urlAcceptor == null) {
            return _sText;
        }
        if (_sSuffixes == null || _sSuffixes.length == 0) {
            _sSuffixes = new String[]{".jsp", ".do"};
        }
        String _sHrefReg = "(?i)<\\s*(a|link)\\s*.*?href\\s*=\\s*(['\"][^'\"]*['\"]|[^\\s>]*)";
        String _sHreReplace = "(?i)(<\\s*(a|link)\\s*.*?href\\s*=\\s*)";
        String _sSrcReg = "(?i)<\\s*(script|iframe|frame|img)\\s*.*?src\\s*=\\s*(['\"][^'\"]*['\"]|[^\\s>]*)";
        String _sSrcReplace = "(?i)(<\\s*(script|iframe|frame|img)\\s*.*?src\\s*=\\s*)";
        String _sUrlReg = "(?i)(url\\()([^\\)]*)";
        String _sUrlReplace = "(?i)(url\\()";
        _sText = TextFilter.stripUrl(_sText, _sPrefix, _sSuffixes, _sHrefReg, _sHreReplace, urlAcceptor);
        _sText = TextFilter.stripUrl(_sText, _sPrefix, _sSuffixes, _sSrcReg, _sSrcReplace, urlAcceptor);
        _sText = TextFilter.stripUrl(_sText, _sPrefix, _sSuffixes, _sUrlReg, _sUrlReplace, urlAcceptor);
        return _sText;
    }

    private static String stripUrl(String _sText, String _sPrefix, String[] _sSuffixes, String _sUrlReg, String _sReplaceReg, IURLAcceptor urlAcceptor) throws WCMException {
        if (CMyString.isEmpty(_sText)) {
            return _sText;
        }
        if (CMyString.isEmpty(_sUrlReg)) {
            return _sText;
        }
        if (CMyString.isEmpty(_sReplaceReg)) {
            return _sText;
        }
        if (urlAcceptor == null) {
            return _sText;
        }
        if (_sSuffixes == null || _sSuffixes.length == 0) {
            _sSuffixes = new String[]{".jsp", ".do"};
        }
        Pattern oPattern = Pattern.compile(_sUrlReg);
        Matcher oMatcher = oPattern.matcher(_sText);
        String sMatch = null;
        String sUrl = null;
        String sFileName = "";
        block0: while (oMatcher.find()) {
            sMatch = oMatcher.group(2);
            sUrl = sMatch;
            if (sUrl.startsWith("\"") || sUrl.startsWith("'")) {
                sUrl = sUrl.substring(1);
            }
            if (sUrl.endsWith("\"") || sUrl.endsWith("'")) {
                sUrl = sUrl.substring(0, sUrl.length() - 1);
            }
            sFileName = CMyUrl.extractFileName(sUrl);
            if (sUrl.matches("(?i)^(https?|file|ftp|gopher|mailto|MMS|ed2k|Flashget|thunder)://.*") && (CMyString.isEmpty(_sPrefix) || !sUrl.startsWith(_sPrefix))) continue;
            for (int i = 0; i < _sSuffixes.length; ++i) {
                if (!sFileName.endsWith(_sSuffixes[i]) || urlAcceptor.accept(sUrl, null, sFileName)) continue;
                if (sMatch.indexOf("?") >= 0) {
                    sMatch = sMatch.replaceAll("\\?", "\\\\?");
                }
                String sTemp = "";
                if (sMatch.startsWith("\"")) {
                    sTemp = "\"\"";
                }
                if (sMatch.startsWith("'")) {
                    sTemp = "''";
                }
                _sText = _sText.replaceAll(_sReplaceReg + sMatch, "$1" + sTemp);
                continue block0;
            }
        }
        return _sText;
    }

    public static String stripScripts(String _sText) throws WCMException {
        if (CMyString.isEmpty(_sText)) {
            return _sText;
        }
        String sRegScripts = "(?i)<\\s*script[^>]*>[^<]*<\\s*/\\s*script\\s*>";
        String sRegJavaScript = "(?i)(<[^>]*?)javascript:";
        _sText = _sText.replaceAll(sRegScripts, "");
        _sText = _sText.replaceAll(sRegJavaScript, "$1");
        return _sText;
    }

    public static String stripEvents(String _sText) throws WCMException {
        if (CMyString.isEmpty(_sText)) {
            return _sText;
        }
        String[] sEvents = new String[]{"onload", "onunload", "onclick", "onchange", "onsubmit", "onreset", "onblur", "onfocus", "onabort", "onkeydown", "onkeypress", "onkeyup", "ondblclick", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup"};
        for (int i = 0; i < sEvents.length; ++i) {
            _sText = _sText.replaceAll("(?i)(<.*?)" + sEvents[i] + "(\\s*=)", "$1$2");
        }
        return _sText;
    }

    public static String stripText(String _sText, String[] _sTags, String _sPrefix, String[] _sSuffixes, IURLAcceptor urlAcceptor) throws WCMException {
        _sText = TextFilter.stripScripts(_sText);
        _sText = TextFilter.stripEvents(_sText);
        _sText = TextFilter.stripTags(_sText, _sTags);
        _sText = TextFilter.stripUrl(_sText, _sPrefix, _sSuffixes, urlAcceptor);
        return _sText;
    }

    public static String stripText(String _sText, boolean stripScript) throws WCMException {
        String[] sTags = null;
        sTags = stripScript ? new String[]{"iframe", "frame", "script"} : new String[]{"iframe", "frame"};
        String[] sSuffixes = new String[]{".jsp", ".do"};
        WCMHTMLContentURLAcceptor urlAcceptor = new WCMHTMLContentURLAcceptor();
        _sText = TextFilter.stripScripts(_sText);
        _sText = TextFilter.stripEvents(_sText);
        _sText = TextFilter.stripTags(_sText, sTags);
        _sText = TextFilter.stripUrl(_sText, "", sSuffixes, urlAcceptor);
        return _sText;
    }
}

