/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class LocaleChecker {
    public static void main(String[] args) throws Exception {
        String sRootPath = "D:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app";
        String sResultFile = "/e:/localtest.txt";
        if (args.length > 0) {
            sRootPath = args[0];
        }
        if (args.length > 1) {
            sResultFile = args[1];
        }
        System.setOut(new PrintStream(new FileService(sResultFile).getOutputStream()));
        FileService fDir = new FileService(sRootPath);
        fDir.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                if (pathname.isDirectory()) {
                    if (pathname.getName().matches("(?i).*(locale|lang).*")) {
                        return false;
                    }
                    if ("locale".equals(pathname.getName())) {
                        return false;
                    }
                    if ("lang".equals(pathname.getName())) {
                        return false;
                    }
                    pathname.listFiles(this);
                } else {
                    if (pathname.getName().endsWith("_cn")) {
                        return false;
                    }
                    if (LocaleChecker.accept(pathname.getName())) {
                        LocaleChecker.check(pathname);
                    }
                }
                return false;
            }
        });
    }

    private static boolean accept(String name) {
        return name.endsWith(".js") || name.endsWith(".jsp") || name.endsWith(".html") || name.endsWith(".htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean check(FileStore f) {
        BufferedReader reader = null;
        InputStreamReader insr = null;
        InputStream ins = null;
        String encode = CharsetDetector.detect(f.getAbsolutePath());
        try {
            ins = f.getInputStream();
            insr = new InputStreamReader(ins, encode);
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            int count = 0;
            boolean zFirst = true;
            String lastline = null;
            while (line != null) {
                ++count;
                if (!LocaleChecker.isCommentLine(line) && CMyString.isContainChineseChar(line)) {
                    int ix = -1;
                    if (f.getName().endsWith(".js")) {
                        ix = line.indexOf("wcm.LANG");
                        if (ix == -1) {
                            ix = line.indexOf("FCKLang");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("fcklang");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("ValidatorLang");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("LANG");
                        }
                    } else {
                        ix = line.indexOf("wcm.LANG");
                        if (ix == -1) {
                            ix = line.indexOf("WCMAnt:param");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("throw new");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("LocaleServer");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("FCKLang");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("fcklang");
                        }
                        if (ix == -1) {
                            ix = line.indexOf("System.out.println");
                        }
                    }
                    if (ix == -1 && lastline != null && !CMyString.isContainChineseChar(lastline) && lastline.indexOf("WCMAnt:param") == -1) {
                        char[] chars = line.toCharArray();
                        char ch = '\u0000';
                        int len = chars.length;
                        block24: for (int i = 0; i < len; ++i) {
                            ch = chars[i];
                            if (ch <= '\u007f') continue;
                            while (i > 0) {
                                if (chars[i - 1] == '/' && chars[i - 2] == '/' || chars[i - 1] == '*' && chars[i - 2] == '/' || chars[i - 1] == '-' && chars[i - 2] == '-' && chars[i - 3] == '!' && chars[i - 4] == '<') break block24;
                                --i;
                            }
                            if (zFirst) {
                                System.out.println();
                                System.out.println(f.getAbsolutePath());
                                zFirst = false;
                            }
                            System.out.println(count + ":" + line);
                            break;
                        }
                    }
                }
                lastline = line;
                line = reader.readLine();
            }
        }
        catch (Exception ex) {
            System.out.println("fail:" + f.getAbsolutePath());
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private static boolean isCommentLine(String line) {
        return (line = line.trim()).startsWith("<!--") || line.startsWith("<%--") || line.startsWith("/*") || line.startsWith("*") || line.startsWith("//");
    }
}

