/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import java.sql.SQLException;

public class DocFormReset
extends Thread {
    public static int THREAD_SIZE = 20;
    public static int MIN_DOCID = 0;
    public static int MAX_DOCID = 0;
    public static String FILE_DIRECTORY = "c://";
    public static int OFFSET_DOCID = 100;
    public static int MAX_COUNT_WRITE_FILE = 2000;
    private DBManager m_oDBMgr = DBManager.getDBManager();
    private static int m_nMinDocId = 0;
    private static int m_nMaxDocId = 0;
    private static int m_nNextMaxDocId = 0;

    private static int analyzeDocForm(String _sDocHtmlCon) throws WCMException {
        if (CMyString.isEmpty(_sDocHtmlCon)) {
            return 1;
        }
        HtmlElementFinder elementFinder = null;
        HtmlElement element = null;
        try {
            String sSrc;
            elementFinder = new HtmlElementFinder(_sDocHtmlCon);
            element = elementFinder.findNextElement("EMBED", true);
            if (element != null && !CMyString.isEmpty(sSrc = element.getAttributeValue("src"))) {
                return DocFormReset.analyzeExt(sSrc);
            }
            elementFinder.setPosition(0);
            element = elementFinder.findNextElement("IMG", true);
            if (element != null && element != null) {
                return 2;
            }
        }
        catch (Exception ex) {
            throw new WCMException("\u89e3\u6790\u6587\u6863\u6240\u5c5e\u5173\u7cfb\u53d1\u751f\u9519\u8bef!", ex);
        }
        return 1;
    }

    private static int analyzeExt(String _src) {
        if (CMyString.isEmpty(_src)) {
            return 1;
        }
        String sPicExt = "jpg,jpeg,gif,png,bmp";
        String sAudioExt = "wav,mid,midi,mp3,mpa,mp2,ra,ram,rm,wma";
        String sVideoExt = "asf,avi,mpg,mpeg,mpe,mov,rm,rmvb,wmv,swf";
        String[] extGroup = new String[]{sPicExt, sAudioExt, sVideoExt};
        int[] nDocForm = new int[]{2, 3, 4};
        for (int i = 0; i < extGroup.length; ++i) {
            for (int j = 0; j < extGroup[i].split(",").length; ++j) {
                if (_src.indexOf("." + extGroup[i].split(",")[j]) < 0) continue;
                return nDocForm[i];
            }
        }
        return 1;
    }

    @Override
    public void run() {
        ContextHelper.initContext(User.getSystem());
        StringBuffer sbSQL = new StringBuffer(MAX_COUNT_WRITE_FILE * 2 * 100 + 200);
        sbSQL.append("alter table WCMDocument nologging;\n");
        sbSQL.append("alter table WCMChnlDoc nologging;\n");
        int nCurrCount = 0;
        int nPreMinDocId = 0;
        while (true) {
            DebugTimer timer;
            int[] pDocId;
            if ((pDocId = DocFormReset.applyDocId()) == null) {
                if (nCurrCount > 0) {
                    try {
                        sbSQL.append("commit;");
                        CMyFile.writeFile(FILE_DIRECTORY + nPreMinDocId + ".sql", sbSQL.toString());
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                    }
                    sbSQL.setLength(0);
                }
                return;
            }
            nPreMinDocId = pDocId[0];
            WCMFilter filter = new WCMFilter("", "DocId>=? and DocId<=?", "", "DocId,DocHTMLCon,DocType,DocFileName");
            filter.addSearchValues(pDocId[0]);
            filter.addSearchValues(pDocId[1]);
            filter.setMaxRowNumber(OFFSET_DOCID);
            filter.setPageSize(OFFSET_DOCID);
            Documents documents = null;
            try {
                timer = new DebugTimer();
                timer.start();
                documents = Documents.openWCMObjs(ContextHelper.getLoginUser(), filter);
                int nSize = documents.size();
                for (int j = 0; j < nSize; ++j) {
                    Document document = (Document)documents.getAt(j);
                    if (document == null) continue;
                    sbSQL.append(this.resetDocForm(document));
                }
                timer.stop();
                if (timer.getTime() > 10L && !documents.isEmpty()) {
                    System.out.println("Thread[" + this + "] [" + pDocId[0] + "-" + pDocId[1] + "]  use[" + timer.getTime() + "]ms");
                }
                documents.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if ((nCurrCount += documents.size()) < MAX_COUNT_WRITE_FILE) continue;
            nCurrCount = 0;
            try {
                timer = new DebugTimer();
                timer.start();
                sbSQL.append("commit;");
                CMyFile.writeFile(FILE_DIRECTORY + pDocId[0] + ".sql", sbSQL.toString());
                timer.stop();
                System.out.println("Thread[" + this + "] write file use[" + timer.getTime() + "]ms");
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
            sbSQL.setLength(0);
            sbSQL.append("alter table WCMDocument nologging;\n");
            sbSQL.append("alter table WCMChnlDoc nologging;\n");
        }
    }

    private String resetDocForm(Document _oDocument) throws WCMException {
        int nDocForm = 1;
        int nDocType = _oDocument.getType();
        nDocForm = nDocType == 40 ? DocFormReset.analyzeExt(_oDocument.getPropertyAsString("DocFileName")) : (nDocType == 20 ? DocFormReset.analyzeDocForm(_oDocument.getHtmlContent()) : 1);
        if (nDocForm == 1) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(200);
        String sSQL = "update wcmdocument set docform=" + nDocForm + " where docid=" + _oDocument.getId();
        sbResult.append(sSQL);
        sbResult.append(";\n");
        this.m_oDBMgr.sqlExecuteUpdate(sSQL);
        sSQL = "update wcmchnldoc set docform=" + nDocForm + " where docid=" + _oDocument.getId();
        sbResult.append(sSQL);
        sbResult.append(";\n");
        this.m_oDBMgr.sqlExecuteUpdate(sSQL);
        return sbResult.toString();
    }

    public static int[] getRecScale(int minDocId, int maxDocId, int nIndex) {
        int nScaleWidth = (maxDocId - minDocId) / THREAD_SIZE + 1;
        return new int[]{minDocId + (nIndex - 1) * nScaleWidth, minDocId + nIndex * nScaleWidth - 1};
    }

    public static void parse() throws WCMException, SQLException {
        m_nMinDocId = 0;
        System.out.println("\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u91c7\u96c6\uff1a");
        m_nMinDocId = MIN_DOCID <= 0 ? DBManager.getDBManager().sqlExecuteIntQuery("select min(docid) from wcmdocument") : MIN_DOCID;
        m_nMaxDocId = 0;
        m_nMaxDocId = MAX_DOCID <= 0 ? DBManager.getDBManager().sqlExecuteIntQuery("select max(docid) from wcmdocument") : MAX_DOCID;
        m_nNextMaxDocId = m_nMaxDocId;
        System.out.println("MinDocId--" + m_nMinDocId);
        System.out.println("MaxDocId--" + m_nMaxDocId);
        for (int i = 0; i < THREAD_SIZE; ++i) {
            DocFormReset thread = new DocFormReset();
            thread.start();
        }
    }

    public static synchronized int[] applyDocId() {
        if (m_nNextMaxDocId < m_nMinDocId) {
            return null;
        }
        int nCurrMinDocId = m_nNextMaxDocId - OFFSET_DOCID + 1;
        int[] pResult = new int[]{nCurrMinDocId, m_nNextMaxDocId};
        m_nNextMaxDocId = nCurrMinDocId - 1;
        return pResult;
    }

    public static void main(String[] args) throws WCMException, SQLException {
        DocFormReset.parse();
    }
}

