/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import com.trs.template.TemplateRemoteException;
import com.trs.template.domain.TemplateXmlGenerator;
import com.trs.template.domain.XTemplateExporter;
import com.trs.template.domain.setting.ITemplateSetting;
import com.trs.template.domain.setting.TemplateSettingFactory;
import com.trs.template.service.ITemplateService;
import com.trs.template.service.impl.Exporter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.axis.encoding.Base64;
import org.apache.log4j.Logger;

public class TemplateServiceImpl
implements ITemplateService {
    private static Logger s_logger = Logger.getLogger(TemplateServiceImpl.class);
    private static Hashtable m_htSession = new Hashtable();
    private static Map s_hmUserLockedTemplates = null;
    private User m_currLoginUser;

    @Override
    public String login(String strUserName, String strPassword, String strEncryptType, String strRemoteIP) throws TemplateRemoteException {
        s_logger.info((Object)("start login, username:" + strUserName + ", remoteip:" + strRemoteIP));
        User loginUser = User.findByName(strUserName);
        if (loginUser == null) {
            throw new TemplateRemoteException(1, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label1", "\u6ca1\u6709\u627e\u5230\u7528\u6237\u540d\u4e3a[") + strUserName + I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label2", "]\u7684\u7528\u6237\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label3", "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
        }
        if (loginUser.isDeleted() || loginUser.isForbidden()) {
            throw new TemplateRemoteException(2, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label4", "\u7528\u6237[") + strUserName + I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label5", "]\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u7981\u7528\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label3", "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
        }
        if (!CMyString.isEmpty(strEncryptType)) {
            if (strEncryptType.compareToIgnoreCase("Base64") != 0) {
                throw new TemplateRemoteException(8, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label6", "\u4e0d\u652f\u6301\u7684\u53e3\u4ee4\u7f16\u7801\u65b9\u5f0f[") + strEncryptType + "]!", I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label7", "\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u53e3\u4ee4\u7f16\u7801\u65b9\u5f0f\uff01"));
            }
            strPassword = new String(Base64.decode((String)strPassword));
        }
        if (!loginUser.passwordIs(strPassword)) {
            throw new TemplateRemoteException(3, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label4", "\u7528\u6237[") + strUserName + I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label8", "]\u5bc6\u7801\u4e0d\u6b63\u786e\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label3", "\u8bf7\u91cd\u65b0\u767b\u5f55\uff01"));
        }
        String sSessionId = Base64.encode((byte[])(strUserName + CMyDateTime.now().toString()).getBytes());
        m_htSession.put(sSessionId, loginUser);
        ContextHelper.setLoginUser(loginUser);
        s_logger.info((Object)("end login, username:" + strUserName + ", remoteip:" + strRemoteIP + ", sessionid:" + sSessionId));
        return sSessionId;
    }

    @Override
    public boolean logout(String strSessionID) throws TemplateRemoteException {
        if (strSessionID == null) {
            throw new TemplateRemoteException(0, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label9", "\u4f20\u5165SessionId\u4e3a\u7a7a\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label10", "\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        if (!m_htSession.containsKey(strSessionID)) {
            throw new TemplateRemoteException(4, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label11", "\u7528\u6237\u5c1a\u672a\u767b\u5f55\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label10", "\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        m_htSession.remove(strSessionID);
        this.logoutUserLockedTemplates(strSessionID);
        return true;
    }

    @Override
    public boolean checkin(String strSessionID, String strAppName, String strPrimaryKey, byte[] strTemplateZipContent) throws TemplateRemoteException {
        this.validateUser(strSessionID, "checkin");
        String sFileName = "";
        IPublishFolder folder = null;
        Template oCurrTemplate = null;
        try {
            TemplateImporter importer;
            Reports reports;
            sFileName = TemplateServiceImpl.writeFile(strTemplateZipContent, "zip");
            int nSiteId = Integer.parseInt(strAppName.startsWith("S") ? strAppName.substring(1) : strAppName);
            folder = this.makeTemplateFolder(strPrimaryKey, WebSite.findById(nSiteId));
            if (folder == null) {
                throw new WCMException("Cannot find the template folder with BaseChannelID[" + strAppName + "]");
            }
            if (!CMyString.isEmpty(strPrimaryKey) && !(strPrimaryKey = strPrimaryKey.trim()).equals("0")) {
                oCurrTemplate = this.getEditableTemplate(strPrimaryKey);
            }
            if (!(reports = (importer = new TemplateImporter()).importFromZip(folder, CMyFile.extractFileName(sFileName), 1, 1, null)).getFailedReporter().isEmpty()) {
                s_logger.warn((Object)reports.getFailedReporter().toString());
                return false;
            }
            this.checkinUserLockedTemplates(strSessionID, oCurrTemplate);
        }
        catch (Throwable e) {
            throw new TemplateRemoteException(6, e.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(strTemplateZipContent, "checkin_" + (oCurrTemplate == null ? "" : oCurrTemplate.getName()));
        }
        return true;
    }

    @Override
    public byte[] checkout(String strSessionID, String strAppName, String strPrimaryKey) throws TemplateRemoteException {
        this.validateUser(strSessionID, "checkout");
        User loginUser = (User)m_htSession.get(strSessionID);
        Template currTemplate = null;
        try {
            currTemplate = this.getEditableTemplate(Integer.parseInt(strPrimaryKey));
            Exporter exporter = new Exporter(loginUser);
            byte[] result = exporter.export(currTemplate);
            if (s_logger.isDebugEnabled()) {
                this.debugByteWrite(result, "checkout");
            }
            this.checkoutUserLockedTemplates(strSessionID, currTemplate);
            return result;
        }
        catch (Throwable e) {
            throw new TemplateRemoteException(5, e.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
    }

    protected byte[] checkoutOld(String strSessionID, String strAppName, String strPrimaryKey) throws TemplateRemoteException {
        this.validateUser(strSessionID, "checkout");
        User loginUser = (User)m_htSession.get(strSessionID);
        Template currTemplate = null;
        byte[] result = null;
        try {
            currTemplate = this.getEditableTemplate(Integer.parseInt(strPrimaryKey));
            XTemplateExporter exporter = new XTemplateExporter();
            Templates templates = new Templates(loginUser);
            templates.addElement(currTemplate);
            String tempFileName = exporter.export(templates);
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sFilePath = aFilesMan.mapFilePath(tempFileName, 0) + tempFileName;
            result = CMyFile.readBytesFromFile(sFilePath);
        }
        catch (Throwable e) {
            throw new TemplateRemoteException(5, e.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(result, "checkout");
        }
        this.checkoutUserLockedTemplates(strSessionID, currTemplate);
        return result;
    }

    @Override
    public String preview(String strSessionID, String strAppName, String strPrimaryKey, byte[] bytesTemplateZipContent, String strQuery) {
        return null;
    }

    @Override
    public byte[] getAllSettings(String strSessionID) throws TemplateRemoteException {
        this.validateUser(strSessionID, "getAllSettings");
        byte[] result = null;
        try {
            ITemplateSetting[] templateSettings = TemplateSettingFactory.getInstance().makeAllSettings();
            ArrayList arAllFiels2Zip = new ArrayList();
            for (int i = 0; i < templateSettings.length; ++i) {
                arAllFiels2Zip.addAll(templateSettings[i].getContentFiles());
            }
            result = TemplateXmlGenerator.zipFiles(arAllFiels2Zip);
        }
        catch (Throwable e) {
            throw new TemplateRemoteException(20, CMyException.getStackTraceText(e), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(result, "getAllSettings");
        }
        return result;
    }

    @Override
    public byte[] getSettingByType(String strSessionID, String strSettingType) throws TemplateRemoteException {
        this.validateUser(strSessionID, "getSettingByType");
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)("getSettingByType...[" + strSettingType + "]"));
        }
        ITemplateSetting templateSetting = null;
        byte[] result = null;
        try {
            templateSetting = TemplateSettingFactory.getInstance().makeSettingByType(strSettingType);
            result = templateSetting.getContent();
        }
        catch (Throwable e) {
            if (s_logger.isDebugEnabled()) {
                s_logger.info((Object)"get settings failed!", e);
            }
            throw new TemplateRemoteException(20, e.getMessage(), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label12", "\u8bf7\u91cd\u8bd5\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            this.debugByteWrite(result, "getSettingByType");
        }
        return result;
    }

    @Override
    public boolean confirm(String strSessionID, String strAppName, String strPrimaryKey) {
        return false;
    }

    @Override
    public String[] getSettingTypeList(String strSessionID) {
        String[] result = TemplateSettingFactory.getInstance().getSettingTypes();
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)"the types list is :");
            for (int i = 0; i < result.length; ++i) {
                System.out.println(result[i]);
            }
        }
        return result;
    }

    @Override
    public String[] getAllSites(String strSessionID) {
        return null;
    }

    protected void validateUser(String strSessionID, String _sCallerName) throws TemplateRemoteException {
        String sLogInfo = "Validating User with[SID=" + strSessionID + "]";
        sLogInfo = sLogInfo + (CMyString.isEmpty(_sCallerName) ? "" : " When '" + _sCallerName + "'");
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)sLogInfo);
        }
        if (!m_htSession.containsKey(strSessionID)) {
            throw new TemplateRemoteException(4, I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label11", "\u7528\u6237\u5c1a\u672a\u767b\u5f55\uff01"), I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label13", "\u8bf7\u5148\u767b\u5f55\u5230\u670d\u52a1\u5668\uff01"));
        }
        this.m_currLoginUser = (User)m_htSession.get(strSessionID);
        ContextHelper.setLoginUser(this.m_currLoginUser);
    }

    protected void validateUser(String strSessionID) throws TemplateRemoteException {
        this.validateUser(strSessionID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeFile(byte[] _pFileContent, String _sFileExt) throws Throwable {
        OutputStream fos = null;
        try {
            String sFileName = FilesMan.getFilesMan().getNextFilePathName("ST", _sFileExt);
            fos = new FileService(sFileName).getOutputStream();
            fos.write(_pFileContent);
            String string = sFileName;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label14", "\u65e0\u6cd5\u5173\u95ed\u78c1\u76d8I/O!"), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSpecFile(byte[] _pFileContent, String _sFilePath) throws Throwable {
        OutputStream fos = null;
        try {
            fos = new FileService(_sFilePath).getOutputStream();
            fos.write(_pFileContent);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(I18NMessage.get(TemplateServiceImpl.class, "TemplateServiceImpl.label14", "\u65e0\u6cd5\u5173\u95ed\u78c1\u76d8I/O!"), ex);
            }
        }
    }

    public IPublishFolder makeTemplateFolder(String _sFormattedTempName, WebSite _oRootSite) throws WCMException {
        if (CMyString.isEmpty(_sFormattedTempName)) {
            throw new WCMException("The Formatted Template Name is dimmy!");
        }
        String sChannelName = "";
        boolean bIsDirectlyBelong2Site = false;
        try {
            if (_sFormattedTempName.indexOf("/") == -1) {
                bIsDirectlyBelong2Site = true;
            } else {
                String[] arAparts = _sFormattedTempName.split("/");
                sChannelName = arAparts[arAparts.length - 2];
            }
        }
        catch (Exception ex) {
            throw new WCMException("The subfix of template name with[" + _sFormattedTempName + "] is invalid, for it's neither site or channel id without 'S' or 'C' flag!", ex);
        }
        try {
            IPublishFolder oRootFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(_oRootSite);
            if (bIsDirectlyBelong2Site) {
                return oRootFolder;
            }
            Channel oChannel = Channel.findByName(_oRootSite.getId(), sChannelName);
            if (oChannel == null) {
                return oRootFolder;
            }
            return (IPublishFolder)PublishElementFactory.makeElementFrom(oChannel);
        }
        catch (Exception ex) {
            throw new WCMException("Failed to Parse the Formatted template name[" + _sFormattedTempName + "] for making template folder!", ex);
        }
    }

    private Template getEditableTemplate(int _nTemplateId) throws WCMException {
        Template result = null;
        result = Template.findById(_nTemplateId);
        if (result == null) {
            throw new WCMException("Failed to find the template with [ID=" + _nTemplateId + "]");
        }
        if (!result.canEdit(this.m_currLoginUser)) {
            throw new WCMException("The template[" + _nTemplateId + "] you're going to update is looked by User[" + result.getLockerUserName() + "]");
        }
        return result;
    }

    private Template getEditableTemplate(String _sTemplateName) throws WCMException {
        String[] arAparts = _sTemplateName.split("/");
        int nDotIndex = (_sTemplateName = arAparts[arAparts.length - 1]).indexOf(46);
        _sTemplateName = nDotIndex == -1 ? _sTemplateName : _sTemplateName.substring(0, nDotIndex);
        Template result = null;
        Templates templates = Templates.openWCMObjs(this.m_currLoginUser, new WCMFilter(null, "", null));
        if (templates.size() == 0 || templates.getAt(0) == null) {
            throw new WCMException("Failed to find the template with [Name=" + _sTemplateName + "]");
        }
        result = (Template)templates.getAt(0);
        if (!result.canEdit(this.m_currLoginUser)) {
            throw new WCMException("The template[" + _sTemplateName + "] you're going to update is looked by User[" + result.getLockerUserName() + "]");
        }
        return result;
    }

    private void debugByteWrite(byte[] _biContent, String _sInfoName) {
        s_logger.info((Object)("begin to write file for '" + _sInfoName + "'"));
        String sFilePath = "c:\\TE_" + _sInfoName + "_" + CMyDateTime.now().toString("yyyy-MM-dd") + ".zip";
        try {
            TemplateServiceImpl.writeSpecFile(_biContent, sFilePath);
        }
        catch (Throwable e) {
            s_logger.info((Object)("ERROR!!!: failed to write file to [" + sFilePath + "] : " + e.getLocalizedMessage()));
        }
        s_logger.info((Object)("end to write file to [" + sFilePath + "]"));
        s_logger.info((Object)"--------------------------------------------");
    }

    private void checkoutUserLockedTemplates(String _sUserSessionId, Template _oTemplate) {
        if (!this.getUserLockedTemplates().containsKey(_sUserSessionId)) {
            ArrayList<Template> arLockedTemplates = new ArrayList<Template>(1);
            arLockedTemplates.add(_oTemplate);
            this.getUserLockedTemplates().put(_sUserSessionId, arLockedTemplates);
        } else {
            ArrayList arLockedTemplates = (ArrayList)this.getUserLockedTemplates().get(_sUserSessionId);
            if (arLockedTemplates != null) {
                arLockedTemplates.add(_oTemplate);
            }
        }
    }

    private void checkinUserLockedTemplates(String _sUserSessionId, Template _oTemplate) {
        ArrayList arLockedTemplates;
        _oTemplate.unlock();
        if (this.getUserLockedTemplates().containsKey(_sUserSessionId) && (arLockedTemplates = (ArrayList)this.getUserLockedTemplates().get(_sUserSessionId)) != null && arLockedTemplates.size() != 0) {
            for (int i = 0; i < arLockedTemplates.size(); ++i) {
                Template template = (Template)arLockedTemplates.get(i);
                if (_oTemplate.getId() != template.getId()) continue;
                arLockedTemplates.remove(template);
                break;
            }
        }
    }

    private void logoutUserLockedTemplates(String _sUserSessionId) {
        ArrayList arLockedTemplates;
        if (this.getUserLockedTemplates().containsKey(_sUserSessionId) && (arLockedTemplates = (ArrayList)this.getUserLockedTemplates().get(_sUserSessionId)) != null && arLockedTemplates.size() != 0) {
            for (int i = 0; i < arLockedTemplates.size(); ++i) {
                Template template = (Template)arLockedTemplates.get(i);
                template.unlock();
            }
            arLockedTemplates.clear();
        }
    }

    private Map getUserLockedTemplates() {
        if (s_hmUserLockedTemplates == null) {
            s_hmUserLockedTemplates = new HashMap(5);
        }
        return s_hmUserLockedTemplates;
    }
}

