/*
 * Decompiled with CFR 0.152.
 */
package com.trs.template.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.xml.IXmlPersistentObject;
import com.trs.infra.util.xml.XmlObjectPersistentor;
import com.trs.template.domain.InfoEntityFinder;
import com.trs.template.domain.SourcePathHelper;
import com.trs.template.persistent.InfoEntities;
import com.trs.template.persistent.WebSiteInfoEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateXmlGenerator {
    private static final String XML_ENCODING = "GBK";
    private static Logger s_logger = Logger.getLogger(TemplateXmlGenerator.class);
    private ArrayList m_arAllRelChannelsXmlFiles = null;
    private ArrayList m_arAllRelFieldsXmlFiles = null;
    private ArrayList m_arAllRelTemplatesXmlFiles = null;
    private InfoEntityFinder m_oInfoEntityFinder = new InfoEntityFinder();
    private InfoEntities m_oSiteInfoEntities = null;
    private InfoEntities m_oTagFieldInfoEntities = null;
    private InfoEntities m_oTemplateInfoEntities = null;

    protected synchronized void renderChannels() {
        this.m_arAllRelChannelsXmlFiles = new ArrayList();
        this.makeAllSiteInfo();
        this.makeAllBaseChannelInfo();
    }

    private synchronized void renderFields() {
        this.m_arAllRelFieldsXmlFiles = new ArrayList(1);
        this.makeAllFieldsInfo();
    }

    private synchronized void renderTemplates() {
        this.m_arAllRelTemplatesXmlFiles = new ArrayList(1);
        this.makeAllTemplatesInfo();
    }

    protected void makeAllSiteInfo() {
        try {
            this.m_oSiteInfoEntities = this.m_oInfoEntityFinder.getSiteEntities();
            String sSiteInfoFilePath = SourcePathHelper.getSiteInfoFilePath();
            this.persistentEntities(this.m_oSiteInfoEntities, sSiteInfoFilePath);
            this.m_arAllRelChannelsXmlFiles.add(sSiteInfoFilePath);
        }
        catch (Exception ex) {
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label1", "\u5e8f\u5217\u5316\u7ad9\u70b9\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + ex.getLocalizedMessage() + "}", ex);
        }
    }

    protected void makeAllBaseChannelInfo() {
        if (this.m_oSiteInfoEntities == null || this.m_oSiteInfoEntities.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_oSiteInfoEntities.size(); ++i) {
            WebSiteInfoEntity entity = (WebSiteInfoEntity)this.m_oSiteInfoEntities.getAt(i);
            this.makeBaseChannelInfo(entity.getSiteId());
        }
    }

    protected void makeAllFieldsInfo() {
        try {
            this.m_oTagFieldInfoEntities = this.m_oInfoEntityFinder.getFieldEntities();
            String sFieldInfoFilePath = SourcePathHelper.getFieldInfoFilePath();
            this.persistentEntities(this.m_oTagFieldInfoEntities, sFieldInfoFilePath);
            this.m_arAllRelFieldsXmlFiles.add(sFieldInfoFilePath);
        }
        catch (Exception ex) {
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label2", "\u5e8f\u5217\u5316\u5b57\u6bb5\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + ex.getLocalizedMessage() + "}", ex);
        }
    }

    private void makeAllTemplatesInfo() {
        String sTemplateInfoFilePath = null;
        try {
            this.m_oTemplateInfoEntities = this.m_oInfoEntityFinder.getTemplateEntities();
            sTemplateInfoFilePath = SourcePathHelper.getTemplateInfoFilePath();
            this.persistentEntities(this.m_oTemplateInfoEntities, sTemplateInfoFilePath);
            this.m_arAllRelTemplatesXmlFiles.add(sTemplateInfoFilePath);
        }
        catch (Exception ex) {
            s_logger.error((Object)("failed to serialize mapping file!" + sTemplateInfoFilePath), (Throwable)ex);
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label3", "\u5e8f\u5217\u5316\u6a21\u677f\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + ex.getLocalizedMessage() + "}", ex);
        }
    }

    private void makeBaseChannelInfo(int _nSiteId) {
        try {
            InfoEntities entities = this.m_oInfoEntityFinder.getBaseChannelEntities(_nSiteId);
            String sCurrBaseChannelInfoFilePath = SourcePathHelper.getBaseChannelInfoFilePath(_nSiteId);
            this.persistentEntities(entities, sCurrBaseChannelInfoFilePath);
            this.m_arAllRelChannelsXmlFiles.add(sCurrBaseChannelInfoFilePath);
        }
        catch (Exception ex) {
            throw new RuntimeException(I18NMessage.get(TemplateXmlGenerator.class, "TemplateXmlGenerator.label4", "\u5e8f\u5217\u5316\u9891\u9053\u63cf\u8ff0\u4fe1\u606f\u7684xml\u5931\u8d25![") + ex.getLocalizedMessage() + "}", ex);
        }
    }

    private void persistentEntities(IXmlPersistentObject entities, String sCurrBaseChannelInfoFilePath) throws CMyException {
        XmlObjectPersistentor objPersistentor = new XmlObjectPersistentor();
        objPersistentor.setMappingSrc(SourcePathHelper.getMappingFilePath());
        CMyFile.writeFile(sCurrBaseChannelInfoFilePath, "", XML_ENCODING);
        objPersistentor.updateInstance(entities, sCurrBaseChannelInfoFilePath, XML_ENCODING);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Has generated file[" + sCurrBaseChannelInfoFilePath + "] successfully"));
        }
    }

    public ArrayList getAllRelChannelsXmlFiles() {
        if (this.m_arAllRelChannelsXmlFiles == null) {
            this.renderChannels();
        }
        return this.m_arAllRelChannelsXmlFiles;
    }

    public ArrayList getAllRelFieldsXmlFiles() {
        if (this.m_arAllRelFieldsXmlFiles == null) {
            this.renderFields();
        }
        return this.m_arAllRelFieldsXmlFiles;
    }

    public ArrayList getAllRelTemplatesXmlFiles() {
        if (this.m_arAllRelTemplatesXmlFiles == null) {
            this.renderTemplates();
        }
        return this.m_arAllRelTemplatesXmlFiles;
    }

    public static byte[] zipFiles(List arFiles) throws CMyException {
        if (arFiles == null || arFiles.size() == 0) {
            return null;
        }
        CMyZip zip = new CMyZip();
        FilesMan oFilesMan = FilesMan.getFilesMan();
        String sZipFilePath = oFilesMan.getNextFilePathName("ST", "zip");
        zip.setZipFileName(sZipFilePath);
        String sFormatedSettingFilesDir = SourcePathHelper.getFormatedSettingFilesDir(sZipFilePath);
        for (int i = 0; i < arFiles.size(); ++i) {
            String sFile2Zip = (String)arFiles.get(i);
            CMyFile.moveFile(sFile2Zip, sFormatedSettingFilesDir + CMyFile.extractFileName(sFile2Zip));
        }
        zip.addToZip(sFormatedSettingFilesDir);
        zip.done();
        CMyFile.deleteDir(sFormatedSettingFilesDir);
        return CMyFile.readBytesFromFile(sZipFilePath);
    }
}

