/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.tagparser.TemplateParameterList;
import com.trs.components.common.publish.domain.template.TemplateArgumentMgr;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateExporter;
import com.trs.components.common.publish.domain.template.TemplateImporter;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.Reports;
import com.trs.service.ITemplateService;
import java.util.Iterator;
import java.util.List;

public class TemplateService
implements ITemplateService {
    private TemplateMgr m_oTemplateMgr = null;
    private TemplateEmployMgr m_oEmployMgr = null;
    private TemplateArgumentMgr m_oArgumentMgr = (TemplateArgumentMgr)DreamFactory.createObjectById("TemplateArgumentMgr");

    public TemplateService() {
        this.m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        this.m_oEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public Template save(Template _currTemplateToSave, boolean _bDowithAppendix, int _nPicMode) throws WCMException {
        if (_currTemplateToSave == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label1", "\u5f53\u524d\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        long logStartId = 0L;
        Template template = _currTemplateToSave;
        try {
            int nRightIndex;
            Template currTemplate = this.transformVO2PO(_currTemplateToSave);
            int n = nRightIndex = currTemplate.isAddMode() ? 21 : 23;
            if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)currTemplate, nRightIndex)) {
                throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label2", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u4fdd\u5b58\u5f53\u524d\u6a21\u677f!"));
            }
            TemplateMgr currTemplateMgr = this.getTemplateMgr();
            String optype = currTemplate.isAddMode() ? "TEMPLATE_ADD" : "TEMPLATE_EDIT";
            String logdesc = I18NMessage.get(TemplateService.class, "TemplateService.label3", "\u4fdd\u5b58[") + currTemplate + "]";
            logStartId = LogServer.startRecord(this.getLoginUser().getName(), optype, logdesc, currTemplate);
            template = currTemplateMgr.save(currTemplate, "", _bDowithAppendix, _nPicMode);
            LogServer.endRecordSucceedOperation(logStartId);
        }
        catch (WCMException ex) {
            LogServer.endRecordFailedOperation(logStartId, ex);
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label4", "\u4fdd\u5b58\u5f53\u524d\u6a21\u677f\u53d1\u751f\u5f02\u5e38!"), ex);
        }
        catch (Exception ex2) {
            LogServer.endRecordFailedOperation(logStartId, ex2);
            throw new WCMException(0, I18NMessage.get(TemplateService.class, "TemplateService.label4", "\u4fdd\u5b58\u5f53\u524d\u6a21\u677f\u53d1\u751f\u5f02\u5e38!"), ex2);
        }
        return template;
    }

    @Override
    public Template save(Template _currTemplateToSave) throws WCMException {
        return this.save(_currTemplateToSave, true, 2);
    }

    @Override
    public boolean delete(String _sDelTemplateIds) throws WCMException {
        if (_sDelTemplateIds == null || _sDelTemplateIds.length() == 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label5", "\u65e0\u6548\u7684TemplateId\u5e8f\u5217,\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c!"));
        }
        Templates aTemplates = Templates.findByIds(this.getLoginUser(), _sDelTemplateIds);
        return this.delete(aTemplates);
    }

    @Override
    public boolean delete(Templates _currTemplatesToDelete) throws WCMException {
        if (_currTemplatesToDelete == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label6", "\u65e0\u6548\u7684\u5f53\u524d\u6a21\u677f\u96c6\u5408,\u65e0\u6cd5\u5220\u9664!"));
        }
        for (int i = 0; i < _currTemplatesToDelete.size(); ++i) {
            Template currTemplate = (Template)_currTemplatesToDelete.getAt(i);
            if (this.delete(currTemplate)) continue;
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label7", "\u5220\u9664Template[") + currTemplate.getName() + I18NMessage.get(TemplateService.class, "TemplateService.label8", "]\u5931\u8d25,\u4e2d\u6b62\u64cd\u4f5c"));
        }
        return true;
    }

    @Override
    public boolean delete(int _nDelTemplateId) throws WCMException {
        if (_nDelTemplateId <= 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label9", "\u65e0\u6548\u7684TemplateId[") + _nDelTemplateId + I18NMessage.get(TemplateService.class, "TemplateService.label10", "],Id\u5e94\u8be5\u5927\u4e8e0"));
        }
        Template template = Template.findById(_nDelTemplateId);
        if (template == null) {
            return true;
        }
        return this.delete(template);
    }

    @Override
    public boolean delete(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label11", "\u65e0\u6548\u7684\u5f53\u524d\u6a21\u677f,\u65e0\u6cd5\u5220\u9664!"));
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_template, 22)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label12", "\u5bf9\u4e0d\u8d77,\u60a8\u6ca1\u6709\u5220\u9664\u6a21\u677f\u7684\u6743\u9650!"));
        }
        String logdesc = I18NMessage.get(TemplateService.class, "TemplateService.label13", "\u5220\u9664[") + _template + "]";
        long startid = 0L;
        boolean bSuccessed = false;
        try {
            TemplateMgr currTemplateMgr = this.getTemplateMgr();
            startid = LogServer.startRecord(this.getLoginUser().getName(), "TEMPLATE_DEL", logdesc, _template);
            bSuccessed = currTemplateMgr.delete(_template);
            LogServer.endRecordSucceedOperation(startid);
        }
        catch (WCMException ex) {
            LogServer.endRecordFailedOperation(startid, ex);
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label14", "\u5220\u9664\u5f53\u524d\u6a21\u677f\u51fa\u9519!"), ex);
        }
        catch (Exception ex2) {
            LogServer.endRecordFailedOperation(startid, ex2);
            throw new WCMException(0, I18NMessage.get(TemplateService.class, "TemplateService.label14", "\u5220\u9664\u5f53\u524d\u6a21\u677f\u51fa\u9519!"), ex2);
        }
        return bSuccessed;
    }

    private Template transformVO2PO(Template _voTemplate) {
        return _voTemplate;
    }

    @Override
    public String export(String _sTemplateIds) throws WCMException {
        if (_sTemplateIds == null || _sTemplateIds.length() == 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label15", "\u65e0\u6548\u7684\u6a21\u677fId\u5e8f\u5217!"));
        }
        Templates currTemplates = Templates.findByIds(this.getLoginUser(), _sTemplateIds);
        if (currTemplates.isEmpty()) {
            throw new WCMException(200006, I18NMessage.get(TemplateService.class, "TemplateService.label16", "\u6ca1\u6709\u627e\u5230\u6a21\u677f!"));
        }
        return this.export(currTemplates);
    }

    @Override
    public String export(Templates _currTemplates) throws WCMException {
        if (_currTemplates == null || _currTemplates.isEmpty()) {
            throw new WCMException(10, "Templates collection could not be empty!");
        }
        Template aTemplate = (Template)_currTemplates.getAt(0);
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)aTemplate, 24)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label17", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5bfc\u51fa\u6307\u5b9a\u7684\u6a21\u677f!"));
        }
        TemplateExporter exporter = new TemplateExporter();
        return exporter.export(_currTemplates);
    }

    @Override
    public String export(int _nTemplateId) throws WCMException {
        if (_nTemplateId <= 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label18", "\u65e0\u6548\u7684\u6a21\u677fId[") + _nTemplateId + I18NMessage.get(TemplateService.class, "TemplateService.label19", "],\u4e0d\u80fd\u5b8c\u6210\u5bfc\u51fa!"));
        }
        return this.export(new Integer(_nTemplateId).toString());
    }

    @Override
    public String export(Template _currTemplate) throws WCMException {
        if (_currTemplate == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label20", "\u65e0\u6548\u7684\u6a21\u677f,\u65e0\u6cd5\u5bfc\u51fa!"));
        }
        Templates currTemplates = Templates.createNewInstance(this.getLoginUser());
        currTemplates.addElement(_currTemplate);
        return this.export(currTemplates);
    }

    @Override
    public String preview(int _nTemplateId) throws WCMException {
        if (_nTemplateId <= 0) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label21", "\u65e0\u6548\u7684\u9891\u9053id[") + _nTemplateId + "]!");
        }
        Template currTemplate = Template.findById(_nTemplateId);
        if (currTemplate == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateService.class, "TemplateService.label22", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f!"));
        }
        return this.preview(currTemplate);
    }

    @Override
    public String preview(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        this.validateRight(_template, 24, I18NMessage.get(TemplateService.class, "TemplateService.label23", "\u9884\u89c8\u6a21\u677f"));
        return this.m_oTemplateMgr.preview(_template);
    }

    @Override
    public Reports importFromZip(CMSObj _siteOrChannel, String _sFileName, int _nImportMode, int _nPicMode, String[] _arSelected) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), _siteOrChannel, 21)) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label24", "\u60a8\u6682\u65f6\u65e0\u6743\u5bfc\u5165\u6a21\u677f\uff01"));
        }
        long logStartId = 0L;
        try {
            TemplateImporter importer = new TemplateImporter();
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_siteOrChannel);
            String logdesc = this.getLoginUser() + I18NMessage.get(TemplateService.class, "TemplateService.label25", "\u6279\u91cf\u5bfc\u5165\u6a21\u677f\u5230[") + _siteOrChannel + "]";
            logStartId = LogServer.startRecord(this.getLoginUser().getName(), "TEMPLATE_IMPORT", logdesc, _siteOrChannel);
            Reports reports = importer.importFromZip(folder, _sFileName, _nImportMode, _nPicMode, _arSelected);
            LogServer.endRecordSucceedOperation(logStartId);
            return reports;
        }
        catch (Exception ex) {
            LogServer.endRecordFailedOperation(logStartId, ex);
            throw new WCMException(1100, "Failed to import templates from zip file " + _sFileName, ex);
        }
    }

    @Override
    public Reports importFromHTML(CMSObj _siteOrChannel, String _sFileName, int _nImportMode, String _sSrcName) throws WCMException {
        if (!AuthServer.hasRight(this.getLoginUser(), _siteOrChannel, 21)) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label24", "\u60a8\u6682\u65f6\u65e0\u6743\u5bfc\u5165\u6a21\u677f\uff01"));
        }
        long logStartId = 0L;
        try {
            TemplateImporter importer = new TemplateImporter();
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_siteOrChannel);
            String logdesc = this.getLoginUser() + I18NMessage.get(TemplateService.class, "TemplateService.label26", "\u5bfc\u5165\u5355\u4e2aHTML\u6a21\u677f\u5230[") + _siteOrChannel + "]";
            logStartId = LogServer.startRecord(this.getLoginUser().getName(), "TEMPLATE_IMPORT", logdesc, _siteOrChannel);
            Reports reports = importer.importFromHTML(folder, _sFileName, _nImportMode, _sSrcName);
            LogServer.endRecordSucceedOperation(logStartId);
            return reports;
        }
        catch (Exception ex) {
            LogServer.endRecordFailedOperation(logStartId, ex);
            throw new WCMException(1100, "Failed to import template from HTML file " + _sFileName, ex);
        }
    }

    @Override
    public String[] extractTemplateNamesFromZip(String _sZipFileName) throws WCMException {
        if (_sZipFileName == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label27", "\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u6a21\u677f\u540d\u79f0\uff01"));
        }
        TemplateImporter importer = new TemplateImporter();
        return importer.extractTemplateNamesFromZip(_sZipFileName);
    }

    @Override
    public Reports redistributeAppendixes(CMSObj _chnlOrSite, boolean _zRecursive) throws WCMException {
        if (_chnlOrSite == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label28", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548\uff01"));
        }
        try {
            IPublishFolder folder = null;
            folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_chnlOrSite);
            return this.m_oTemplateMgr.redistributeAppendixes(folder, _zRecursive);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the managed templates in the channel/site!", ex);
        }
    }

    @Override
    public Template getDetailTemplate(IPublishElement _publishElement) throws WCMException {
        if (_publishElement == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label29", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        try {
            return this.m_oEmployMgr.getDetailTemplate(_publishElement);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to get the detail template of the specified channel.", ex);
        }
    }

    @Override
    public Templates getOutlineTemplates(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label30", "\u9891\u9053/\u7ad9\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u6982\u89c8\u6a21\u677f\uff01"));
        }
        try {
            return this.m_oEmployMgr.getOutlineTemplates(_folder);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to get the outline template of the specified folder.", ex);
        }
    }

    private TemplateMgr getTemplateMgr() {
        TemplateMgr currTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
        return currTemplateMgr;
    }

    @Override
    public void setDetailTemplate(IPublishFolder _folder, int _nTemplateId, boolean _bResetChildren) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label31", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u5b9a\u6982\u89c8\u6a21\u677f\uff01"));
        }
        try {
            this.m_oEmployMgr.setDetailTemplate(_folder, _nTemplateId, _bResetChildren);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to set the detail template of the channel", ex);
        }
    }

    @Override
    public void setOutlineTemplates(IPublishFolder _folder, String _sTemplateIds, boolean _bResetChildren) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label30", "\u9891\u9053/\u7ad9\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u6982\u89c8\u6a21\u677f\uff01"));
        }
        try {
            this.m_oEmployMgr.setOutlineTemplates(_folder, _sTemplateIds, _bResetChildren);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to set the outline template of the channel/site", ex);
        }
    }

    @Override
    public void setDetailTemplate(IPublishContent _content, int _nTemplateId, int _nDetailTemplateType) throws WCMException {
        if (_content == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label32", "\u4f20\u5165\u65e0\u6548\u7684\u53c2\u6570\uff0c\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e3a\u5176\u8bbe\u5b9a\u6a21\u677f\uff01"));
        }
        try {
            this.m_oEmployMgr.setDetailTemplate(_content, _nTemplateId, false, _nDetailTemplateType);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to set the detail template of the document.", ex);
        }
    }

    @Override
    public void setDetailTemplate(IPublishContent _content, int _nTemplateId) throws WCMException {
        this.setDetailTemplate(_content, _nTemplateId, 2);
    }

    @Override
    public Templates getManagedTemplates(CMSObj _channelOrSite, int _nTemplateType, WCMFilter _filter, boolean _bIncludingThoseInChildren) throws WCMException {
        if (_channelOrSite == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label28", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548\uff01"));
        }
        try {
            IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channelOrSite);
            return this.m_oTemplateMgr.getManagedTemplates(folder, _nTemplateType, _filter, _bIncludingThoseInChildren);
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to fetch the managed templates in the channel/site!", ex);
        }
    }

    @Override
    public Templates getOptionalTemplates(IPublishFolder _folder, int _nTemplateType, WCMFilter _filter, boolean _bIncludingThoseInParent) throws WCMException {
        if (_folder == null) {
            throw new WCMDatainvalidException(I18NMessage.get(TemplateService.class, "TemplateService.label33", "\u6ca1\u6709\u6307\u5b9aFolder!"));
        }
        try {
            return this.m_oTemplateMgr.getOptionalTemplates(_folder, _nTemplateType, _filter, _bIncludingThoseInParent);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label34", "\u83b7\u53d6\u6307\u5b9a") + _folder.getInfo() + I18NMessage.get(TemplateService.class, "TemplateService.label35", "\u4e0b\u53ef\u9009\u7684\u6a21\u677f\u96c6\u5408\u5931\u8d25\uff01!"), ex);
        }
    }

    @Override
    public Templates getNestedTemplates(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        TemplateNestMgr m_oNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
        return m_oNestMgr.getNestedTemplates(_template);
    }

    @Override
    public Templates getTemplatesNested(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        TemplateNestMgr m_oNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
        return m_oNestMgr.getTemplatesNested(_template);
    }

    @Override
    public List getTemplateEmployers(Template _template, int _nEmployerType) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_template, 24)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label36", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u67e5\u770b\u6a21\u677f\u7684\u4f7f\u7528\u8005\u5217\u8868!"));
        }
        return this.m_oEmployMgr.getEmployers(_template, _nEmployerType);
    }

    @Override
    public List getTemplateEmployers(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        if (!AuthServer.hasRight(this.getLoginUser(), (CMSObj)_template, 24)) {
            throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label36", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u67e5\u770b\u6a21\u677f\u7684\u4f7f\u7528\u8005\u5217\u8868!"));
        }
        return this.m_oEmployMgr.getEmployers(_template, null);
    }

    @Override
    public Template findByName(int _nSiteId, String _sTempName) throws WCMException {
        TemplateCacheMgr m_oCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        return m_oCacheMgr.lookupByName((IPublishFolder)PublishElementFactory.lookupElement(103, _nSiteId), _sTempName);
    }

    @Override
    public TemplateArguments getTemplateArguments(IPublishElement _element) throws WCMException {
        return this.m_oArgumentMgr.getArguments(_element);
    }

    @Override
    public boolean deleteTemplateArgument(TemplateArgument _argument) throws WCMException {
        return this.m_oArgumentMgr.delete(_argument);
    }

    @Override
    public void deleteTemplateArguments(TemplateArguments _arguments) throws WCMException {
        if (_arguments == null) {
            throw new WCMException(10, I18NMessage.get(TemplateService.class, "TemplateService.label37", "\u65e0\u6548\u7684\u6a21\u677f\u53c2\u6570\u96c6\u5408,\u65e0\u6cd5\u5220\u9664!"));
        }
        for (int i = 0; i < _arguments.size(); ++i) {
            TemplateArgument argument = (TemplateArgument)_arguments.getAt(i);
            if (argument == null || this.deleteTemplateArgument(argument)) continue;
            throw new WCMException(1100, I18NMessage.get(TemplateService.class, "TemplateService.label7", "\u5220\u9664Template[") + argument.getArgumentName() + I18NMessage.get(TemplateService.class, "TemplateService.label8", "]\u5931\u8d25,\u4e2d\u6b62\u64cd\u4f5c"));
        }
    }

    @Override
    public TemplateArgument saveTemplateArgument(TemplateArgument _argument) throws WCMException {
        return this.m_oArgumentMgr.save(_argument);
    }

    @Override
    public TemplateParameterList getTemplateParameters(IPublishElement _element) throws WCMException {
        Template temp;
        Templates templates;
        TemplateParameterList list = new TemplateParameterList(true);
        if (_element instanceof IPublishFolder && (templates = this.getOutlineTemplates((IPublishFolder)_element)) != null) {
            for (int i = templates.size() - 1; i >= 0; --i) {
                Template temp2 = (Template)templates.getAt(i);
                if (temp2 == null) continue;
                list.addParameterList(temp2.getTemplateParameters());
            }
        }
        if ((temp = this.getDetailTemplate(_element)) != null) {
            list.addParameterList(temp.getTemplateParameters());
        }
        return list;
    }

    @Override
    public TemplateParameterList getTemplateParameters(IPublishElement _element, boolean zRecursion) throws WCMException {
        Template temp;
        Templates templates;
        TemplateParameterList list = new TemplateParameterList(true);
        TemplateParameterList listTemp = null;
        if (_element instanceof IPublishFolder && (templates = this.getOutlineTemplates((IPublishFolder)_element)) != null) {
            for (int i = templates.size() - 1; i >= 0; --i) {
                Template temp2 = (Template)templates.getAt(i);
                if (temp2 == null || (listTemp = temp2.getTemplateParameters()) == null) continue;
                this.addNestedParameters(_element, temp2, listTemp);
                list.addParameterList(listTemp);
            }
        }
        if ((temp = this.getDetailTemplate(_element)) != null && (listTemp = temp.getTemplateParameters()) != null) {
            this.addNestedParameters(_element, temp, listTemp);
            list.addParameterList(listTemp);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNestedParameters(IPublishElement _element, Template template, TemplateParameterList list) {
        if (list.getNestParsed()) {
            return;
        }
        TemplateService templateService = this;
        synchronized (templateService) {
            Iterator itr = template.iterateNestedIdentity();
            if (itr == null) {
                return;
            }
            while (itr.hasNext()) {
                String sIdentity = (String)itr.next();
                Template temp = template.getNestedTemplate(_element, sIdentity);
                temp.getTemplateParameters();
            }
        }
    }

    private void validateRight(Template _template, int _nRightIndex, String _sOperDesc) throws WCMException {
        IPublishFolder folder = _template.getFolder();
        if (folder == null) {
            throw new WCMException(200006, I18NMessage.get(TemplateService.class, "TemplateService.label38", "\u6a21\u677f\u6240\u5c5e\u680f\u76ee\u6ca1\u6709\u627e\u5230\uff01"));
        }
        if (AuthServer.hasRight(this.getLoginUser(), folder.getSubstance(), _nRightIndex)) {
            return;
        }
        for (IPublishFolder parent = folder.getParent(); parent != null; parent = parent.getParent()) {
            if (AuthServer.hasRight(this.getLoginUser(), parent.getSubstance(), _nRightIndex)) {
                return;
            }
            if (parent.isRoot()) break;
        }
        throw new WCMException(1002, I18NMessage.get(TemplateService.class, "TemplateService.label39", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743") + _sOperDesc + "!");
    }
}

