/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.index.Consumer;
import com.trs.index.LuceneContext;
import com.trs.index.Producer;
import com.trs.index.config.TableFieldDesc;
import com.trs.index.domain.IndexMrg;
import com.trs.index.domain.IndexTmpMgr;
import com.trs.index.vo.IndexField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.service.IIndexService;
import com.trs.service.impl.SearcherTool;
import com.trs.webframework.context.MethodContext;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.store.Directory;

public class IndexService
implements IIndexService {
    private static int count = 0;
    private static List<Consumer> consumerList = null;
    private static long start = 0L;
    private static BlockingQueue<IndexField> queue = null;
    private static int oldNum = 0;
    private static int newNum = 0;
    private static boolean flag = false;
    private static Logger m_oLogger = Logger.getLogger(IndexService.class);
    private IndexTmpMgr m_oIndexTempMgr = (IndexTmpMgr)DreamFactory.createObjectById("IndexTmpMgr");
    private IndexMrg m_oIndexMgr = (IndexMrg)DreamFactory.createObjectById("IndexMgr");

    @Override
    public String getLighter(String field, String line, String key) {
        TableFieldDesc desc = LuceneContext.getInstance().getIndexConfig().getAllFieldMap().get(field);
        Query query = IndexService.getQuery(desc, key, QueryParser.Operator.OR);
        QueryScorer queryScorer = new QueryScorer(query);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(queryScorer);
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<font color='red'>", "</font>");
        Highlighter lighter = new Highlighter((Formatter)formatter, (Scorer)queryScorer);
        lighter.setTextFragmenter((Fragmenter)fragmenter);
        String highlighter = line;
        try {
            highlighter = lighter.getBestFragment(LuceneContext.getInstance().getAnalyzer(), field, line);
            if (highlighter != null) {
                return highlighter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidTokenOffsetsException e) {
            e.printStackTrace();
        }
        return line;
    }

    private Query getscQuery(MethodContext _methodContext) {
        Map<String, TableFieldDesc> map = LuceneContext.getInstance().getIndexConfig().getAllFieldMap();
        TableFieldDesc tablefieldDesc = map.get("CHNLID");
        Channels oQueryChannels = (Channels)_methodContext.getObjectValue("oQueryChannels");
        if (oQueryChannels == null) {
            return null;
        }
        StringBuilder channelIds = new StringBuilder();
        for (int i = 0; oQueryChannels != null && i < oQueryChannels.size(); ++i) {
            Channel channel = (Channel)oQueryChannels.getAt(i);
            channelIds.append(channel.getId() + ",");
        }
        channelIds.deleteCharAt(channelIds.length() - 1);
        return IndexService.getQuery(tablefieldDesc, channelIds.toString(), QueryParser.Operator.OR);
    }

    private List<Query> getConditionQuery(Map<String, Query> queryMap, BooleanClause.Occur occur) {
        ArrayList<Query> conditionQueryList = new ArrayList<Query>();
        BooleanQuery query = new BooleanQuery();
        Set<Map.Entry<String, Query>> entrySet = queryMap.entrySet();
        Iterator<Map.Entry<String, Query>> it = entrySet.iterator();
        Map<String, TableFieldDesc> map = LuceneContext.getInstance().getIndexConfig().getAllFieldMap();
        if (BooleanClause.Occur.MUST == occur) {
            while (it.hasNext()) {
                Map.Entry<String, Query> entry = it.next();
                query.add(entry.getValue(), occur);
            }
        } else {
            while (it.hasNext()) {
                Map.Entry<String, Query> entry = it.next();
                TableFieldDesc tableFieldDesc = map.get(entry.getKey());
                if ("must".equalsIgnoreCase(tableFieldDesc.getOccur())) {
                    conditionQueryList.add(entry.getValue());
                    continue;
                }
                query.add(entry.getValue(), occur);
            }
        }
        conditionQueryList.add((Query)query);
        return conditionQueryList;
    }

    private static Query makeFilterTypeForLucene(MethodContext _methodContext) throws Exception {
        int _nFilterType = _methodContext.getValue("FILTERTYPE", 0);
        Query query = null;
        if (_nFilterType == 0) {
            return query;
        }
        Map<String, TableFieldDesc> map = LuceneContext.getInstance().getIndexConfig().getAllFieldMap();
        TableFieldDesc tableFieldDesc = map.get("DOCSTATUS");
        switch (_nFilterType) {
            case 1: {
                query = IndexService.getQuery(tableFieldDesc, "1", QueryParser.Operator.OR);
                break;
            }
            case 3: {
                query = IndexService.getQuery(tableFieldDesc, "10", QueryParser.Operator.OR);
                break;
            }
            case 8: {
                query = IndexService.getQuery(tableFieldDesc, "15", QueryParser.Operator.OR);
                break;
            }
            case 9: {
                query = IndexService.getQuery(tableFieldDesc, "2", QueryParser.Operator.OR);
                break;
            }
            case 2: {
                CMSBaseObjs _oSitesOrChannels = (CMSBaseObjs)_methodContext.getObjectValue("objects");
                if (_oSitesOrChannels.size() > 1) {
                    query = IndexService.getQuery(tableFieldDesc, "1,2,16,18", QueryParser.Operator.OR);
                    break;
                }
                WebSite site = ((BaseChannel)_oSitesOrChannels.getAt(0)).getSite();
                IFolderPubStatusCacheMgr oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
                int[] pStatus = oCacheMgr.findStatusesCanDoIncreasePub(site.getWCMType(), site.getId());
                if (pStatus == null || pStatus.length == 0) {
                    pStatus = new int[]{-1};
                }
                StringBuilder tempString = new StringBuilder();
                for (int i = 0; i < pStatus.length; ++i) {
                    tempString.append(pStatus[i]);
                    tempString.append(",");
                }
                query = IndexService.getQuery(tableFieldDesc, tempString.deleteCharAt(tempString.length() - 1).toString(), QueryParser.Operator.OR);
                break;
            }
            case 4: {
                tableFieldDesc = map.get("CRUSER");
                query = IndexService.getQuery(tableFieldDesc, ContextHelper.getLoginUser().getName(), QueryParser.Operator.OR);
                break;
            }
            case 5: {
                tableFieldDesc = map.get("CRTIME");
                query = IndexService.getTimeQuery(tableFieldDesc.getKey(), null, null, "5");
                break;
            }
            case 6: {
                tableFieldDesc = map.get("CRTIME");
                query = IndexService.getTimeQuery(tableFieldDesc.getKey(), null, null, "6");
                break;
            }
            case 7: {
                tableFieldDesc = map.get("CRTIME");
                query = IndexService.getTimeQuery(tableFieldDesc.getKey(), null, null, "7");
                break;
            }
        }
        return query;
    }

    @Override
    public String findIndexByOr(MethodContext methodContext) throws WCMException, IOException {
        BooleanQuery queryAll = new BooleanQuery();
        try {
            Query query = IndexService.makeFilterTypeForLucene(methodContext);
            if (query != null) {
                queryAll.add(query, BooleanClause.Occur.MUST);
            }
        }
        catch (Exception e1) {
            m_oLogger.info((Object)"\u6784\u5efa\u65f6\u95f4\u68c0\u7d22\u6761\u4ef6\u51fa\u9519");
        }
        if (CMyString.isEmpty(methodContext.getValue("DOCSTATUS"))) {
            String status = LuceneContext.getInstance().getIndexConfig().getStatus();
            methodContext.setValue("DOCSTATUS", status);
        }
        HashMap<String, Query> queryMap = new HashMap<String, Query>();
        this.param2Map(methodContext, queryMap);
        List<Query> conditionQueryList = this.getConditionQuery(queryMap, BooleanClause.Occur.SHOULD);
        Query scQuery = this.getscQuery(methodContext);
        for (int i = 0; i < conditionQueryList.size(); ++i) {
            queryAll.add(conditionQueryList.get(i), BooleanClause.Occur.MUST);
        }
        if (scQuery != null) {
            queryAll.add(scQuery, BooleanClause.Occur.MUST);
        }
        return this.getDocIdsByQuery((Query)queryAll, methodContext);
    }

    private void param2Map(MethodContext methodContext, Map<String, Query> queryMap) throws WCMException {
        Map<String, TableFieldDesc> map = LuceneContext.getInstance().getIndexConfig().getAllFieldMap();
        Set<Map.Entry<String, TableFieldDesc>> entrySet = map.entrySet();
        for (Map.Entry<String, TableFieldDesc> entry : entrySet) {
            String value = methodContext.getValue(entry.getKey());
            if (CMyString.isEmpty(value) && !"date".equalsIgnoreCase(entry.getValue().getType())) continue;
            TableFieldDesc tableFieldDesc = entry.getValue();
            if ("date".equalsIgnoreCase(tableFieldDesc.getType())) {
                try {
                    Query query = IndexService.getTimeQuery(tableFieldDesc.getKey(), methodContext.getValue(tableFieldDesc.getStart()), methodContext.getValue(tableFieldDesc.getEnd()), methodContext.getValue(tableFieldDesc.getInterval()));
                    if (query == null) continue;
                    queryMap.put(entry.getKey(), query);
                    continue;
                }
                catch (CMyException e) {
                    throw new WCMException(I18NMessage.get(SearcherTool.class, "SearcherTool.label62", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), e);
                }
                catch (java.text.ParseException e) {
                    throw new WCMException(I18NMessage.get(SearcherTool.class, "SearcherTool.label62", "\u6784\u9020\u65f6\u95f4\u8fc7\u6ee4\u5668\u5931\u8d25!"), e);
                }
            }
            QueryParser.Operator opr = QueryParser.Operator.OR;
            queryMap.put(entry.getKey(), IndexService.getQuery(tableFieldDesc, value, opr));
        }
    }

    private static Query getTimeQuery(String field, String _startTime, String _endTime, String _interval) throws CMyException, java.text.ParseException {
        if (_startTime == null && _endTime == null && _interval == null) {
            return null;
        }
        long startData = 0L;
        long endData = System.currentTimeMillis();
        if (_interval != null) {
            int interval = Integer.parseInt(_interval);
            startData = interval == 5 ? CMyDateTime.now().dateAdd(3, -3).getTimeInMillis() : (interval == 6 ? endData - CMyDateTime.now().dateAdd(12, -1).getTimeInMillis() : endData - CMyDateTime.now().dateAdd(2, -1).getTimeInMillis());
        } else {
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            if (_startTime != null) {
                startData = formatDate.parse(_startTime).getTime();
            }
            if (_endTime != null) {
                endData = formatDate.parse(_endTime).getTime();
            }
        }
        return NumericRangeQuery.newLongRange((String)field, (Long)new Long(startData), (Long)new Long(endData), (boolean)true, (boolean)true);
    }

    private static Query getQuery(TableFieldDesc tableFieldDesc, String value, QueryParser.Operator oper) {
        if (!tableFieldDesc.isAnalyzed() && "String".equalsIgnoreCase(tableFieldDesc.getType())) {
            return new TermQuery(new Term(tableFieldDesc.getKey(), value));
        }
        QueryParser parser = new QueryParser(LuceneContext.getInstance().getVersion(), tableFieldDesc.getKey(), LuceneContext.getInstance().getAnalyzer());
        Query query = null;
        try {
            parser.setDefaultOperator(oper);
            query = parser.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return query;
    }

    private String getDocIdsByQuery(Query query, MethodContext methodContext) throws IOException {
        m_oLogger.debug((Object)query);
        IndexSearcher searcher = LuceneContext.getInstance().getSearcher();
        Object topDocs = null;
        StringBuffer docIds = new StringBuffer();
        int start = 0;
        String currents = methodContext.getValue("CURRPAGE");
        int current = 1;
        if (currents != null) {
            current = Integer.parseInt(currents);
        }
        String s_PageSize = methodContext.getValue("PAGESIZE");
        int pageSize = 10;
        if (s_PageSize != null) {
            pageSize = Integer.parseInt(s_PageSize);
        }
        int docIndex = current * pageSize;
        Sort sort = LuceneContext.getInstance().getIndexConfig().getSortFile();
        topDocs = sort != null ? searcher.search(query, docIndex, sort) : searcher.search(query, docIndex);
        start = docIndex - pageSize;
        ScoreDoc[] socreDocsArr = topDocs.scoreDocs;
        for (int i = start; i < socreDocsArr.length; ++i) {
            Document doc = searcher.doc(socreDocsArr[i].doc);
            docIds.append(doc.get("RECID") + ",");
        }
        int totalCount = topDocs.totalHits;
        if (docIds.length() == 0) {
            return null;
        }
        docIds.deleteCharAt(docIds.length() - 1);
        return docIds.toString() + ":" + totalCount;
    }

    public String getReIndexInfo(MethodContext methodContext) {
        int num = 0;
        for (int j = 0; consumerList != null && j < consumerList.size(); ++j) {
            num += consumerList.get(j).getDealNum();
        }
        int tempNum = 0;
        int speedNum = 0;
        for (int j = 0; consumerList != null && queue != null && j < consumerList.size(); ++j) {
            tempNum += consumerList.get(j).getDealNum();
        }
        newNum = tempNum;
        speedNum = newNum - oldNum;
        oldNum = newNum;
        if (m_oLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            for (int j = 0; consumerList != null && queue != null && j < consumerList.size(); ++j) {
                m_oLogger.debug((Object)("\u7b2c" + j + "\u4e2a\u7ebf\u7a0b\u4e00\u5171\u5904\u7406->" + consumerList.get(j).getDealNum() + "  \u7ebf\u7a0b\u72b6\u6001:" + consumerList.get(j).getIsRunning() + "   \u5f53\u524d\u961f\u5217\u6570:" + queue.size()));
            }
            m_oLogger.debug((Object)("\u603b\u6570\uff1a" + newNum + "   \u6bcf\u79d2\u5904\u7406:" + speedNum + "   \u8017\u65f6\uff1a" + (end - start) / 1000L));
            System.out.println("\n\n\n");
        }
        return num + "-" + count + "-" + flag + '-' + speedNum;
    }

    @Override
    public void updateCommitIndex() {
        try {
            this.m_oIndexTempMgr.delAll();
            LuceneContext.getInstance().commitIndex();
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateReconstructorIndex(MethodContext methodContext) {
        int i;
        int i2;
        int threadNume = methodContext.getValue("readDataThread", 40);
        int dealDataThread = methodContext.getValue("dealDataThread", 10);
        int datanum = methodContext.getValue("datanum", -1);
        LuceneContext.getInstance().setTempIndexNum(dealDataThread);
        int max = 0;
        int dealSize = 0;
        newNum = 0;
        oldNum = 0;
        flag = false;
        start = System.currentTimeMillis();
        try {
            count = DBManager.getDBManager().sqlExecuteIntQuery(LuceneContext.getInstance().getIndexConfig().getCountSql());
            String maxSql = "SELECT MAX(DOCID) FROM WCMDOCUMENT";
            max = DBManager.getDBManager().sqlExecuteIntQuery(maxSql);
            if (datanum < count && datanum > 0) {
                count = datanum;
                max = datanum;
            }
            dealSize = (int)Math.ceil((double)max * 1.0 / (double)threadNume);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IndexWriter[] indexWriters = LuceneContext.getInstance().getTempIndexWriters();
        try {
            m_oLogger.debug((Object)"\u6e05\u9664\u5df2\u6709\u7684\u7d22\u5f15\u4fe1\u606f");
            LuceneContext.getInstance().getIndexWriter().deleteAll();
            LuceneContext.getInstance().commitIndex();
        }
        catch (IOException e1) {
            m_oLogger.info((Object)"\u5220\u9664\u4e3b\u7d22\u5f15\u5f02\u5e38");
        }
        queue = new ArrayBlockingQueue<IndexField>(1000);
        ArrayList<Producer> producerList = new ArrayList<Producer>();
        for (i2 = 0; i2 < threadNume; ++i2) {
            int start = i2 * dealSize + 1;
            m_oLogger.debug((Object)("\u7b2c" + i2 + "\u6bb5->start:" + start + "  end:" + (start + dealSize - 1)));
            producerList.add(new Producer(queue, start, start + dealSize - 1));
        }
        consumerList = new ArrayList<Consumer>();
        for (i2 = 0; i2 < indexWriters.length; ++i2) {
            try {
                m_oLogger.debug((Object)("\u6e05\u9664\u7f13\u5b58\u7d22\u5f15\u5e93" + i2));
                indexWriters[i2].deleteAll();
                indexWriters[i2].commit();
            }
            catch (IOException e) {
                m_oLogger.info((Object)"\u6e05\u9664\u7f13\u5b58\u7d22\u5f15\u4fe1\u606f\u5f02\u5e38");
            }
            consumerList.add(new Consumer(queue, indexWriters[i2]));
        }
        final ExecutorService service = Executors.newCachedThreadPool();
        for (i = 0; i < producerList.size(); ++i) {
            service.execute((Runnable)producerList.get(i));
        }
        for (i = 0; i < consumerList.size(); ++i) {
            service.execute(consumerList.get(i));
        }
        service.execute(new Runnable(){

            @Override
            public void run() {
                int num = 0;
                while (true) {
                    try {
                        do {
                            Thread.sleep(3000L);
                            for (int i = 0; i < consumerList.size(); ++i) {
                                if (((Consumer)consumerList.get(i)).getIsRunning() || ((Consumer)consumerList.get(i)).isMerged()) continue;
                                m_oLogger.info((Object)("\u7f13\u5b58\u7d22\u5f15:" + i + "\u7d22\u5f15\u6784\u5efa\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5408\u5e76\u7d22\u5f15"));
                                LuceneContext.getInstance().getTempIndexWriters()[i].commit();
                                LuceneContext.getInstance().getIndexWriter().addIndexes(new Directory[]{LuceneContext.getInstance().getTempDirectory()[i]});
                                m_oLogger.info((Object)("\u7f13\u5b58\u7d22\u5f15:" + i + "\u6210\u529f\u5408\u5e76\u7d22\u5f15"));
                                LuceneContext.getInstance().getTempIndexWriters()[i].deleteAll();
                                LuceneContext.getInstance().getTempIndexWriters()[i].commit();
                                LuceneContext.getInstance().getTempIndexWriters()[i].close();
                                LuceneContext.getInstance().getTempDirectory()[i].close();
                                ((Consumer)consumerList.get(i)).setMerged(true);
                                ++num;
                            }
                        } while (num != consumerList.size());
                        m_oLogger.debug((Object)"\u5408\u5e76\u5b8c\u6bd5\uff0c\u7a0b\u5e8f\u8fd0\u884c\u7ec8\u6b62");
                        LuceneContext.getInstance().commitIndex();
                        m_oLogger.debug((Object)"\u4e3b\u7d22\u5f15\u63d0\u4ea4\u5b8c\u6bd5");
                        flag = true;
                    }
                    catch (CorruptIndexException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
                queue = null;
                m_oLogger.debug((Object)"\u5173\u95ed\u7ebf\u7a0b\u6c60");
                service.shutdownNow();
                LuceneContext.getInstance().setTempWriter(null);
            }
        });
    }

    @Override
    public String findIndexByAnd(MethodContext methodContext) throws WCMException, IOException {
        BooleanQuery queryAll = new BooleanQuery();
        try {
            Query query = IndexService.makeFilterTypeForLucene(methodContext);
            if (query != null) {
                queryAll.add(query, BooleanClause.Occur.MUST);
            }
        }
        catch (Exception e1) {
            m_oLogger.info((Object)"\u6784\u5efa\u65f6\u95f4\u68c0\u7d22\u6761\u4ef6\u51fa\u9519");
        }
        HashMap<String, Query> queryMap = new HashMap<String, Query>();
        this.param2Map(methodContext, queryMap);
        List<Query> conditionQueryList = this.getConditionQuery(queryMap, BooleanClause.Occur.MUST);
        Query scQuery = this.getscQuery(methodContext);
        for (int i = 0; i < conditionQueryList.size(); ++i) {
            queryAll.add(conditionQueryList.get(i), BooleanClause.Occur.MUST);
        }
        if (scQuery != null) {
            queryAll.add(scQuery, BooleanClause.Occur.MUST);
        }
        return this.getDocIdsByQuery((Query)queryAll, methodContext);
    }

    @Override
    public String findIndexByChannels(MethodContext methodContext) {
        try {
            String region = methodContext.getValue("REGION");
            if (CMyString.isEmpty(region)) {
                return this.findIndexByOr(methodContext);
            }
            return this.findIndexByAnd(methodContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String findIndexBySiteType(MethodContext methodContext) {
        return null;
    }

    @Override
    public String findIndexBySiteIds(MethodContext methodContext) {
        return null;
    }

    @Override
    public String findDocIds(MethodContext methodContext) {
        String region = methodContext.getValue("REGION");
        try {
            if (!CMyString.isEmpty(region)) {
                return this.findIndexByAnd(methodContext);
            }
            String methodname = methodContext.getMethodConfig().getName();
            String value = methodContext.getValue("DOCTITLE");
            boolean flag = true;
            if (!CMyString.isEmpty(value)) {
                String tempValue = value.toUpperCase();
                List<TableFieldDesc> list = LuceneContext.getInstance().getIndexConfig().getAllTableFieldDescList();
                for (int i = 0; i < list.size(); ++i) {
                    String key = list.get(i).getKey() + ":";
                    if (tempValue.indexOf(key) == -1) continue;
                    flag = false;
                    for (int j = 0; j < list.size(); ++j) {
                        String fieldName = list.get(j).getFieldName();
                        methodContext.setValue(fieldName, "");
                    }
                    methodContext.setValue("DOCTITLE", tempValue);
                    break;
                }
            }
            if ("QUICKQUERY".equalsIgnoreCase(methodname) && flag) {
                List<TableFieldDesc> list = LuceneContext.getInstance().getIndexConfig().getAllTableFieldDescList();
                for (int i = 0; i < list.size(); ++i) {
                    TableFieldDesc tableFieldDesc = list.get(i);
                    if (!tableFieldDesc.isQuickQuery()) continue;
                    methodContext.setValue(tableFieldDesc.getFieldName(), value);
                }
            }
            return this.findIndexByOr(methodContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }
}

