/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.BookMark;
import com.trs.components.common.bookmark.BookMarkMgr;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.service.IBookMarkService;
import java.util.StringTokenizer;

public class BookMarkService
implements IBookMarkService {
    private BookMarkMgr currMgr = null;

    private BookMarkMgr getBookMarkMgr() throws WCMException {
        if (this.currMgr != null) {
            return this.currMgr;
        }
        this.currMgr = (BookMarkMgr)DreamFactory.createObjectById("BookMarkMgr");
        if (this.currMgr == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label1", "BookMarkMgr\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u7684\u4e0d\u6b63\u786e\uff01"));
        }
        return this.currMgr;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public BookMark save(BookMark _aBookMark) throws WCMException {
        return this.getBookMarkMgr().saveBookMark(_aBookMark);
    }

    @Override
    public boolean deleteBookMark(int _nBookMarkId) throws WCMException {
        return this.getBookMarkMgr().deleteBookMark(BookMark.findById(_nBookMarkId));
    }

    @Override
    public boolean deleteBookMark(String _sBookMarkIds) throws WCMException {
        BookMarks oBookMarks = BookMarks.findByIds(this.getLoginUser(), _sBookMarkIds);
        if (oBookMarks == null || oBookMarks.isEmpty()) {
            return true;
        }
        for (int i = 0; i < oBookMarks.size(); ++i) {
            BookMark oBookMark = (BookMark)oBookMarks.getAt(i);
            this.getBookMarkMgr().deleteBookMark(oBookMark);
        }
        return true;
    }

    @Override
    public boolean deleteMarkKind(int _nMarkKindId) throws WCMException {
        return this.getBookMarkMgr().deleteMarkKind(MarkKind.findById(_nMarkKindId));
    }

    @Override
    public boolean deleteMarkKind(String _sBookMarkIds) throws WCMException {
        StringTokenizer stIds = new StringTokenizer(_sBookMarkIds, ",");
        while (stIds.hasMoreTokens()) {
            this.deleteMarkKind(Integer.parseInt(stIds.nextToken()));
        }
        return true;
    }

    @Override
    public void moveBookMark(int _aBookMark, int _aMarkKind) throws WCMException {
        this.getBookMarkMgr().moveBookMark(BookMark.findById(_aBookMark), MarkKind.findById(_aMarkKind));
    }

    @Override
    public void moveBookMark(String _sBookMarkIds, int _nMarkKindId) throws WCMException {
        StringTokenizer stIds = new StringTokenizer(_sBookMarkIds, ",");
        while (stIds.hasMoreTokens()) {
            this.moveBookMark(Integer.parseInt(stIds.nextToken()), _nMarkKindId);
        }
    }

    @Override
    public Reports moveBookMarks(String _sMarkIds, int _nMarkKindId) throws WCMException {
        BookMarks marks = BookMarks.findByIds(this.getLoginUser(), _sMarkIds);
        MarkKind newParent = MarkKind.findById(_nMarkKindId);
        if (newParent == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label2", "\u6ca1\u6709\u627e\u5230\u76ee\u6807\u6587\u4ef6\u5939[id=") + _nMarkKindId + "]!");
        }
        Reports reports = new Reports("");
        BookMarkMgr manager = this.getBookMarkMgr();
        int nSucessedCount = 0;
        int nFailedCount = 0;
        for (int i = 0; i < marks.size(); ++i) {
            BookMark mark = (BookMark)marks.getAt(i);
            if (mark == null) continue;
            try {
                manager.moveBookMark(mark, newParent);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(BookMarkService.class, "BookMarkService.label11", "\u79fb\u52a8\u4e66\u7b7e\u4ece{0}\u5230{1}\u6210\u529f."), new Object[]{mark, newParent}));
                ++nSucessedCount;
                continue;
            }
            catch (Throwable t) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(BookMarkService.class, "BookMarkService.label12", "\u79fb\u52a8\u4e66\u7b7e\u4ece{0}\u5230{1}\u5931\u8d25."), new Object[]{mark, newParent}), t);
                ++nFailedCount;
            }
        }
        if (nFailedCount > 0) {
            reports.setTitle(I18NMessage.get(BookMarkService.class, "BookMarkService.label13", "\u79fb\u52a8\u4e66\u7b7e\u5931\u8d25"));
        } else {
            reports.setTitle(I18NMessage.get(BookMarkService.class, "BookMarkService.label14", "\u79fb\u52a8\u4e66\u7b7e\u6210\u529f"));
        }
        return reports;
    }

    @Override
    public BookMarks getBookMarks(int _nMarkKindId) throws WCMException {
        return this.getBookMarks(_nMarkKindId, null);
    }

    @Override
    public BookMarks getBookMarks(int _nMarkKindId, WCMFilter _filter) throws WCMException {
        return this.getBookMarkMgr().getBookMarks(_nMarkKindId, _filter);
    }

    @Override
    public BookMarks getBookMarks(WCMFilter _filter) throws WCMException {
        return this.getBookMarkMgr().getBookMarks(_filter);
    }

    @Override
    public MarkKinds getChildren(int _nMarkKindId, WCMFilter _filter) throws WCMException {
        return this.getBookMarkMgr().getChildren(MarkKind.findById(_nMarkKindId), _filter);
    }

    @Override
    public BookMarks getSharedBookMarks(User _currUser, WCMFilter _fliter) throws WCMException {
        return this.getBookMarkMgr().getSharedBookMarks(_currUser, _fliter);
    }

    @Override
    public MarkKinds getSharedMarkKinds(User _currUser, WCMFilter _filter) throws WCMException {
        return this.getBookMarkMgr().getSharedMarkKinds(_currUser, _filter);
    }

    @Override
    public void moveMarkKind(int _nMarkKindId, int _nNewParentId) throws WCMException {
        this.getBookMarkMgr().moveMarkKind(MarkKind.findById(_nMarkKindId), MarkKind.findById(_nNewParentId));
    }

    @Override
    public MarkKind save(MarkKind _aMarkKind) throws WCMException {
        return this.getBookMarkMgr().saveMarkKind(_aMarkKind);
    }

    @Override
    public Groups getSharedGroups(int _nObjType, int _nObjId) throws WCMException {
        CMSObj currObj = null;
        switch (_nObjType) {
            case 303: {
                currObj = BookMark.findById(_nObjId);
                break;
            }
            case 307: {
                currObj = MarkKind.findById(_nObjId);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        return this.getBookMarkMgr().getSharedGroups(_nObjType, currObj);
    }

    @Override
    public Users getSharedUsers(int _nObjType, int _nObjId) throws WCMException {
        CMSObj currObj = null;
        switch (_nObjType) {
            case 303: {
                currObj = BookMark.findById(_nObjId);
                break;
            }
            case 307: {
                currObj = MarkKind.findById(_nObjId);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        return this.getBookMarkMgr().getSharedUsers(_nObjType, currObj);
    }

    @Override
    public void cancelShares(int _nObjType, String _sObjIds) throws WCMException {
        CMSBaseObjs currObjs = null;
        switch (_nObjType) {
            case 303: {
                currObjs = BookMarks.findByIds(this.getLoginUser(), _sObjIds);
                break;
            }
            case 307: {
                currObjs = MarkKinds.findByIds(this.getLoginUser(), _sObjIds);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        this.getBookMarkMgr().cancelShares(_nObjType, currObjs);
    }

    @Override
    public void moveMarkKind(String _sMarkKindIds, int _nNewParentId) throws WCMException {
        StringTokenizer stIds = new StringTokenizer(_sMarkKindIds, ",");
        while (stIds.hasMoreTokens()) {
            this.moveMarkKind(Integer.parseInt(stIds.nextToken()), _nNewParentId);
        }
    }

    @Override
    public void shareTo(int _nObjType, String _sObjIds, int _nShareObjType, String _sShareObjIds) throws WCMException {
        CMSBaseObjs currObjs = null;
        switch (_nObjType) {
            case 303: {
                currObjs = BookMarks.findByIds(this.getLoginUser(), _sObjIds);
                break;
            }
            case 307: {
                currObjs = MarkKinds.findByIds(this.getLoginUser(), _sObjIds);
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(BookMarkService.class, "BookMarkService.label10", "\u4f20\u5165\u9519\u8bef\u7684\u5bf9\u8c61\u7c7b\u578b\uff01"));
            }
        }
        this.getBookMarkMgr().shareTo(_nObjType, currObjs, _nShareObjType, _sShareObjIds);
    }
}

