/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.scm.domain.OAuthObjUtil;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.AccountMicroContent;
import com.trs.scm.persistent.AccountMicroContents;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.sdk.IMicroContentMgr;
import com.trs.scm.sdk.IMicroUserMgr;
import com.trs.scm.sdk.factory.PlatformFactory;
import com.trs.scm.sdk.model.Count;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.stat.MicroContentStatData;
import com.trs.scm.stat.MicroContentStatDatas;
import com.trs.scm.stat.MicroUserStatData;
import com.trs.scm.stat.MicroUserStatDatas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StatDataRequestScheduleWorker
extends BaseStatefulScheduleWorker {
    private static Logger logger = Logger.getLogger(StatDataRequestScheduleWorker.class);
    private int m_nDefaultMaxRow = 200;
    private Map m_MCCrtime = new HashMap();

    @Override
    protected void execute() throws WCMException {
        ContextHelper.initContext(User.getSystem());
        WCMFilter oAccountFilter = new WCMFilter("", "status = 1", "");
        Accounts oAllAccounts = null;
        try {
            oAllAccounts = Accounts.openWCMObjs(User.getSystem(), oAccountFilter);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u6709\u6548\u5e10\u53f7\u96c6\u5408\u629b\u9519\uff01", (Throwable)e);
        }
        if (oAllAccounts == null || oAllAccounts.size() == 0) {
            logger.debug((Object)(CMyDateTime.now().testDateFormat("yyyy-MM-dd HH:mm:ss") + ": \u5b9a\u65f6\u66f4\u65b0\u6570\u636e\u8868\uff0c\u83b7\u53d6\u5230\u5e10\u53f7\u4fe1\u606f\u4e3a\u7a7a\u3002"));
            return;
        }
        for (int i = 0; i < oAllAccounts.size(); ++i) {
            Account oCurrAccount = (Account)oAllAccounts.getAt(i);
            if (oCurrAccount == null) {
                logger.debug((Object)(CMyDateTime.now().testDateFormat("yyyy-MM-dd HH:mm:ss") + ": \u5b9a\u65f6\u66f4\u65b0\u6570\u636e\u8868\uff0c\u672a\u83b7\u53d6\u5230\u6709\u6548\u5e10\u53f7\u4fe1\u606f\u3002Index\u4e3a:[" + i + "]"));
                continue;
            }
            try {
                this.doMicroContentTaskForCurrAcc(oCurrAccount);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.doMicroUserTaskForCurrAcc(oCurrAccount);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ContextHelper.clear();
    }

    private void doMicroUserTaskForCurrAcc(Account oCurrAccount) throws WCMException {
        int nCurrAccountId = oCurrAccount.getId();
        IMicroUserMgr oMicroUserMgr = this.queryMicroUserMgr(oCurrAccount);
        if (oMicroUserMgr == null) {
            return;
        }
        MicroUser oCurrMicroUser = null;
        try {
            oCurrMicroUser = oMicroUserMgr.showUser();
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5fae\u535a\u7528\u6237\u65f6\u51fa\u9519\uff01[AccountId = " + nCurrAccountId + " & PlatForm = " + oCurrAccount.getPlatform() + "]"), (Throwable)e);
            throw new WCMException("\u8bf7\u6c42\u5fae\u535a\u7528\u6237\u65f6\u51fa\u9519\uff01[AccountId = " + nCurrAccountId + " & PlatForm = " + oCurrAccount.getPlatform() + "]", e);
        }
        WCMFilter oFilter = new WCMFilter("", "ACCOUNTID = ?", "CRTIME desc");
        oFilter.addSearchValues(nCurrAccountId);
        MicroUserStatDatas oMicroUserStatDatas = null;
        MicroUserStatData oResult = null;
        try {
            MicroUserStatData oTempResult;
            oMicroUserStatDatas = MicroUserStatDatas.openWCMObjs(User.getSystem(), oFilter);
            if (oMicroUserStatDatas.size() > 0 && (oTempResult = (MicroUserStatData)oMicroUserStatDatas.getAt(0)).getCrTime().getMonth() == CMyDateTime.now().getMonth()) {
                oResult = oTempResult;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6MicroUser\u7edf\u8ba1\u6570\u636e\u96c6\u5408\u629b\u9519\uff01", (Throwable)e);
            throw new WCMException("\u83b7\u53d6MicroUser\u7edf\u8ba1\u6570\u636e\u96c6\u5408\u629b\u9519", e);
        }
        if (oResult == null) {
            oResult = MicroUserStatData.createNewInstance();
        }
        try {
            oResult.setAccountId(nCurrAccountId);
            oResult.setFollowerCount(oCurrMicroUser.getFollowersCount());
            oResult.setFriendCount(oCurrMicroUser.getFriendsCount());
            oResult.setMicroContentCount(oCurrMicroUser.getMicroContentCount());
            oResult.setFavoriteCount(oCurrMicroUser.getFavoritesCount());
            oResult.setCrTime();
            oResult.save(ContextHelper.getLoginUser());
        }
        catch (WCMException e) {
            logger.error((Object)("\u4fdd\u5b58MicroUser\u7edf\u8ba1\u6570\u636e\u96c6\u5408\u629b\u9519\uff01[AccountId = " + nCurrAccountId + "]"), (Throwable)e);
            throw e;
        }
        finally {
            oResult.unlock();
        }
    }

    private void doMicroContentTaskForCurrAcc(Account oCurrAccount) throws WCMException {
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgr(oCurrAccount);
        int nMaxRow = this.m_nDefaultMaxRow;
        try {
            if (this.getArgAsString("MAXROW") != null) {
                nMaxRow = Integer.valueOf(this.getArgAsString("MAXROW"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
        List oMicroContentIdsList = this.queryMicroContentIds(oCurrAccount, nMaxRow);
        int nSize = oMicroContentIdsList.size();
        Map<String, Count> oResultOfCurrAcc = null;
        for (int i = 0; i < nSize; ++i) {
            try {
                String sMicroContentIds = (String)oMicroContentIdsList.get(i);
                oResultOfCurrAcc = oMicroContentMgr.getCount(sMicroContentIds);
            }
            catch (Exception e) {
                logger.error((Object)("\u83b7\u53d6\u5e10\u53f7[ID=" + oCurrAccount.getId() + "] & AccountName = " + oCurrAccount.getAccountName() + "] & PlatForm = [" + oCurrAccount.getPlatform() + "]\u7b2c" + (i + 1) + "\u4e2a30\u6761\u7684\u8f6c\u53d1\u6570\u3001\u8bc4\u8bba\u6570\u65f6\u629b\u9519\uff01"), (Throwable)e);
                continue;
            }
            this.saveToDB(oCurrAccount, oResultOfCurrAcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDB(Account _oCurrAccount, Map<String, Count> _oResult) throws WCMException {
        Iterator<String> oMicroConterIdsIter = _oResult.keySet().iterator();
        MicroContentStatData oCurrStatData = null;
        int nCurrAccountId = _oCurrAccount.getId();
        while (oMicroConterIdsIter.hasNext()) {
            String sCurrMicroId;
            block13: {
                sCurrMicroId = oMicroConterIdsIter.next();
                WCMFilter oSearchFilter = new WCMFilter("", "ACCOUNTID = ? and MICROCONTENTID = ?", "");
                oSearchFilter.addSearchValues(nCurrAccountId);
                oSearchFilter.addSearchValues(sCurrMicroId);
                MicroContentStatDatas oResultRecords = null;
                try {
                    oResultRecords = MicroContentStatDatas.openWCMObjs(User.getSystem(), oSearchFilter);
                }
                catch (WCMException e) {
                    logger.error((Object)("\u83b7\u53d6MicroContent\u7edf\u8ba1\u6570\u636e\u96c6\u5408\u629b\u9519\uff01[AccountId = " + nCurrAccountId + " & MicroContentId = " + sCurrMicroId + "]"), (Throwable)e);
                    continue;
                }
                if (oResultRecords == null || oResultRecords.size() == 0) {
                    try {
                        oCurrStatData = MicroContentStatData.createNewInstance();
                        break block13;
                    }
                    catch (WCMException e) {
                        logger.error((Object)"\u521b\u5efaMicroContentStatData\u5bf9\u8c61\u51fa\u9519\uff01", (Throwable)e);
                        continue;
                    }
                }
                if (oResultRecords.size() == 1) {
                    oCurrStatData = (MicroContentStatData)oResultRecords.getAt(0);
                } else {
                    logger.error((Object)("\u8bfb\u53d6\u6570\u636e\u5e93\u8bb0\u5f55\u65f6\u51fa\u73b0\u591a\u91cd\u8bb0\u5f55\uff01[AccountId = " + nCurrAccountId + " & MicroContentId = " + sCurrMicroId + "]"));
                    continue;
                }
            }
            CMyDateTime dPublishDate = (CMyDateTime)this.m_MCCrtime.get(nCurrAccountId + "_" + sCurrMicroId);
            Count oCurrCount = _oResult.get(sCurrMicroId);
            long nRetweetedCount = oCurrCount.getRepostCount();
            long nCommentCount = oCurrCount.getCommentCount();
            try {
                oCurrStatData.setAccountId(nCurrAccountId);
                oCurrStatData.setMicroContentId(sCurrMicroId);
                oCurrStatData.setRetweetCount(nRetweetedCount);
                oCurrStatData.setCommentCount(nCommentCount);
                oCurrStatData.setMicroContentCrTime(dPublishDate);
                oCurrStatData.save(ContextHelper.getLoginUser());
            }
            catch (WCMException e) {
                logger.error((Object)("\u4fdd\u5b58AccountMicroContent\u7edf\u8ba1\u6570\u636e\u96c6\u5408\u629b\u9519\uff01[AccountId = " + nCurrAccountId + " & MicroContentId = " + sCurrMicroId + "]"), (Throwable)e);
            }
            finally {
                oCurrStatData.unlock();
            }
        }
    }

    private List queryMicroContentIds(Account _oCurrAccount, int _nMaxRow) throws WCMException {
        int nCurrAccountId = _oCurrAccount.getId();
        WCMFilter oMicroContentsFilter = new WCMFilter("", "ACCOUNTID = ?", "CRTIME desc", "", _nMaxRow);
        oMicroContentsFilter.addSearchValues(nCurrAccountId);
        AccountMicroContents oMicroContentsOfCurrAccount = null;
        try {
            oMicroContentsOfCurrAccount = AccountMicroContents.openWCMObjs(User.getSystem(), oMicroContentsFilter);
        }
        catch (WCMException e) {
            logger.error((Object)("\u83b7\u53d6AccountMicroContents\u96c6\u5408\u629b\u9519\uff01[AccountId = " + nCurrAccountId + "]"), (Throwable)e);
            throw e;
        }
        if (oMicroContentsOfCurrAccount == null || oMicroContentsOfCurrAccount.size() == 0) {
            logger.info((Object)("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u5e10\u53f7[" + nCurrAccountId + "]\u53d1\u5e03\u7684\u603b\u5fae\u535a\u5217\u8868\u3002"));
        }
        ArrayList<String> oIdsList = new ArrayList<String>();
        StringBuffer sMicroContentIds = new StringBuffer(1000);
        int nCursor = 0;
        int nMaxCursor = 30;
        int nSize = oMicroContentsOfCurrAccount.size();
        for (int j = 0; j < nSize; ++j) {
            String sIds;
            AccountMicroContent oCurrAccountMicroContent = (AccountMicroContent)oMicroContentsOfCurrAccount.getAt(j);
            if (oCurrAccountMicroContent == null) continue;
            ++nCursor;
            String sMCId = oCurrAccountMicroContent.getMicroContentId();
            sMicroContentIds.append(sMCId + ",");
            CMyDateTime oCrTime = oCurrAccountMicroContent.getCrTime();
            this.m_MCCrtime.put(nCurrAccountId + "_" + sMCId, oCrTime);
            if (nCursor == nMaxCursor) {
                sIds = sMicroContentIds.substring(0, sMicroContentIds.length() - 1);
                oIdsList.add(sIds);
                nCursor = 0;
                sMicroContentIds = new StringBuffer(1000);
                continue;
            }
            if (j + 1 != nSize) continue;
            sIds = sMicroContentIds.substring(0, sMicroContentIds.length() - 1);
            oIdsList.add(sIds);
        }
        return oIdsList;
    }

    private IMicroContentMgr queryMicroContentMgr(Account _oCurrAccount) throws WCMException {
        int nCurrAccountId = _oCurrAccount.getId();
        OAuth oOAuth = null;
        try {
            oOAuth = OAuthObjUtil.constructOAuth(_oCurrAccount);
        }
        catch (Exception e) {
            logger.error((Object)("\u6784\u9020\u5e10\u53f7[ID=" + nCurrAccountId + "] & AccountName = " + _oCurrAccount.getAccountName() + "]\u7684\u8ba4\u8bc1\u5bf9\u8c61OAuth\u65f6\u629b\u9519\uff01"), (Throwable)e);
            throw new WCMException("\u6784\u9020\u5e10\u53f7[ID=" + nCurrAccountId + "] & AccountName = " + _oCurrAccount.getAccountName() + "]\u7684\u8ba4\u8bc1\u5bf9\u8c61OAuth\u65f6\u629b\u9519\uff01", e);
        }
        String sPlatform = _oCurrAccount.getPlatform();
        IMicroContentMgr oMicroContentMgr = null;
        try {
            oMicroContentMgr = PlatformFactory.createMicroContentMgr(sPlatform, oOAuth);
        }
        catch (Exception e) {
            logger.error((Object)("\u6784\u9020\u5e10\u53f7[ID=" + nCurrAccountId + "] & AccountName = " + _oCurrAccount.getAccountName() + "] & PlatForm = [" + sPlatform + "]\u7684MicroContentMgr\u65f6\u629b\u9519\uff01"), (Throwable)e);
            throw new WCMException("\u6784\u9020\u5e10\u53f7[ID=" + nCurrAccountId + "] & AccountName = " + _oCurrAccount.getAccountName() + "] & PlatForm = [" + sPlatform + "]\u7684MicroContentMgr\u65f6\u629b\u9519\uff01", e);
        }
        return oMicroContentMgr;
    }

    private IMicroUserMgr queryMicroUserMgr(Account _oCurrAccount) throws WCMException {
        int nCurrAccountId = _oCurrAccount.getId();
        OAuth oOAuth = null;
        try {
            oOAuth = OAuthObjUtil.constructOAuth(_oCurrAccount);
        }
        catch (Exception e) {
            logger.error((Object)("\u6784\u9020\u5e10\u53f7[ID=" + _oCurrAccount.getId() + "] & AccountName = " + _oCurrAccount.getAccountName() + "]\u7684\u8ba4\u8bc1\u5bf9\u8c61OAuth\u65f6\u629b\u9519\uff01"), (Throwable)e);
            return null;
        }
        String sPlatform = _oCurrAccount.getPlatform();
        IMicroUserMgr oMicroUserMgr = null;
        try {
            oMicroUserMgr = PlatformFactory.createMicroUserMgr(sPlatform, oOAuth);
        }
        catch (Exception e) {
            logger.error((Object)("\u6784\u9020\u5e10\u53f7[ID=" + nCurrAccountId + "] & AccountName = " + _oCurrAccount.getAccountName() + "] & PlatForm = [" + sPlatform + "]\u7684IMicroUserMgr\u65f6\u629b\u9519\uff01"), (Throwable)e);
        }
        return oMicroUserMgr;
    }
}

