/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.QueryFlowDocContext;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.scm.domain.ISCMAccountMgr;
import com.trs.scm.domain.ISCMMicroContentMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroups;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.process.FlowContentSCMMicroContentImpl;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.SCMCheckedMicroContent;
import com.trs.scm.sdk.model.SCMCheckedMicroContents;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import t4j.TBlogException;
import weibo4j.model.WeiboException;

public class SCMWorkFlowServiceProvider
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(SCMWorkFlowServiceProvider.class);

    public Flows queryWorkFlowList(MethodContext _oContext) throws Exception {
        if (!SCMAuthServer.isGroupAdminOfSCM(this.getCurrUser())) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u7528\u6237\uff0c\u4e0d\u80fd\u67e5\u770bSCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        String sWorkFlowIds = ConfigServer.getServer().getSysConfigValue("WORKFLOWS_FOR_SCM", "");
        if (CMyString.isEmpty(sWorkFlowIds)) {
            logger.debug((Object)"\u672a\u627e\u5230SCM\u914d\u7f6e\u7684\u5de5\u4f5c\u6d41\uff01");
            return null;
        }
        String[] pWorkFlowIds = sWorkFlowIds.split(",");
        for (int i = 0; i < pWorkFlowIds.length; ++i) {
            int nCurrWorkFlowId = -1;
            try {
                nCurrWorkFlowId = Integer.parseInt(pWorkFlowIds[i]);
            }
            catch (Exception e) {
                String sMsg = "\u5f53\u524d\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u51fa\u73b0\u5f02\u5e38\uff1a\u5de5\u4f5c\u6d41ID[" + pWorkFlowIds[i] + "]";
                logger.error((Object)sMsg, (Throwable)e);
                throw new WCMException(sMsg, e);
            }
            if (nCurrWorkFlowId != -1) continue;
            String sMsg = "\u5f53\u524d\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u51fa\u73b0\u5f02\u5e38\uff1a\u5de5\u4f5c\u6d41ID[" + pWorkFlowIds[i] + "]";
            logger.error((Object)sMsg);
            throw new WCMException(sMsg);
        }
        Flows oResult = Flows.findByIds(this.getCurrUser(), sWorkFlowIds);
        if (oResult == null || oResult.size() == 0) {
            throw new WCMException("\u672a\u67e5\u627e\u5230ID\u5e8f\u5217\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\uff01WORKFLOWS_FOR_SCM: [" + sWorkFlowIds + "]!");
        }
        return oResult;
    }

    public Flow queryDefaultWorkFlow(MethodContext _oContext) throws Exception {
        if (!SCMAuthServer.isGroupAdminOfSCM(this.getCurrUser())) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u7528\u6237\uff0c\u4e0d\u80fd\u67e5\u770bSCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        String sDefaultWorkFlowId = ConfigServer.getServer().getSysConfigValue("DEFAULT_WORKFLOW_FOR_SCM", "");
        if (CMyString.isEmpty(sDefaultWorkFlowId)) {
            logger.debug((Object)"\u672a\u627e\u5230SCM\u914d\u7f6e\u7684\u9ed8\u8ba4\u5de5\u4f5c\u6d41\uff01");
            return null;
        }
        int nDefaultWorkFlowId = -1;
        try {
            nDefaultWorkFlowId = Integer.valueOf(sDefaultWorkFlowId);
        }
        catch (Exception e) {
            String sMsg = "\u5f53\u524d\u914d\u7f6e\u7684SCM\u9ed8\u8ba4\u5de5\u4f5c\u6d41ID\u51fa\u73b0\u5f02\u5e38\uff1a\u9ed8\u8ba4\u5de5\u4f5c\u6d41ID[" + sDefaultWorkFlowId + "]";
            logger.error((Object)sMsg, (Throwable)e);
            throw new WCMException(sMsg, e);
        }
        if (nDefaultWorkFlowId == -1) {
            String sMsg = "\u5f53\u524d\u914d\u7f6e\u7684SCM\u9ed8\u8ba4\u5de5\u4f5c\u6d41ID\u51fa\u73b0\u5f02\u5e38\uff1a\u9ed8\u8ba4\u5de5\u4f5c\u6d41ID[" + sDefaultWorkFlowId + "]";
            logger.error((Object)sMsg);
            throw new WCMException(sMsg);
        }
        Flow oResult = Flow.findById(nDefaultWorkFlowId);
        if (oResult == null) {
            throw new WCMException("\u672a\u67e5\u627e\u5230ID\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\uff01[" + sDefaultWorkFlowId + "]!");
        }
        return oResult;
    }

    public void setDefaultWorkFlow(MethodContext _oMethodContext) throws Exception {
        int nWorkFlowId = _oMethodContext.getValue("WorkFlowId", 0);
        int nSCMGroupId = _oMethodContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nSCMGroupId);
        if (oSCMGroup == null) {
            throw new WCMException("\u60a8\u8bbe\u7f6e\u5de5\u4f5c\u6d41\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff01");
        }
        if (!SCMAuthServer.hasRight(this.getCurrUser(), oSCMGroup, 9)) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u5206\u7ec4\u7ba1\u7406\u4eba\u5458\uff0c\u4e0d\u80fd\u4fee\u6539SCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        String sWorkFlowId = nWorkFlowId == 0 ? "" : String.valueOf(nWorkFlowId);
        ConfigServer.getServer().updateConfigValue("DEFAULT_WORKFLOW_FOR_SCM", sWorkFlowId);
    }

    public Flow queryWorkFlowForGroup(MethodContext _oContext) throws Exception {
        if (!SCMAuthServer.isGroupAdminOfSCM(this.getCurrUser())) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u7528\u6237\uff0c\u4e0d\u80fd\u67e5\u770bSCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        int nGroupId = _oContext.getValue("GroupID", 0);
        SCMGroup oGroup = SCMGroup.findById(nGroupId);
        if (oGroup == null) {
            throw new WCMException("\u672a\u627e\u5230\u5206\u7ec4ID\u5bf9\u5e94\u7684\u5206\u7ec4\u4fe1\u606f\uff1a[" + nGroupId + "]\uff01");
        }
        int nWorkFlowId = oGroup.getWorkFlow();
        Flow oResult = null;
        if (nWorkFlowId < 0) {
            logger.debug((Object)("\u8be5\u5206\u7ec4" + nGroupId + "\uff1a\u8bbe\u7f6e\u4e0d\u8d70\u5ba1\u6838\u5de5\u4f5c\u6d41\uff01"));
            return null;
        }
        if (nWorkFlowId == 0) {
            logger.debug((Object)("\u5206\u7ec4\u672a\u5b9a\u5236\u5de5\u4f5c\u6d41\uff1a" + nGroupId + ", \u73b0\u8fd4\u56de\u9ed8\u8ba4\u5de5\u4f5c\u6d41\uff01"));
            oResult = this.queryDefaultWorkFlow(_oContext);
        } else {
            oResult = Flow.findById(nWorkFlowId);
            if (oResult == null) {
                throw new WCMException("\u83b7\u53d6\u5206\u7ec4\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41\u5ba1\u6838\u4fe1\u606f\u4e3a\u7a7a\uff01\u5206\u7ec4ID:[" + nGroupId + "]\uff0c\u5206\u7ec4\u5bf9\u5e94\u7684\u5de5\u4f5c\u6d41ID\uff1a[" + nWorkFlowId + "]");
            }
        }
        if (oResult != null) {
            String sWorkFlowIds = ConfigServer.getServer().getSysConfigValue("WORKFLOWS_FOR_SCM", "");
            String[] pWorkFlowId = sWorkFlowIds.split(",");
            for (int i = 0; i < pWorkFlowId.length; ++i) {
                int nCurrWorkFlowId = -1;
                try {
                    nCurrWorkFlowId = Integer.parseInt(pWorkFlowId[i]);
                }
                catch (Exception e) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u5e8f\u5217\u5b58\u5728\u9519\u8bef\uff01\u9519\u8bef\u5de5\u4f5c\u6d41ID\uff1a[" + pWorkFlowId[i] + "]"));
                    continue;
                }
                if (nCurrWorkFlowId == -1) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u5e8f\u5217\u5b58\u5728\u9519\u8bef\uff01\u9519\u8bef\u5de5\u4f5c\u6d41ID\uff1a[" + pWorkFlowId[i] + "]"));
                    continue;
                }
                Flow oCurrFlow = Flow.findById(nCurrWorkFlowId);
                if (oCurrFlow == null) {
                    logger.error((Object)("\u7528\u6237\u914d\u7f6e\u7684SCM\u5de5\u4f5c\u6d41ID\u5e8f\u5217\u5b58\u5728\u9519\u8bef\uff01\u9519\u8bef\u5de5\u4f5c\u6d41ID\uff1a[" + pWorkFlowId[i] + "]"));
                    continue;
                }
                if (oResult.getId() != oCurrFlow.getId()) continue;
                return oResult;
            }
        }
        return null;
    }

    public void setWorkFlowForGroup(MethodContext _oMethodContext) throws Exception {
        Flow oCurrFlow;
        int nGroupID = _oMethodContext.getValue("SCMGroupId", 0);
        SCMGroup oSCMGroup = SCMGroup.findById(nGroupID);
        if (oSCMGroup == null) {
            throw new WCMException("\u60a8\u8bbe\u7f6e\u5de5\u4f5c\u6d41\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff01ID=\u3010" + nGroupID + "\u3011");
        }
        if (!SCMAuthServer.hasRight(this.getCurrUser(), oSCMGroup, 9)) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u5206\u7ec4\u7ba1\u7406\u4eba\u5458\uff0c\u4e0d\u80fd\u4fee\u6539SCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        int nWorkFlowId = _oMethodContext.getValue("WorkFlowId", 0);
        SCMGroup oGroup = SCMGroup.findById(nGroupID);
        if (oGroup == null) {
            throw new WCMException("\u67e5\u627e\u5230\u7684\u5206\u7ec4\u4fe1\u606f\u4e3a\u7a7a\uff01[" + nGroupID + "]");
        }
        if (nWorkFlowId > 0 && (oCurrFlow = Flow.findById(nWorkFlowId)) == null) {
            throw new WCMException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5ba1\u6838\u5de5\u4f5c\u6d41\uff01\u5206\u7ec4ID[" + nGroupID + "]&\u5de5\u4f5c\u6d41ID[" + nWorkFlowId + "]");
        }
        User oCurrUser = this.getCurrUser();
        if (oGroup.canEdit(oCurrUser)) {
            oGroup.validCanEditAndLock(oCurrUser);
        }
        try {
            oGroup.setWorkFlow(nWorkFlowId);
            oGroup.save();
        }
        catch (WCMException _oException) {
            logger.error((Object)_oException.getMessage());
            throw _oException;
        }
        finally {
            oGroup.unlock();
        }
    }

    public SCMGroups queryCustomizedGroups(MethodContext _oContext) throws Exception {
        if (!SCMAuthServer.isGroupAdminOfSCM(this.getCurrUser())) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u7528\u6237\uff0c\u4e0d\u80fd\u67e5\u770bSCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "WORKFLOW != ?", "");
        oFilter.addSearchValues(0);
        SCMGroups oResults = SCMGroups.openWCMObjs(this.getCurrUser(), oFilter);
        return oResults;
    }

    public SCMGroups queryUnCustomizedGroups(MethodContext _oContext) throws Exception {
        if (!SCMAuthServer.isGroupAdminOfSCM(this.getCurrUser())) {
            throw new WCMException("\u5f53\u524d\u7528\u6237\u4e0d\u662fSCM\u7528\u6237\uff0c\u4e0d\u80fd\u67e5\u770bSCM\u5de5\u4f5c\u6d41\u914d\u7f6e\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "WORKFLOW = ?", "");
        oFilter.addSearchValues(0);
        SCMGroups oResults = SCMGroups.openWCMObjs(this.getCurrUser(), oFilter);
        return oResults;
    }

    public boolean isAuditorOfSCM(MethodContext _oContext) throws WCMException {
        if (!SCMAuthServer.isStartSCM()) {
            logger.debug((Object)"\u65e0\u6cd5\u8bbf\u95ee\uff01\u672a\u7533\u8bf7SCM\u9009\u4ef6\u6ce8\u518c\u7801\uff01");
            return false;
        }
        User oCurrUser = ContextHelper.getLoginUser();
        return SCMAuthServer.isAuditorOfSCM(oCurrUser);
    }

    private User getCurrUser() {
        return ContextHelper.getLoginUser();
    }

    public IFlowContent[] queryFlowContentsDoneByUser(MethodContext _oContext) throws WCMException {
        int nUserId = _oContext.getValue("UserId", 0);
        if (nUserId == 0) {
            throw new WCMException("\u8bf7\u8f93\u5165\u5408\u6cd5\u7528\u6237ID\uff01");
        }
        User oUser = User.findById(nUserId);
        if (oUser == null) {
            throw new WCMException("\u60a8\u8bf7\u6c42\u7684\u7528\u6237[" + nUserId + "]\u4e0d\u5b58\u5728\uff01");
        }
        String sWhere = "PostUser=? and flag <> 0 and ParentId=0 and isObjDeleted <> 1 and ObjType = 1844552626";
        WCMFilter oFilter = new WCMFilter("WCMFlowDoc", sWhere, "FLOWDOCID DESC", "distinct OBJID,FLOWDOCID");
        oFilter.addSearchValues(oUser.getName());
        Connection oConn = null;
        Statement oPreStmt = null;
        ResultSet rsData = null;
        IFlowContent[] pContents = null;
        ArrayList<IFlowContent> oResult = new ArrayList<IFlowContent>();
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null) {
            throw new WCMException(10, I18NMessage.get(BaseObjs.class, "BaseObjs.label30", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BaseObjs.class, "BaseObjs.label31", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        try {
            int nCount = currDBManager.sqlExecuteCountQuery(oFilter);
            oConn = currDBManager.getConnection();
            oPreStmt = oConn.prepareStatement(oFilter.toSQL());
            List listSearchValues = oFilter.getSearchValues();
            DBManager.setParameters((PreparedStatement)oPreStmt, listSearchValues);
            rsData = oPreStmt.executeQuery();
            int nPageSize = _oContext.getPageSize();
            int nPageIndex = _oContext.getPageIndex();
            int nStartIndex = (nPageIndex - 1) * nPageSize;
            int nEndIndex = nStartIndex + nPageSize >= nCount ? nCount : nStartIndex + nPageSize;
            int nIndex = 0;
            while (rsData.next()) {
                if (nIndex < nStartIndex) {
                    oResult.add(null);
                    ++nIndex;
                    continue;
                }
                if (nIndex >= nEndIndex) break;
                ++nIndex;
                int scmmcid = rsData.getInt("OBJID");
                oResult.add(FlowContentFactory.makeFlowContent(1844552626, scmmcid));
            }
            rsData.close();
            for (int i = nIndex; i < nCount; ++i) {
                oResult.add(null);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(BaseObjs.class, "BaseObjs.label11", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n" + oFilter, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(BaseObjs.class, "BaseObjs.label10", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", ex);
        }
        finally {
            try {
                if (oPreStmt != null) {
                    oPreStmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (oConn != null) {
                currDBManager.freeConnection(oConn);
            }
        }
        pContents = new IFlowContent[oResult.size()];
        oResult.toArray(pContents);
        return pContents;
    }

    public SCMCheckedMicroContents queryCheckedMicrocontent(MethodContext _oContext) {
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser == null) {
            logger.error((Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e3a\u7a7a\uff01");
            return null;
        }
        int nPageSize = _oContext.getValue("PageSize", 10);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        CPager pager = new CPager();
        pager.setPageSize(nPageSize);
        pager.setCurrentPageIndex(nPageIndex);
        SCMCheckedMicroContents tempCheckedMicros = new SCMCheckedMicroContents();
        try {
            _oContext.setValue("UserId", loginUser.getId());
            IFlowContent[] oResult = this.queryFlowContentsDoneByUser(_oContext);
            if (oResult == null) {
                return null;
            }
            int nSize = oResult.length;
            pager.setItemCount(nSize);
            ArrayList<IFlowContent> lstTempContents = new ArrayList<IFlowContent>();
            int nCurrCount = 0;
            for (int i = pager.getFirstItemIndex() - 1; i < nSize; ++i) {
                if (oResult[i] == null) continue;
                lstTempContents.add(oResult[i]);
                if (++nCurrCount >= pager.getPageSize()) break;
            }
            IFlowContent[] pContents = new IFlowContent[lstTempContents.size()];
            int nIndex = 0;
            Iterator iter = lstTempContents.iterator();
            while (iter.hasNext()) {
                pContents[nIndex++] = (IFlowContent)iter.next();
            }
            return this.setValue(pContents, _oContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return tempCheckedMicros;
        }
    }

    public SCMCheckedMicroContents queryCheckingMicrocontent(MethodContext _oContext) {
        User loginUser = ContextHelper.getLoginUser();
        if (loginUser == null) {
            logger.error((Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e3a\u7a7a\uff01");
            return null;
        }
        int nPageSize = _oContext.getValue("PageSize", 10);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        IFlowContent[] oResult = null;
        try {
            CPager pager = new CPager();
            pager.setPageSize(nPageSize);
            pager.setCurrentPageIndex(nPageIndex);
            QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
            queryFlowDocContext.setCurrUser(loginUser);
            queryFlowDocContext.setPager(pager);
            queryFlowDocContext.setContentType(1844552626);
            IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            oResult = m_oFlowServer.getFlowContentsOfUser(queryFlowDocContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (oResult == null) {
            return null;
        }
        return this.setValue(oResult, _oContext);
    }

    private SCMCheckedMicroContents setValue(IFlowContent[] oResult, MethodContext _oContext) {
        User loginUser = ContextHelper.getLoginUser();
        SCMCheckedMicroContents tempCheckedMicros = new SCMCheckedMicroContents();
        int nTotalNum = oResult.length;
        int nPageSize = _oContext.getValue("PageSize", 10);
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        CPager pager = new CPager();
        pager.setItemCount(nTotalNum);
        pager.setPageSize(nPageSize);
        pager.setCurrentPageIndex(nPageIndex);
        int nPageCount = nTotalNum % nPageSize == 0 ? nTotalNum / nPageSize : nTotalNum / nPageSize + 1;
        int nStart = (nPageIndex - 1) * nPageSize;
        int nEnd = nTotalNum == 0 ? 0 : (nPageCount == nPageIndex ? nTotalNum : nPageIndex * nPageSize);
        try {
            for (int i = nStart; i < nEnd; ++i) {
                SCMCheckedMicroContent tempMicro;
                block22: {
                    if (i >= nTotalNum || oResult[i] == null || !(oResult[i] instanceof FlowContentSCMMicroContentImpl)) continue;
                    tempMicro = new SCMCheckedMicroContent();
                    FlowContentSCMMicroContentImpl oCurrFlowContent = null;
                    FlowDoc oProcessAction = null;
                    oCurrFlowContent = (FlowContentSCMMicroContentImpl)oResult[i];
                    SCMMicroContent oCurrSCMMicroContent = (SCMMicroContent)oCurrFlowContent.getSubstance();
                    if (oCurrSCMMicroContent == null) continue;
                    int nGroupId = oCurrSCMMicroContent.getGroupId();
                    SCMGroup oCurrGroup = SCMGroup.findById(nGroupId);
                    if (oCurrGroup == null) {
                        logger.error((Object)("\u5fae\u535a\u5f85\u53d1\u5e03\u7684\u5206\u7ec4\u4e0d\u5b58\u5728\uff01[\u5206\u7ec4ID=" + nGroupId + "]"));
                        continue;
                    }
                    int nCurrContentId = oCurrSCMMicroContent.getId();
                    String sPassedTime = CMyDateTime.getStr(oCurrSCMMicroContent.getReviewTime(), "yyyy-MM-dd HH:mm:ss");
                    IFlowServer oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
                    FlowDocs oFlowDocsResult = oFlowServer.getFlowDocs(oCurrFlowContent, null);
                    tempMicro.setAuditMessage(oFlowDocsResult);
                    String[] pAccountIds = oCurrSCMMicroContent.getPublishAccountIds().split(",");
                    SCMMicroContent oSCMMicroContent = SCMMicroContent.findById(nCurrContentId);
                    if (oSCMMicroContent == null) {
                        throw new WCMException("\u5fae\u535a\u4e0d\u5b58\u5728\uff01[ID=" + nCurrContentId + "]");
                    }
                    ISCMMicroContentMgr m_oSCMMicroContentMgr = (ISCMMicroContentMgr)DreamFactory.createObjectById("ISCMMicroContentMgr");
                    Accounts oPostedAccounts = m_oSCMMicroContentMgr.findPostedAccounts(oSCMMicroContent);
                    if (oPostedAccounts == null) {
                        throw new WCMException("\u83b7\u53d6\u5fae\u535a\u53d1\u5e03\u5230\u7684\u8d26\u53f7\u5931\u8d25\uff0c\u5fae\u535aid=[" + nCurrContentId + "]");
                    }
                    int nSize = oFlowDocsResult.size();
                    for (int j = 0; j < nSize; ++j) {
                        FlowDoc oCurrFlowDoc = (FlowDoc)oFlowDocsResult.getAt(j);
                        if (oCurrFlowDoc == null) continue;
                        User oPostUser = oCurrFlowDoc.getPostUser();
                        if (oProcessAction != null || oPostUser.getId() != loginUser.getId()) continue;
                        oProcessAction = oCurrFlowDoc;
                    }
                    int nGropId = oCurrSCMMicroContent.getGroupId();
                    SCMGroup oGroup = null;
                    if (nGropId > 0) {
                        oGroup = SCMGroup.findById(nGropId);
                    }
                    if (oGroup != null && oGroup.getWorkFlow() < 1) {
                        tempMicro.setAuditStatus("-10");
                    } else {
                        tempMicro.setAuditStatus("" + oCurrSCMMicroContent.getStatusId());
                    }
                    tempMicro.setAuditStatus("" + oCurrSCMMicroContent.getStatusId());
                    tempMicro.setAuditTime(sPassedTime);
                    if (oCurrSCMMicroContent != null) {
                        tempMicro.setsMicrocontent(oCurrSCMMicroContent);
                    }
                    tempMicro.setbHasReMC(oCurrSCMMicroContent.isRetweeted());
                    Accounts oPublishingAccounts = Accounts.createNewInstance(loginUser);
                    Accounts oPublishedAccounts = Accounts.createNewInstance(loginUser);
                    for (int index = 0; index < pAccountIds.length; ++index) {
                        Account oTempAccount = Account.findById(Integer.parseInt(pAccountIds[index]));
                        if (oTempAccount == null || oTempAccount.getStatus() <= 0) continue;
                        if (oPostedAccounts.indexOf(Integer.valueOf(pAccountIds[index])) < 0) {
                            oPublishingAccounts.addElement(oTempAccount);
                            continue;
                        }
                        oPublishedAccounts.addElement(oTempAccount);
                    }
                    tempMicro.setnPubGroupId(oCurrGroup.getId());
                    tempMicro.setsParentPath(oCurrGroup.getParentPath());
                    tempMicro.setsPubGroup(oCurrGroup.getGroupName());
                    ISCMAccountMgr m_oSCMAccountMgr = (ISCMAccountMgr)DreamFactory.createObjectById("ISCMAccountMgr");
                    Accounts oAllAccountsInGroup = m_oSCMAccountMgr.findAccountsByGroup(oGroup);
                    tempMicro.setAllAccountsInGroup(oAllAccountsInGroup);
                    tempMicro.setpPubAccounts(oPublishedAccounts);
                    tempMicro.setpWaitPubAccounts(oPublishingAccounts);
                    tempMicro.setpSCMMCCrtime(oCurrSCMMicroContent.getCrTime().toString());
                    if (oCurrSCMMicroContent.isRetweeted()) {
                        String sMicroContentId = oCurrSCMMicroContent.getRetweetedID();
                        Accounts oPublishAccounts = Accounts.findByIds(loginUser, oCurrSCMMicroContent.getPublishAccountIds());
                        int nPublishSize = oPublishAccounts.size();
                        for (int k = nPublishSize - 1; k >= 0; --k) {
                            Account oAccount = (Account)oPublishAccounts.getAt(k);
                            if (oAccount == null) continue;
                            tempMicro.setPlat(oAccount.getPlatform());
                            boolean hasRight = false;
                            try {
                                hasRight = SCMAuthServer.hasRight(oCurrSCMMicroContent.getCrUser(), oAccount, 44);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (hasRight) continue;
                            oPublishAccounts.remove(oAccount, false);
                        }
                        if (oPublishAccounts != null && oPublishAccounts.size() > 0) {
                            Account oAccountPlatf = (Account)oPublishAccounts.getAt(0);
                            if (oAccountPlatf == null) {
                                throw new NullPointerException("\u83b7\u53d6\u5230\u7684Account\u4e3a\u7a7a\uff01");
                            }
                            try {
                                MicroContent oMicroResult = m_oSCMMicroContentMgr.findById(oAccountPlatf, sMicroContentId);
                                tempMicro.setReMicrocontent(oMicroResult);
                            }
                            catch (Exception e) {
                                if (e instanceof WeiboException && ((WeiboException)((Object)e)).getErrorCode() != 20101) {
                                    throw e;
                                }
                                if (!(e instanceof TBlogException) || ((TBlogException)((Object)e)).getMessageCode() == 40402) break block22;
                                throw e;
                            }
                        }
                    }
                }
                tempCheckedMicros.addMicroContent(tempMicro);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempCheckedMicros;
    }
}

