/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.util.CMyString;
import java.util.ArrayList;
import java.util.List;
import weibo4j.http.Response;
import weibo4j.model.Status;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class MySinaStatus
extends Status {
    private List m_listThumbnailPics = new ArrayList();
    private List m_listBMiddlePics = new ArrayList();
    private List m_listOriginalPics = new ArrayList();

    public MySinaStatus(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.constructJson(json);
    }

    private void constructJson(JSONObject json) throws WeiboException {
        try {
            JSONArray oPicUrls = json.getJSONArray("pic_urls");
            int length = oPicUrls.length();
            for (int i = 0; i < length; ++i) {
                JSONObject oItem = oPicUrls.getJSONObject(i);
                String sThumbnail_pic = oItem.getString("thumbnail_pic");
                this.m_listThumbnailPics.add(sThumbnail_pic);
                String sBmiddle_pic = oItem.getString("bmiddle_pic");
                if (i == 0 && CMyString.isEmpty((String)sBmiddle_pic)) {
                    sBmiddle_pic = this.getBmiddlePic();
                }
                this.m_listBMiddlePics.add(sBmiddle_pic);
                String sOriginal_pic = oItem.getString("original_pic");
                if (i == 0 && CMyString.isEmpty((String)sOriginal_pic)) {
                    sOriginal_pic = this.getOriginalPic();
                }
                this.m_listOriginalPics.add(sOriginal_pic);
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), (Exception)((Object)je));
        }
    }

    public List getOriginalPics() {
        return this.m_listOriginalPics;
    }

    public List getBmiddlePics() {
        return this.m_listBMiddlePics;
    }

    public List getThumbnailPics() {
        return this.m_listThumbnailPics;
    }
}

