/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractUserMgr;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.T163ErrorMessage;
import com.trs.scm.sdk.util.T163ObjectUtil;
import org.apache.log4j.Logger;
import t4j.TBlog;
import t4j.data.User;

public class T163UserMgr
extends AbstractUserMgr {
    private static Logger logger = Logger.getLogger(T163UserMgr.class);
    private OAuth auth;
    private TBlog tBlog;

    public T163UserMgr(OAuth auth) {
        super(auth);
        this.auth = auth;
        this.tBlog = new TBlog();
        this.tBlog.setToken(auth.getOAuth_token(), auth.getOAuth_token_secret());
    }

    @Override
    public MicroUser findUserById(String userId) throws Exception {
        if (userId == null || userId.trim().length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7528\u6237ID\u4e3a\u7a7a\uff01");
        }
        MicroUser oResult = null;
        User user = null;
        try {
            user = this.tBlog.showUser(Long.parseLong(userId));
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        try {
            oResult = T163ObjectUtil.constructMicroUser(user);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroUser\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroUser\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroUser findUserByNickName(String nickName) throws Exception {
        if (nickName == null || nickName.trim().length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7528\u6237\u4e2a\u6027\u7f51\u5740\u4e3a\u7a7a\uff01");
        }
        MicroUser oResult = null;
        User user = null;
        try {
            user = this.tBlog.showUser(nickName);
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        try {
            oResult = T163ObjectUtil.constructMicroUser(user);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroUser\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroUser\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public MicroUser showUser() throws Exception {
        MicroUser oResult = null;
        User user = null;
        try {
            user = this.tBlog.verifyCredentials();
        }
        catch (Exception e) {
            CMyException oCMyException = T163ErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        try {
            oResult = T163ObjectUtil.constructMicroUser(user);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroUser\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroUser\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }
}

