/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.GroupAccount;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroups;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMMicroContents;
import com.trs.scm.publish.domain.SCMMCPublishServer;
import com.trs.scm.publish.domain.SCMMCPublishTaskCacheMgr;
import com.trs.scm.publish.persistent.SCMMCPublishTask;
import com.trs.scm.publish.persistent.SCMMCPublishTasks;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SCMGroupAccountCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(SCMGroupAccountCacheMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private final String kEY_ACCOUNTS = "Accounts";
    private final String kEY_SCMGROUPS = "SCMGroups";
    private static int MAX_CACHE_SIZE = 100;

    private String getKeyAccounts(String key) {
        if (key == null) {
            return null;
        }
        return SCMGroupAccountCacheMgr.class.getName() + "." + key;
    }

    private String getKeyAccounts() {
        return SCMGroupAccountCacheMgr.class.getName() + "." + "Accounts";
    }

    private String getKeySCMGroups(String key) {
        if (key == null) {
            return null;
        }
        return SCMGroupAccountCacheMgr.class.getName() + "." + key;
    }

    private String getKeySCMGroups() {
        return SCMGroupAccountCacheMgr.class.getName() + "." + "SCMGroups";
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean init() throws WCMException {
        return this.doStart();
    }

    public SCMGroups querySCMGroupsOfAccount(int _nAccountId) throws WCMException {
        List<Object> ids;
        SCMGroups oSCMGroups;
        if (cache.exists(this.getKeySCMGroups()).booleanValue() && (oSCMGroups = SCMGroups.findByIds(null, StringUtils.join(ids = cache.lrange(this.getKeySCMGroups(Integer.toString(_nAccountId)), 0L, -1L), (String)","))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Load Data from Cache, the releated group size for account [" + _nAccountId + "] is: " + oSCMGroups.size()));
            }
            return oSCMGroups;
        }
        SCMGroups oGroups = this.loadSCMGroupsOfAccount(_nAccountId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No releated Data in Cache, Load data from DB, the releated group size for account [" + _nAccountId + "] is: " + oGroups == null ? 0 : oGroups.size()));
        }
        this.basesObj2Ids(oGroups, this.getKeySCMGroups(Integer.toString(_nAccountId)));
        return oGroups;
    }

    public Accounts queryAccountsOfSCMGroup(int _nSCMGroupId) throws WCMException {
        List<Object> ids;
        Accounts oAccounts;
        if (cache.exists(this.getKeyAccounts()).booleanValue() && (oAccounts = Accounts.findByIds(null, StringUtils.join(ids = cache.lrange(this.getKeyAccounts(Integer.toString(_nSCMGroupId)), 0L, -1L), (String)","))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Load Data from Cache, the accouts size for group [" + _nSCMGroupId + "] is: " + oAccounts.size()));
            }
            return oAccounts;
        }
        Accounts oAccounts2 = this.loadAccountsOfSCMGroup(_nSCMGroupId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No releated Data in Cache, Load data from DB, the accounts size for group [" + _nSCMGroupId + "] is: " + oAccounts2 == null ? 0 : oAccounts2.size()));
        }
        this.basesObj2Ids(oAccounts2, this.getKeyAccounts(Integer.toString(_nSCMGroupId)));
        return oAccounts2;
    }

    private synchronized boolean doStart() throws WCMException {
        if (cache.exists(this.getKeyAccounts()).booleanValue() && cache.exists(this.getKeySCMGroups()).booleanValue()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"init GroupAccountsCache & AccountGroupCache ....");
        }
        if (!cache.exists(this.getKeyAccounts()).booleanValue()) {
            this.initGroupAccountsCache();
        }
        if (!cache.exists(this.getKeySCMGroups()).booleanValue()) {
            this.initAccountGroupsCache();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"GroupAccountsCache & AccountGroupCache are inited....");
        }
        return true;
    }

    private void initAccountGroupsCache() throws WCMException {
        WCMFilter oFilter = new WCMFilter("", "STATUS = ?", "");
        oFilter.addSearchValues(1);
        Accounts oAccounts = Accounts.openWCMObjs(null, oFilter);
        int nSize = oAccounts.size();
        for (int i = 0; i < MAX_CACHE_SIZE && i < nSize; ++i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount == null) continue;
            int nAccountId = oAccount.getId();
            SCMGroups oGroups = this.loadSCMGroupsOfAccount(nAccountId);
            String sKey = Integer.toString(nAccountId);
            this.basesObj2Ids(oGroups, this.getKeySCMGroups(sKey));
        }
        cache.set(this.getKeySCMGroups(), "true");
    }

    private void basesObj2Ids(CMSBaseObjs oGroups, String key) {
        cache.clear(key);
        if (oGroups != null) {
            int size = oGroups.size();
            for (int i = 0; i < size; ++i) {
                BaseObj obj = oGroups.getAt(i);
                Integer id = obj.getId();
                cache.rpush(key, id);
            }
        }
    }

    private void initGroupAccountsCache() throws WCMException {
        SCMGroups oGroups = SCMGroups.openWCMObjs(null, null);
        int nSize = oGroups.size();
        for (int i = 0; i < MAX_CACHE_SIZE && i < nSize; ++i) {
            SCMGroup oGroup = (SCMGroup)oGroups.getAt(i);
            if (oGroup == null) continue;
            int nGroupId = oGroup.getId();
            Accounts oAccounts = this.loadAccountsOfSCMGroup(nGroupId);
            String sKey = Integer.toString(nGroupId);
            this.basesObj2Ids(oAccounts, this.getKeyAccounts(sKey));
        }
        cache.set(this.getKeyAccounts(), "true");
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.doStart();
    }

    private void ensureCacheLoaded() throws WCMException {
        if (!cache.exists(this.getKeySCMGroups()).booleanValue() || !cache.exists(this.getKeyAccounts()).booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ensure the SCM Cache is loaded! init the Cahce....");
            }
            this.doStart();
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!this.isListening(_oObjAdded)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Return ----- Not the listening object! ObjectType - [" + _oObjAdded.getWCMType() + "]"));
            }
            return;
        }
        this.ensureCacheLoaded();
        GroupAccount oGroupAccount = (GroupAccount)_oObjAdded;
        int nAccountId = oGroupAccount.getAccountId();
        int nSCMGroupId = oGroupAccount.getSCMGroupId();
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null || oAccount.getStatus() == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The adding Account is Null or be deleted.....");
            }
            return;
        }
        String sAccountId = Integer.toString(nAccountId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"put the adding Account and its belonging Groups into Cache...");
            logger.debug((Object)("The adding Account is: " + nAccountId + "...."));
        }
        cache.rpush(this.getKeySCMGroups(sAccountId), nSCMGroupId);
        String sSCMGroupId = Integer.toString(nSCMGroupId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"put the modified Group and its Accounts into Cache...");
            logger.debug((Object)("The modified Group is: " + nSCMGroupId + "...."));
        }
        cache.rpush(this.getKeyAccounts(sSCMGroupId), nAccountId);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!this.isListening(_oObjDeleted)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Return ----- Not the listening object! ObjectType - [" + _oObjDeleted.getWCMType() + "]"));
            }
            return;
        }
        this.ensureCacheLoaded();
        GroupAccount oGroupAccount = (GroupAccount)_oObjDeleted;
        int nAccountId = oGroupAccount.getAccountId();
        int nSCMGroupId = oGroupAccount.getSCMGroupId();
        String sAccountId = Integer.toString(nAccountId);
        long resultGroup = cache.lrem(this.getKeySCMGroups(sAccountId), 0L, nSCMGroupId);
        if (resultGroup > 0L) {
            logger.debug((Object)("Removing the deleting Group [" + nSCMGroupId + "] from Cache successfully...."));
            logger.debug((Object)"Put the updated Groups into Cache.....");
        } else {
            logger.error((Object)("Removing Group [" + nSCMGroupId + "] from Cache failed..."));
        }
        String sSCMGroupId = Integer.toString(nSCMGroupId);
        long resultAccount = cache.lrem(this.getKeyAccounts(sSCMGroupId), 0L, nAccountId);
        if (resultAccount > 0L) {
            logger.debug((Object)("Removing the deleting Account [" + nAccountId + "] from Cache successfully...."));
            logger.debug((Object)"Put the updated oAccounts into Cache.....");
        } else {
            logger.error((Object)("Removing Account [" + nAccountId + "] from Cache failed..."));
        }
        String sWhere = "ACCOUNTID = ?";
        String sFrom = "XWCMSCMMCPUBLISHTASK";
        WCMFilter oFilter = new WCMFilter(sFrom, sWhere, "");
        oFilter.addSearchValues(nAccountId);
        SCMMCPublishTasks oPublishingTasks = SCMMCPublishTasks.openWCMObjs(User.getSystem(), oFilter);
        if (oPublishingTasks != null && oPublishingTasks.size() > 0) {
            SCMMCPublishTaskCacheMgr oCacheMgr = SCMMCPublishTaskCacheMgr.getInstance();
            SCMMCPublishServer oPublishServer = SCMMCPublishServer.getInstance();
            SCMMicroContents oMCs = null;
            try {
                oMCs = oCacheMgr.queryUnpublishedSCMMCs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SCMMCPublishTask oCurrPublishTask = null;
            int nCurrMCId = 0;
            int nCurrGroupId = 0;
            for (int i = oPublishingTasks.size() - 1; i >= 0; --i) {
                oCurrPublishTask = (SCMMCPublishTask)oPublishingTasks.getAt(i);
                if (oCurrPublishTask == null || oMCs.indexOf(nCurrMCId = oCurrPublishTask.getSCMMCID()) < 0 || (nCurrGroupId = ((SCMMicroContent)oMCs.getAt(oMCs.indexOf(nCurrMCId))).getGroupId()) != nSCMGroupId) continue;
                oCurrPublishTask.delete(User.getSystem());
            }
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (this.isListeningForAccount(_oObjModified)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"is Listening For Account Modifying ...");
            }
            if (!cache.exists(this.getKeySCMGroups()).booleanValue() || !cache.exists(this.getKeyAccounts()).booleanValue()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Both the caches are null, nothing could be modified, return...");
                }
                return;
            }
            Account oAccount = (Account)_oObjModified;
            int nAccountId = oAccount.getId();
            SCMGroups oGroups = this.loadSCMGroupsOfAccount(nAccountId);
            if (oGroups == null || oGroups.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The related groups to Account [" + nAccountId + "] is null..."));
                }
                return;
            }
            for (int i = 0; i < oGroups.size(); ++i) {
                SCMGroup otSCMGroup = (SCMGroup)oGroups.getAt(i);
                if (otSCMGroup == null) continue;
                int nSCMGroupId = otSCMGroup.getId();
                String sSCMGroupId = Integer.toString(nSCMGroupId);
                Accounts oAccounts = this.loadAccountsOfSCMGroup(nSCMGroupId);
                if (oAccounts == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("the Accounts related to Group [" + nSCMGroupId + "] is null...."));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("update the Group [" + sSCMGroupId + "] and its belonging accounts, accounts' size = " + oAccounts.size()));
                }
                this.basesObj2Ids(oAccounts, this.getKeyAccounts(sSCMGroupId));
            }
        } else if (_oObjModified != null && _oObjModified instanceof SCMGroup) {
            int nSCMGroupId;
            Accounts oAccounts;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"is Listening For SCMGroup Modifying ...");
            }
            if ((oAccounts = this.loadAccountsOfSCMGroup(nSCMGroupId = _oObjModified.getId())) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("the modified Group [" + nSCMGroupId + "] has zero Accounts"));
                }
                return;
            }
            int nSize = oAccounts.size();
            for (int i = 0; i < nSize; ++i) {
                Account oTempAccount = (Account)oAccounts.getAt(i);
                if (oTempAccount == null) continue;
                int nAccountId = oTempAccount.getId();
                SCMGroups oTempGroups = this.loadSCMGroupsOfAccount(nAccountId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("update the Account [" + nAccountId + "] & its belonged SCMGroups, Groups' size - " + oTempGroups.size()));
                }
                this.basesObj2Ids(oTempGroups, this.getKeySCMGroups(Integer.toString(nAccountId)));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Return ----- Not the listening object! ObjectType - [" + _oObjModified.getWCMType() + "]"));
        }
    }

    private boolean isListening(BaseObj _oBaseObj) {
        return _oBaseObj != null && _oBaseObj instanceof GroupAccount;
    }

    private boolean isListeningForAccount(BaseObj _oBaseObj) {
        return _oBaseObj != null && _oBaseObj instanceof Account;
    }

    private SCMGroups loadSCMGroupsOfAccount(int _nAccountId) throws WCMException {
        String sWhere = "ACCOUNTID = ?";
        String sFrom = "XWCMGROUPACCOUNT";
        WCMFilter oFilter = new WCMFilter(sFrom, sWhere, "");
        oFilter.addSearchValues(_nAccountId);
        SCMGroups oGroups = SCMGroups.openWCMObjs(null, oFilter);
        return oGroups;
    }

    private Accounts loadAccountsOfSCMGroup(int _nSCMGroupId) throws WCMException {
        String sWhere = "STATUS = ? and exists(select 1 from XWCMGROUPACCOUNT where XWCMGROUPACCOUNT.ACCOUNTID = XWCMACCOUNT.ACCOUNTID and SCMGROUPID = ?)";
        WCMFilter oFilter = new WCMFilter("XWCMACCOUNT", sWhere, "");
        oFilter.addSearchValues(1);
        oFilter.addSearchValues(_nSCMGroupId);
        Accounts oAccounts = Accounts.openWCMObjs(null, oFilter);
        return oAccounts;
    }
}

