/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.MyPlugin;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.scm.domain.ISCMAccountMgr;
import com.trs.scm.domain.ISCMGroupMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroupUsers;
import com.trs.scm.persistent.SCMGroups;

public class SCMAuthServer {
    public static final int SCMGROUP_MIN_INDEX = 1;
    public static final int SCMGROUP_MAX_INDEX = 20;
    public static final int SCMGROUP_ADDEDIT = 1;
    public static final int SCMGROUP_DELETE = 2;
    public static final int SCMGROUP_REMOVE_ACCOUNT = 3;
    public static final int SCMGROUP_ADD_ACCOUNT = 4;
    public static final int SCMGROUP_QUERY_ACCOUNTS = 5;
    public static final int SCMGROUP_BROWSE = 6;
    public static final int SCMGROUP_ADDUSER = 7;
    public static final int SCMGROUP_ADDGROUPADMIN = 8;
    public static final int SCMGROUP_ADDEDITWORKFLOW = 9;
    public static final int SCMRIGHT_MIN_INDEX = 21;
    public static final int SCMRIGHT_MAX_INDEX = 30;
    public static final int SCMRIGHT_SET = 21;
    public static final int SCMRIGHT_DELETE = 22;
    public static final int SCMRIGHT_BROWSE = 23;
    public static final int SCMRIGHT_AUDIT = 24;
    public static final int ACCOUNT_MIN_INDEX = 31;
    public static final int ACCOUNT_MAX_INDEX = 50;
    public static final int ACCOUNT_ADD = 41;
    public static final int ACCOUNT_EDIT = 42;
    public static final int ACCOUNT_DELETE = 43;
    public static final int ACCOUNT_USE = 44;
    public static final String ENABLE_RIGHTS_AUDIT = "ENABLE_RIGHTS_AUDIT";
    public static final String RIGHTS_AUDIT_USER = "SCM_RIGHTS_AUDIT";
    public static final String SCM_ADMIN = "SCM Managers";
    private static ISCMAccountMgr m_oAccountMgr = (ISCMAccountMgr)DreamFactory.createObjectById("ISCMAccountMgr");
    private static ISCMGroupMgr m_oGroupMgr = (ISCMGroupMgr)DreamFactory.createObjectById("ISCMGroupMgr");

    public static boolean hasRight(User _oUser, CMSObj _oCMSObj, int _nRightIndex) throws Exception {
        boolean bAdministrator = SCMAuthServer.isAdminOfSCM(_oUser);
        if (bAdministrator) {
            return true;
        }
        if (_nRightIndex >= 1 && _nRightIndex <= 20) {
            SCMGroup oSCMGroup = (SCMGroup)_oCMSObj;
            return SCMAuthServer.hasRightInGroup(_oUser, oSCMGroup, _nRightIndex);
        }
        if ((_nRightIndex < 21 || _nRightIndex > 30) && _nRightIndex >= 31 && _nRightIndex <= 50) {
            Account oAccount = (Account)_oCMSObj;
            return SCMAuthServer.hasRightInAccount(_oUser, oAccount, _nRightIndex);
        }
        return false;
    }

    public static boolean hasRightInAccount(User _oUser, Account _oAccount, int _nRightIndex) throws Exception {
        if (_nRightIndex > 50 || _nRightIndex < 31) {
            throw new Exception("\u6743\u9650\u4f4d\u4e0d\u5728\u8d26\u53f7\u5bf9\u5e94\u7684\u6743\u9650\u4f4d\u4e2d\uff01");
        }
        if (_oUser == null) {
            throw new Exception("\u8981\u6821\u9a8c\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        if (_oAccount == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        if (_oAccount.getStatus() == -1) {
            throw new Exception("\u8d26\u53f7[" + _oAccount.getAccountName() + "]\u5df2\u7ecf\u4ece\u7cfb\u7edf\u4e2d\u89e3\u9664\u7ed1\u5b9a\uff01");
        }
        Accounts oAccounts = m_oAccountMgr.findAccountsForUser(_oUser);
        if (oAccounts == null) {
            return false;
        }
        return oAccounts.indexOf(_oAccount) >= 0;
    }

    public static boolean hasRightInAccount(User _oUser, Account _oAccount) throws Exception {
        return SCMAuthServer.hasRightInAccount(_oUser, _oAccount, 44);
    }

    public static boolean hasRightInGroup(User _oUser, SCMGroup _oSCMGroup, int _nRightIndex) throws Exception {
        if (_nRightIndex > 20 || _nRightIndex < 1) {
            throw new Exception("\u6743\u9650\u4f4d\u4e0d\u662f\u5206\u7ec4\u76f8\u5173\u7684\u6743\u9650\u4f4d\uff01");
        }
        if (_oUser == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        if (_oSCMGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        boolean bAdministrator = SCMAuthServer.isAdminOfSCM(_oUser);
        if (bAdministrator) {
            return true;
        }
        boolean isAdminOfGroup = SCMAuthServer.isAdminOfGroup(_oUser, _oSCMGroup);
        boolean isAdminOfSuperGroup = SCMAuthServer.isAdminOfSuperGroup(_oUser, _oSCMGroup);
        boolean isMaintainerOfGroup = SCMAuthServer.isMaintainerOfGroup(_oUser, _oSCMGroup);
        boolean isMaintainerOfSuperGroup = SCMAuthServer.isMaintainerOfSuperGroup(_oUser, _oSCMGroup);
        String sIsOpenRightConfig = ConfigServer.getServer().getSysConfigValue("ISOPENRIGHT_FOR_SCM", "false");
        switch (_nRightIndex) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                if (!isAdminOfGroup && !isAdminOfSuperGroup) break;
                return true;
            }
            case 6: {
                if (!isAdminOfGroup && !isAdminOfSuperGroup && !isMaintainerOfGroup && !isMaintainerOfSuperGroup && !SCMAuthServer.hasBrowseRightInParentGroup(_oUser, _oSCMGroup)) break;
                return true;
            }
            case 3: {
                if ("true".equals(sIsOpenRightConfig)) {
                    if (!isAdminOfGroup && !isAdminOfSuperGroup) break;
                    return true;
                }
                return true;
            }
            case 4: {
                if ("true".equals(sIsOpenRightConfig)) {
                    if (!isAdminOfGroup && !isAdminOfSuperGroup) break;
                    return true;
                }
                return true;
            }
            case 5: {
                if (!isAdminOfGroup && !isAdminOfSuperGroup && !isMaintainerOfGroup && !isMaintainerOfSuperGroup) break;
                return true;
            }
            case 2: {
                if (!isAdminOfSuperGroup) break;
                return true;
            }
        }
        return false;
    }

    public static boolean canManageSCMRights(User _oUser, int _nRightIndex) throws Exception {
        if (_nRightIndex > 30 || _nRightIndex < 21) {
            throw new Exception("\u6743\u9650\u4f4d\u4e0d\u662f\u6743\u9650\u76f8\u5173\u7684\u6743\u9650\u4f4d\uff01");
        }
        if (_oUser == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        String sEnabledRightAudit = ConfigServer.getServer().getSysConfigValue(ENABLE_RIGHTS_AUDIT, "false");
        boolean bEnabledRightAudit = "true".equalsIgnoreCase(sEnabledRightAudit);
        if (!bEnabledRightAudit) {
            return SCMAuthServer.isAdminOfSCM(_oUser);
        }
        String sUserName = _oUser.getName();
        boolean bRgihtAuditUser = RIGHTS_AUDIT_USER.equalsIgnoreCase(sUserName);
        if (_nRightIndex == 24) {
            return bRgihtAuditUser;
        }
        return SCMAuthServer.isAdminOfSCM(_oUser) || bRgihtAuditUser;
    }

    public static boolean isAdminOfSCM(User _oUser) throws WCMException {
        if (_oUser.isAdministrator()) {
            return true;
        }
        RoleMgr roleMgr = new RoleMgr();
        Roles oCurrRoles = roleMgr.getSpecialRolesOfUser(_oUser, null);
        if (oCurrRoles == null || oCurrRoles.size() == 0) {
            return false;
        }
        for (int i = 0; i < oCurrRoles.size(); ++i) {
            Role oCurrRole = (Role)oCurrRoles.getAt(i);
            String sName = oCurrRole.getName();
            if (!sName.equals(SCM_ADMIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuditorOfSCM(User _oUser) throws WCMException {
        String sSQL = "OBJTYPE = ? AND TOUSERID = ?";
        WCMFilter oFilter = new WCMFilter("", sSQL, "");
        oFilter.addSearchValues(1844552626);
        oFilter.addSearchValues(_oUser.getId());
        FlowDocs oResult = FlowDocs.openWCMObjs(_oUser, oFilter);
        return oResult != null && oResult.size() > 0;
    }

    public static boolean isGroupAdminOfSCM(User _oUser) throws Exception {
        if (SCMAuthServer.isAdminOfSCM(_oUser)) {
            return true;
        }
        ISCMGroupMgr oSCMGroupMgr = (ISCMGroupMgr)DreamFactory.createObjectById("ISCMGroupMgr");
        SCMGroups oSCMGroups = oSCMGroupMgr.getManagedGroups(_oUser);
        return oSCMGroups != null && oSCMGroups.size() > 0;
    }

    public static boolean isStartSCM() {
        CMyBitsValue bitsValue = new CMyBitsValue(MyPlugin.getPluginCode());
        return bitsValue.getBit(7);
    }

    public static Users getSCMAdmins() throws WCMException {
        WCMFilter oRoleFilter = new WCMFilter("WCMROLE", "ROLENAME = ?", "");
        oRoleFilter.addSearchValues(SCM_ADMIN);
        Roles oSCMAdminRole = Roles.openWCMObjs(null, oRoleFilter);
        if (oSCMAdminRole == null || oSCMAdminRole.size() != 1) {
            throw new WCMException("\u83b7\u53d6SCM\u7ba1\u7406\u5458\u89d2\u8272\u629b\u9519\uff01");
        }
        RoleMgr oRoleMgr = new RoleMgr();
        Users oSCMAdmins = oRoleMgr.getUsers((Role)oSCMAdminRole.getAt(0), null);
        Users oSysAdmins = Users.findAdministrators();
        for (int i = 0; i < oSysAdmins.size(); ++i) {
            if (oSCMAdmins.indexOf(oSysAdmins.getAt(i)) >= 0) continue;
            oSCMAdmins.addElement(oSysAdmins.getAt(i));
        }
        return oSCMAdmins;
    }

    public static boolean isAdminOfGroup(User _oUser, SCMGroup _oSCMGroup) throws Exception {
        if (_oUser == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        if (_oSCMGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID=? and USERID=? and ISADMIN=1", "", "");
        oFilter.addSearchValues(_oSCMGroup.getId());
        oFilter.addSearchValues(_oUser.getId());
        SCMGroupUsers oSCMGroupUsers = SCMGroupUsers.openWCMObjs(_oUser, oFilter);
        return oSCMGroupUsers.size() > 0;
    }

    public static boolean isAdminOfSuperGroup(User _oUser, SCMGroup _oSCMGroup) throws Exception {
        if (_oUser == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        if (_oSCMGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        WCMFilter oFilter = new WCMFilter("", "SCMGROUPID in (select SCMGROUPID from XWCMSCMGROUPUSER where USERID=? and ISADMIN=1)", "", "");
        oFilter.addSearchValues(_oUser.getId());
        SCMGroups oSCMGroups = SCMGroups.openWCMObjs(_oUser, oFilter);
        if (oSCMGroups == null) {
            return false;
        }
        for (int i = 0; i < oSCMGroups.size(); ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null || !SCMAuthServer.isSubGroup(oSCMGroup, _oSCMGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMaintainerOfGroup(User _oUser, SCMGroup _oSCMGroup) throws Exception {
        if (_oUser == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        if (_oSCMGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        SCMGroups oGroups = m_oGroupMgr.getManagedGroups(_oUser);
        if (oGroups == null) {
            return false;
        }
        return oGroups.indexOf(_oSCMGroup) >= 0;
    }

    public static boolean isMaintainerOfSuperGroup(User _oUser, SCMGroup _oSCMGroup) throws Exception {
        if (_oUser == null) {
            throw new Exception("\u8981\u5224\u65ad\u6743\u9650\u7684\u7528\u6237\u4e3a\u7a7a\uff01");
        }
        if (_oSCMGroup == null) {
            throw new Exception("\u6307\u5b9a\u7684\u5206\u7ec4\u4e3a\u7a7a\uff01");
        }
        SCMGroups oGroups = m_oGroupMgr.getManagedGroups(_oUser);
        if (oGroups == null) {
            return false;
        }
        for (int i = 0; i < oGroups.size(); ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oGroups.getAt(i);
            if (oSCMGroup == null || !SCMAuthServer.isSubGroup(oSCMGroup, _oSCMGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBrowseRightInParentGroup(User _oUser, SCMGroup _oSCMGroup) throws Exception {
        if (_oSCMGroup == null) {
            return false;
        }
        SCMGroups oGroups = m_oGroupMgr.getManagedGroups(_oUser);
        if (oGroups == null) {
            return false;
        }
        for (int i = 0; i < oGroups.size(); ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oGroups.getAt(i);
            if (oSCMGroup == null || !SCMAuthServer.isSubGroup(_oSCMGroup, oSCMGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubGroup(SCMGroup _oFirstSCMGroup, SCMGroup _oSCMGroup) throws Exception {
        if (_oSCMGroup == null || _oFirstSCMGroup == null) {
            return false;
        }
        for (SCMGroup oParentGroup = _oSCMGroup.getParent(); oParentGroup != null; oParentGroup = oParentGroup.getParent()) {
            if (oParentGroup.getId() != _oFirstSCMGroup.getId()) continue;
            return true;
        }
        return false;
    }

    public static String getSMASPassport() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("SMAS_LOGIN_USER_PARAMETERS", "username=###&password=###");
    }

    public static String getSMASSearchAccountName() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("SMAS_DEFAULT_SEARCH_ACCOUNTNAME", "");
    }

    public static String getSMASSearchKeyWords() throws WCMException {
        return ConfigServer.getServer().getSysConfigValue("SMAS_DEFAULT_SEARCH_KEYWORDS", "");
    }
}

