/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.publish.template;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyXMLElement;
import com.trs.infra.util.CMyXMLParser;
import java.util.List;
import java.util.Map;

public class CMyTemplateWizard {
    private static final String RES_FILE = "TRS_Tag_Template.xml";
    private static final char FIRST_CHAR = '$';
    private static final char SECOND_CHAR = '[';
    private static final char LAST_CHAR = ']';
    public static final int PARAM_TYPE_ENUMER = 10;
    public static final int PARAM_TYPE_ENUMER_EXT = 15;
    public static final int PARAM_TYPE_BOOLEAN = 20;
    public static final int PARAM_TYPE_INT = 30;
    public static final int PARAM_TYPE_TEXT = 40;
    public static final int PARAM_TYPE_LONGTEXT = 50;
    private static List LIST_TEMPLATE = null;

    public static String toTemplateCode(int _nTempId, String _sXMLString) throws WCMException {
        String sContent = CMyTemplateWizard.getTemplateContent(_nTempId);
        return CMyTemplateWizard.toTemplateCode(sContent, _sXMLString);
    }

    public static String toTemplateCode(String _sTemplateContent, String _sXMLString) throws WCMException {
        return CMyTemplateWizard.createTemplateCoding(_sTemplateContent, CMyTemplateWizard.convertToParametersMap(_sXMLString));
    }

    public static List getParameters(int _nTempId) throws Exception {
        CMyXMLElement anElement = CMyTemplateWizard.getElement(_nTempId);
        if (anElement == null) {
            throw new WCMException(152, I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label1", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + _nTempId + I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label2", "]\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\uff01"));
        }
        CMyXMLElement elParameter = anElement.getChild("Parameters");
        if (elParameter == null) {
            throw new WCMException(152, I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label3", "\u83b7\u53d6ID\u4e3a[") + _nTempId + I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label4", "]\u6a21\u677f\u7684\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff01"));
        }
        return elParameter.getChildren();
    }

    private static List getTemplateList() throws WCMException {
        if (LIST_TEMPLATE != null) {
            return LIST_TEMPLATE;
        }
        CMyXMLElement xmlElement = CMyXMLParser.fileToElement(RES_FILE);
        LIST_TEMPLATE = xmlElement.getChildren("Template");
        return LIST_TEMPLATE;
    }

    private static CMyXMLElement getElement(int _nTempId) throws WCMException {
        if (CMyTemplateWizard.getTemplateList() == null) {
            throw new WCMException(152, I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label5", "\u4ece\u8d44\u6e90\u6587\u4ef6\u4e2d\u83b7\u53d6\u6a21\u677f\u6837\u4f8b\u4ee3\u7801\u5931\u8d25\uff0c\u65e0\u6cd5\u751f\u6210\u7f6e\u6807\u4ee3\u7801\uff01"));
        }
        int nCount = CMyTemplateWizard.getTemplateList().size();
        CMyXMLElement anElement = null;
        for (int i = 0; i < nCount; ++i) {
            anElement = (CMyXMLElement)CMyTemplateWizard.getTemplateList().get(i);
            if (anElement == null || !String.valueOf(_nTempId).equals(anElement.getProperty("TempID"))) continue;
            return anElement;
        }
        return null;
    }

    private static Map convertToParametersMap(String _sXMLString) throws WCMException {
        try {
            CMyXMLElement anElement = CMyXMLParser.strToElement(_sXMLString);
            if (anElement == null) {
                throw new WCMException(154, I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label6", "\u5bf9\u4f20\u5165\u7684\u6a21\u677f\u53c2\u6570XML\u6570\u636e\u89e3\u6790\u5931\u8d25\uff01"));
            }
            return anElement.getProperties();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label7", "\u8f6c\u6362XML\u5931\u8d25\uff01"));
        }
    }

    private static String createTemplateCoding(String sContent, Map _variables) throws WCMException {
        StringBuffer buffResult = null;
        StringBuffer buffVarName = null;
        try {
            char[] chrArray = sContent.toCharArray();
            int nPos = 0;
            int nLength = chrArray.length;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '[') {
                    buffVarName = new StringBuffer(16);
                    while (true) {
                        int n = ++nPos;
                        ++nPos;
                        aChar = chrArray[n];
                        if (aChar == ']') break;
                        buffVarName.append(aChar);
                    }
                    String sVarName = buffVarName.toString().toUpperCase();
                    buffVarName.setLength(0);
                    String sParameterValue = (String)_variables.get(sVarName = sVarName.toLowerCase());
                    if (sParameterValue == null) continue;
                    sParameterValue = sParameterValue.replaceAll("\"", "'");
                    buffResult.append(sVarName);
                    buffResult.append("=\"");
                    buffResult.append(sParameterValue);
                    buffResult.append("\"");
                    continue;
                }
                buffResult.append(aChar);
            }
            String string = buffResult.toString();
            return string;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to parse the variables in content!", ex);
        }
        finally {
            if (buffResult != null) {
                buffResult.setLength(0);
            }
            if (buffVarName != null) {
                buffVarName.setLength(0);
            }
        }
    }

    private static String getTemplateContent(int _nTempId) throws WCMException {
        CMyXMLElement anElement = CMyTemplateWizard.getElement(_nTempId);
        if (anElement == null) {
            throw new WCMException(152, I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label1", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + _nTempId + I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label2", "]\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\uff01"));
        }
        String sContent = anElement.getProperty("Body");
        if (sContent == null) {
            throw new WCMException(152, I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label3", "\u83b7\u53d6ID\u4e3a[") + _nTempId + I18NMessage.get(CMyTemplateWizard.class, "CMyTemplateWizard.label8", "]\u6a21\u677f\u7684\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25\uff01"));
        }
        return sContent;
    }
}

