/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.portal;

import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.MyBaseObj;
import com.trs.infra.persistent.MyBaseObjs;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.IChannelService;
import com.trs.service.IRecentService;
import com.trs.service.IWCMProcessService;
import com.trs.service.ServiceHelper;

public class PortalHelper {
    public static String getRecentDocs(int _nMaxSize, int _nMaxLength) throws WCMException {
        String strXMLInfo = null;
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IRecentService recentService = ServiceHelper.createRecentService();
        WCMFilter recentFilter = null;
        recentFilter = _nMaxSize > 0 ? new WCMFilter("", "", "", "DOCID, CHNLID", _nMaxSize) : new WCMFilter("", "", "", "DOCID, CHNLID");
        ChnlDocs recentChnlDocs = null;
        try {
            recentChnlDocs = recentService.getChnlDocs(recentFilter);
        }
        catch (Exception ex) {
            recentChnlDocs = null;
        }
        int nRecentDocCount = recentChnlDocs != null ? recentChnlDocs.size() : 0;
        ChnlDoc currChnlDoc = null;
        Document currDocument = null;
        Channel currChannel = null;
        for (int i = 0; i < nRecentDocCount; ++i) {
            currChnlDoc = (ChnlDoc)recentChnlDocs.getAt(i);
            if (currChnlDoc == null || (currDocument = currChnlDoc.getDocument()) == null || (currChannel = currChnlDoc.getChannel()) == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("RECID", currChnlDoc.getId());
            myBaseObj.setProperty("DOCID", currChnlDoc.getDocId());
            myBaseObj.setProperty("CHNLID", currChnlDoc.getChannelId());
            Status status = currDocument.getStatus();
            myBaseObj.setProperty("DOCSTATUSDESC", status != null ? status.getDisp() : I18NMessage.get(PortalHelper.class, "PortalHelper.label1", "\u672a\u77e5"));
            myBaseObj.setProperty("DOCTITLE", CMyString.truncateStr(currDocument.getTitle(), _nMaxLength));
            myBaseObj.setProperty("CHNLDESC", currChannel.getDesc());
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        ObjToXmlConverter aXMLConvert = new ObjToXmlConverter();
        strXMLInfo = aXMLConvert.toXMLString(myBaseObjs);
        return strXMLInfo;
    }

    public static String getRecentChannels(int _nMaxSize) throws WCMException {
        String strXMLInfo = null;
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IRecentService recentService = ServiceHelper.createRecentService();
        WCMFilter recentFilter = null;
        recentFilter = _nMaxSize > 0 ? new WCMFilter("", "", "", "DOCID, CHNLID", _nMaxSize) : new WCMFilter("", "", "", "DOCID, CHNLID");
        Channels recentChannels = null;
        try {
            recentChannels = recentService.getChannels(recentFilter);
        }
        catch (Exception ex) {
            recentChannels = null;
        }
        int nRecentChannleCount = recentChannels != null ? recentChannels.size() : 0;
        Channel currChannel = null;
        for (int i = 0; i < nRecentChannleCount; ++i) {
            currChannel = (Channel)recentChannels.getAt(i);
            if (currChannel == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("CHNLID", currChannel.getId());
            myBaseObj.setProperty("CHNLDESC", currChannel.getDesc());
            myBaseObj.setProperty("SITEDESC", currChannel.getSite().getDesc());
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        ObjToXmlConverter aXMLConvert = new ObjToXmlConverter();
        strXMLInfo = aXMLConvert.toXMLString(myBaseObjs);
        return strXMLInfo;
    }

    public static String getMyFlowDocs(int _nMaxSize, int _nMaxLength) throws WCMException {
        String strXMLInfo = null;
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IWCMProcessService currProcessService = ServiceHelper.createWCMProcessService();
        WCMFilter filter = null;
        filter = _nMaxSize > 0 ? new WCMFilter("", "", "", "", _nMaxSize) : new WCMFilter("", "", "", "");
        FlowDocs myFlowDocs = null;
        try {
            myFlowDocs = currProcessService.getFlowDocs(1, filter);
        }
        catch (Exception ex) {
            myFlowDocs = null;
        }
        int nCount = myFlowDocs != null ? myFlowDocs.size() : 0;
        FlowDoc currFlowDoc = null;
        IFlowContent currFlowContent = null;
        for (int i = 0; i < nCount; ++i) {
            currFlowDoc = (FlowDoc)myFlowDocs.getAt(i);
            if (currFlowDoc == null || (currFlowContent = currFlowDoc.getFlowContent()) == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("FLOWDOCID", currFlowDoc.getId());
            myBaseObj.setProperty("CONTENTTYPE", currFlowContent.getContentType());
            myBaseObj.setProperty("DOCUMENTID", currFlowContent.getSubinstanceId());
            myBaseObj.setProperty("CONTENTSHOWPAGE", currFlowContent.getContentShowPage());
            myBaseObj.setProperty("CONTENTDESC", CMyString.truncateStr(currFlowContent.getDesc(), _nMaxLength));
            myBaseObj.setProperty("POSTUSERNAME", currFlowDoc.getPostUserName());
            myBaseObj.setProperty("POSTTIME", currFlowDoc.getPostTime().toString("MM-dd HH:mm"));
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        ObjToXmlConverter aXMLConvert = new ObjToXmlConverter();
        strXMLInfo = aXMLConvert.toXMLString(myBaseObjs);
        return strXMLInfo;
    }

    public static String getDocumentsByChannelId(int _nChannelId, int _nMaxSize, int _nMaxLength) throws WCMException {
        String strXMLInfo = null;
        ObjToXmlConverter aXMLConvert = new ObjToXmlConverter();
        MyBaseObjs myBaseObjs = new MyBaseObjs();
        IChannelService currChannelService = ServiceHelper.createChannelService();
        Channel currChannel = Channel.findById(_nChannelId);
        if (currChannel == null) {
            return aXMLConvert.toXMLString(myBaseObjs);
        }
        WCMFilter filter = null;
        filter = _nMaxSize > 0 ? new WCMFilter("", "", "", "DOCID,DOCTITLE,DOCSTATUS", _nMaxSize) : new WCMFilter("", "", "", "DOCID,DOCTITLE,DOCSTATUS");
        Documents currDocuments = null;
        try {
            currDocuments = currChannelService.getDocuments(currChannel, filter);
        }
        catch (Exception ex) {
            currDocuments = null;
        }
        int nCount = currDocuments != null ? currDocuments.size() : 0;
        Document currDocument = null;
        for (int i = 0; i < nCount; ++i) {
            currDocument = (Document)currDocuments.getAt(i);
            if (currDocument == null) continue;
            MyBaseObj myBaseObj = new MyBaseObj();
            myBaseObj.setId(i + 1);
            myBaseObj.setProperty("DOCID", currDocument.getId());
            myBaseObj.setProperty("DOCTITLE", CMyString.truncateStr(currDocument.getTitle(), _nMaxLength));
            myBaseObj.setProperty("CHNLID", currChannel.getId());
            myBaseObj.setProperty("STATUSNAME", currDocument.getStatusName());
            myBaseObj.setAddMode(false);
            myBaseObjs.addElement(myBaseObj);
        }
        strXMLInfo = aXMLConvert.toXMLString(myBaseObjs);
        return strXMLInfo;
    }

    public static void main(String[] args) {
    }
}

