/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.ids;

import com.trs.idm.client.actor.SSOUser;
import com.trs.infra.cache.CacheLayer;
import com.trs.infra.common.BaseContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOContextHelper {
    private static final Logger log = LoggerFactory.getLogger(SSOContextHelper.class);
    private static final int ARG_INDEX_USER = BaseContextHelper.getNextIndex();
    public static final int CONTEXT_INDEX_IP = BaseContextHelper.getNextIndex();

    private SSOContextHelper() {
    }

    public static void initContext(SSOUser loginUser) {
        SSOContextHelper.setLoginUser(loginUser);
    }

    public static SSOUser getLoginUser() {
        SSOUser loginUser = (SSOUser)BaseContextHelper.getArg(ARG_INDEX_USER);
        if (loginUser == null) {
            throw new RuntimeException("fatal error:no current user in threadlocal,iniContext please!");
        }
        return loginUser;
    }

    public static void setLoginUser(SSOUser currUser) {
        BaseContextHelper.setArg(ARG_INDEX_USER, currUser);
    }

    public static Object getArg(int nIndex) {
        return BaseContextHelper.getArg(nIndex);
    }

    public static int setArg(int nIndex, Object currObj) {
        return BaseContextHelper.setArg(nIndex, currObj);
    }

    public static void clear() {
        BaseContextHelper.clear();
        CacheLayer.clear();
    }
}

