/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dataprocess;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.upgrade.DbConfig;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;

public class DocRightSetRightIndex {
    private String dbconf;

    public DocRightSetRightIndex(String dbconf) {
        this.dbconf = dbconf;
    }

    public void doAction() throws Exception {
        int count;
        Iterator itrUser;
        StringBuffer strWhere;
        DbConfig config = new DbConfig();
        config.load(this.dbconf);
        Class.forName(config.getJdbcDriver());
        Connection conn = DriverManager.getConnection(config.getOldUrl(), config.getOldUser(), config.getOldPasswd());
        String sql = "select RIGHTID,RIGHTVALUE,OPRTYPE,OPRID from " + CMyString.filterForSQL2(config.getBakTable4WcmRight());
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        HashSet<RightValue> rights = new HashSet<RightValue>(500, 0.2f);
        HashSet<String> userSet = new HashSet<String>(100, 0.2f);
        HashSet<String> groupSet = new HashSet<String>(50, 1.0f);
        HashSet<String> roleSet = new HashSet<String>(50, 1.0f);
        while (rs.next()) {
            RightValue rv = new RightValue(rs.getInt(1), rs.getLong(2));
            if (!rv.modified) continue;
            rights.add(rv);
            switch (rs.getInt(3)) {
                case 201: {
                    groupSet.add(rs.getString(4));
                    break;
                }
                case 203: {
                    roleSet.add(rs.getString(4));
                    break;
                }
                case 204: {
                    userSet.add(rs.getString(4));
                    break;
                }
            }
        }
        rs.close();
        if (rights.isEmpty()) {
            stmt.close();
            conn.close();
            return;
        }
        sql = "update WCMRIGHT set RIGHTVALUE=? where RIGHTID=?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        Iterator itr = rights.iterator();
        if (conn.getMetaData().supportsBatchUpdates()) {
            conn.setAutoCommit(false);
            int count2 = 1;
            while (itr.hasNext()) {
                RightValue rv = (RightValue)itr.next();
                pstmt.setLong(1, rv.value);
                pstmt.setInt(2, rv.id);
                pstmt.addBatch();
                if (++count2 != 1000) continue;
                pstmt.executeBatch();
                count2 = 0;
            }
            pstmt.executeBatch();
            conn.commit();
            conn.setAutoCommit(true);
        } else {
            while (itr.hasNext()) {
                RightValue rv = (RightValue)itr.next();
                pstmt.setLong(1, rv.value);
                pstmt.setInt(2, rv.id);
                pstmt.executeUpdate();
            }
        }
        rights.clear();
        pstmt.close();
        if (!userSet.isEmpty()) {
            StringBuffer usersql = new StringBuffer(userSet.size() * 4);
            strWhere = new StringBuffer(roleSet.size() * 4);
            usersql.append("select username from wcmuser where ");
            strWhere.append("userid in (");
            itrUser = userSet.iterator();
            count = 0;
            while (itrUser.hasNext()) {
                strWhere.append(itrUser.next());
                if (count == 900) {
                    count = 0;
                    strWhere.append(')');
                    if (!itrUser.hasNext()) continue;
                    strWhere.append(" or userid in(");
                    continue;
                }
                if (itrUser.hasNext()) {
                    strWhere.append(',');
                    continue;
                }
                strWhere.append(')');
            }
            usersql = usersql.append(CMyString.filterForSQL2(strWhere.toString()));
            userSet.clear();
            rs = stmt.executeQuery(usersql.toString());
            usersql.setLength(0);
            strWhere.setLength(0);
            while (rs.next()) {
                userSet.add(rs.getString(1));
            }
            rs.close();
            if (!userSet.isEmpty()) {
                System.out.println("\u7528\u6237\u7684\u8bbe\u7f6e\u6587\u6863\u6743\u9650\u7684\u6743\u9650: " + userSet);
            }
            userSet.clear();
        }
        if (!groupSet.isEmpty()) {
            StringBuffer groupsql = new StringBuffer(groupSet.size() * 4);
            strWhere = new StringBuffer(roleSet.size() * 4);
            groupsql.append("select gname from wcmgroup where ");
            strWhere.append("groupid in (");
            itrUser = groupSet.iterator();
            count = 0;
            while (itrUser.hasNext()) {
                strWhere.append(itrUser.next());
                if (count == 900) {
                    count = 0;
                    strWhere.append(')');
                    if (!itrUser.hasNext()) continue;
                    strWhere.append(" or userid in(");
                    continue;
                }
                if (itrUser.hasNext()) {
                    strWhere.append(',');
                    continue;
                }
                strWhere.append(')');
            }
            groupsql = groupsql.append(CMyString.filterForSQL2(strWhere.toString()));
            groupSet.clear();
            rs = stmt.executeQuery(groupsql.toString());
            groupsql.setLength(0);
            strWhere.setLength(0);
            while (rs.next()) {
                groupSet.add(rs.getString(1));
            }
            rs.close();
            if (!groupSet.isEmpty()) {
                System.out.println("\u7ec4\u7ec7\u7684\u8bbe\u7f6e\u6587\u6863\u6743\u9650\u7684\u6743\u9650: " + groupSet);
            }
            groupSet.clear();
        }
        if (!roleSet.isEmpty()) {
            StringBuffer rolesql = new StringBuffer(roleSet.size() * 4);
            strWhere = new StringBuffer(roleSet.size() * 4);
            rolesql.append("select rolename from wcmrole where ");
            strWhere.append("userid in (");
            itrUser = roleSet.iterator();
            count = 0;
            while (itrUser.hasNext()) {
                strWhere.append(itrUser.next());
                if (count == 900) {
                    count = 0;
                    strWhere.append(')');
                    if (!itrUser.hasNext()) continue;
                    strWhere.append(" or userid in(");
                    continue;
                }
                if (itrUser.hasNext()) {
                    strWhere.append(',');
                    continue;
                }
                strWhere.append(')');
            }
            rolesql = rolesql.append(CMyString.filterForSQL2(strWhere.toString()));
            roleSet.clear();
            rs = stmt.executeQuery(rolesql.toString());
            rolesql.setLength(0);
            strWhere.setLength(0);
            while (rs.next()) {
                roleSet.add(rs.getString(1));
            }
            rs.close();
            if (!roleSet.isEmpty()) {
                System.out.println("\u89d2\u8272\u7684\u8bbe\u7f6e\u6587\u6863\u6743\u9650\u7684\u6743\u9650: " + roleSet);
            }
            roleSet.clear();
        }
        conn.close();
    }

    public static void main(String[] args) throws Exception {
        String dbconf = null;
        if (args.length > 0) {
            dbconf = args[0];
        }
        DocRightSetRightIndex index = new DocRightSetRightIndex(dbconf);
        index.doAction();
    }

    private static class RightValue {
        private static final int NEW_RIGHTINDEX = 61;
        private static final int OLD_RIGHTINDEX = 54;
        int id;
        long value;
        boolean modified = false;

        public RightValue(int id, long value) {
            this.id = id;
            BigInteger bigInt = BigInteger.valueOf(value);
            if (bigInt.testBit(54)) {
                bigInt = bigInt.clearBit(54).setBit(61);
                this.modified = true;
                this.value = bigInt.longValue();
            } else {
                this.value = value;
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(64);
            buff.append("Right:").append(this.id).append('=').append(this.value);
            return buff.toString();
        }
    }
}

