/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade;

import com.trs.infra.util.store.FileService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DbConfig {
    private static final String CONF = "/database.conf";
    private String dbtype;
    private String jdbcDriver;
    private String bakTable4WcmRight;
    private String oldUser;
    private String oldPasswd;
    private String oldUrl;
    private String newUser;
    private String newPasswd;
    private String newUrl;

    public void load(String fn) {
        InputStream ins = null;
        if (fn != null) {
            try {
                ins = new FileService(fn).getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ins == null) {
            ins = DbConfig.class.getResourceAsStream(CONF);
        }
        if (ins == null) {
            ins = DbConfig.class.getResourceAsStream(CONF.substring(1));
        }
        this.load(ins);
    }

    public void load(InputStream ins) {
        Properties props = new Properties();
        try {
            props.load(ins);
        }
        catch (IOException e) {
            System.out.println("Can't load database config.");
            e.printStackTrace(System.out);
            return;
        }
        this.dbtype = props.getProperty("dbtype", "mssql");
        this.jdbcDriver = props.getProperty("jdbcdriver");
        this.oldUser = props.getProperty("old.db.user");
        this.oldPasswd = props.getProperty("old.db.passwd");
        this.oldUrl = props.getProperty("old.db.url");
        this.newUser = props.getProperty("new.db.user");
        this.newPasswd = props.getProperty("new.db.passwd");
        this.newUrl = props.getProperty("new.db.url");
        this.bakTable4WcmRight = props.getProperty("wcmright.bak");
        props.clear();
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getOldUser() {
        return this.oldUser;
    }

    public String getOldPasswd() {
        return this.oldPasswd;
    }

    public String getOldUrl() {
        return this.oldUrl;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public String getNewPasswd() {
        return this.newPasswd;
    }

    public String getNewUrl() {
        return this.newUrl;
    }

    public String getOldSchema() {
        if ("oracle".equals(this.dbtype) || "db2".equals(this.dbtype)) {
            return this.oldUser.toUpperCase();
        }
        return null;
    }

    public String getNewSchema() {
        if ("oracle".equals(this.dbtype) || "db2".equals(this.dbtype)) {
            return this.newUser.toUpperCase();
        }
        return null;
    }

    public String getBakTable4WcmRight() {
        return this.bakTable4WcmRight;
    }
}

