/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.job;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;

public class JobFailedResult
extends BaseObj {
    private int m_nJobId = 0;
    private String m_sRootCauseMessage = null;
    public static final String DB_TABLE_NAME = "WCMJOBEXERESULT";
    public static final String DB_ID_NAME = "RESULTID";

    public JobFailedResult() {
    }

    public JobFailedResult(int _nJobId, Exception _rootCause) {
        this.m_nJobId = _nJobId;
        if (_rootCause instanceof WCMException) {
            WCMException rootCause = (WCMException)_rootCause;
            this.m_sRootCauseMessage = rootCause.getMyMessage();
            if (rootCause.getRootCause() != null) {
                this.m_sRootCauseMessage = this.m_sRootCauseMessage + " " + rootCause.getRootCause().getMessage();
            }
        } else {
            this.m_sRootCauseMessage = _rootCause.getMessage();
        }
        if (this.m_sRootCauseMessage == null) {
            this.m_sRootCauseMessage = _rootCause.toString();
        }
    }

    @Override
    public int getWCMType() {
        return -1;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public void insert() throws WCMException {
        this.setProperty("JOBSCHEDULEID", this.m_nJobId);
        this.setProperty("JOBFAIELDROOTCAUSE", this.m_sRootCauseMessage);
        this.setProperty("CRTIME", CMyDateTime.now());
        super.insert();
    }

    @Override
    public void update() throws WCMException {
        throw new WCMException(1100, "unsupport!");
    }

    @Override
    public boolean isValid() {
        return this.m_sRootCauseMessage != null;
    }

    public static final JobFailedResult findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (JobFailedResult)BaseObj.findById(JobFailedResult.class, _nId);
    }

    public static final JobFailedResult createNewInstance() throws WCMException {
        return (JobFailedResult)BaseObj.createNewInstance(JobFailedResult.class);
    }

    public static final JobFailedResult findByKey(Object _oKey) throws WCMException {
        return (JobFailedResult)BaseObj.findByKey(JobFailedResult.class, _oKey);
    }
}

